/************************************************************************/
/*									*/
/*  Ted: Manipulation of TOC fields.					*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>

#   include	"tedEdit.h"
#   include	"tedLayout.h"
#   include	"docScreenLayout.h"
#   include	"docEvalField.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Refresh a table of contents.					*/
/*									*/
/************************************************************************/

static int tedRefreshTocField(		DocumentSelection *	dsAroundToc,
					TedEditOperation *	teo,
					DocumentField *		dfToc )
    {
    const LayoutContext *	lc= &(teo->teoLayoutContext);
    EditOperation *		eo= &(teo->teoEo);

    EditDocument *		ed= teo->teoEditDocument;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    int				headPart= -1;
    int				tailPart= -1;

    DocumentSelection		dsInsideToc;

    if  ( docRecalculateOneTocField( eo->eoBd, dfToc ) )
	{ LDEB(1); return -1;	}

    if  ( tedLayoutDocumentTree( td, &(teo->teoLayoutContext) ) )
	{ LDEB(1); return -1;	}

    {
    int			page= 0;
    BufferDocument *	bd= eo->eoBd;
    RecalculateFields	rf;

    docInitRecalculateFields( &rf );

    rf.rfBd= bd;
    rf.rfCloseObject= lc->lcCloseObject;
    rf.rfUpdateFlags= FIELDdoDOC_FORMATTED|FIELDdoDOC_COMPLETE|FIELDdoDOC_INFO;
    rf.rfFieldsUpdated= 0;

    if  ( docRecalculateTextLevelFieldsInExternalItem( &rf, &(bd->bdBody),
				    bd->bdBody.eiRoot->biChildren[0], page ) )
	{ LDEB(1); return -1;	}

    if  ( rf.rfFieldsUpdated > 0				&&
	  tedLayoutDocumentTree( td, &(teo->teoLayoutContext) )	)
	{ LDEB(1); return -1;	}
    }

    if  ( docDelimitFieldInDoc( &dsInsideToc, dsAroundToc,
				    &headPart, &tailPart, eo->eoBd, dfToc ) )
	{ LDEB(1); return -1; }

    docEditIncludeItemInReformatRange( eo, dsAroundToc->dsHead.dpBi );
    docEditIncludeItemInReformatRange( eo, dsAroundToc->dsTail.dpBi );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Insert a table of contents.						*/
/*									*/
/************************************************************************/

void tedDocAddTocField(		EditDocument *		ed,
				const TocField *	tf )
    {
    MemoryBuffer		mbFieldInst;
    DocumentSelection		dsAroundToc;

    TedEditOperation		teo;
    EditOperation *		eo= &(teo.teoEo);

    SelectionGeometry		sg;
    SelectionDescription	sd;

    TextAttribute		taSet;
    PropertyMask		taSetMask;

    int				headPart;
    int				tailPart;

    DocumentField *		dfToc;

    utilInitMemoryBuffer( &mbFieldInst );

    if  ( docTocFieldSetTocInstructions( &mbFieldInst, tf ) )
	{ LDEB(1); goto ready;	}

    utilInitTextAttribute( &taSet );
    utilPropMaskClear( &taSetMask );

    tedStartEditOperation( &teo, &sg, &sd, ed, 0 );

    if  ( eo->eoSelectionScope.ssInExternalItem != DOCinBODY )
	{ LDEB(eo->eoSelectionScope.ssInExternalItem); return;	}

    if  ( tedDocReplaceSelectionWithField( &dfToc,
					&headPart, &tailPart, &dsAroundToc,
					&teo, &mbFieldInst, DOCfkTOC,
					&taSetMask, &taSet ) )
	{ LDEB(1); goto ready;	}

    if  ( tedRefreshTocField( &dsAroundToc, &teo, dfToc ) )
	{ LDEB(1);	}

    tedEditFinishSelection( &teo, &dsAroundToc );

    /*  5  */
    tedAdaptToolsToSelection( ed );

    appDocumentChanged( ed, 1 );

  ready:
    utilCleanMemoryBuffer( &mbFieldInst );

    return;
    }

void tedDocSetTocField(		EditDocument *		ed,
				const TocField *	tf )
    {
    TedEditOperation		teo;
    EditOperation *		eo= &(teo.teoEo);

    SelectionGeometry		sg;
    SelectionDescription	sd;

    DocumentField *		dfToc;
    DocumentSelection		dsAroundToc;

    tedStartEditOperation( &teo, &sg, &sd, ed, 0 );

    dfToc= docFindTypedFieldForPosition( eo->eoBd, &(eo->eoHeadDp), DOCfkTOC );
    if  ( ! dfToc )
	{ XDEB(dfToc); return;	}

    if  ( docTocFieldSetToc( dfToc, tf ) )
	{ LDEB(1); return;	}

    if  ( tedRefreshTocField( &dsAroundToc, &teo, dfToc ) )
	{ LDEB(1);	}

    tedEditFinishSelection( &teo, &dsAroundToc );

    /*  5  */
    tedAdaptToolsToSelection( ed );

    appDocumentChanged( ed, 1 );

    return;
    }

void tedDocDeleteTocField(	EditDocument *		ed )
    { tedDocFlattenTypedField( ed, DOCfkTOC );	}

