/************************************************************************/
/*									*/
/*  Ted: Interface to the generic spell tool.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	"tedFind.h"
#   include	"tedFormatTool.h"
#   include	"tedSpellTool.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Switch to the spell page of the inspector.				*/
/*									*/
/************************************************************************/

void tedFormatShowSpellPage(	EditApplication *	ea )
    {
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;

    if  ( ! tar->tarInspector )
	{ XDEB(tar->tarInspector); return;	}

    appEnableInspectorSubject( tar->tarInspector, TEDtsiSPELL, 1 );

    appInspectorSelectSubject( tar->tarInspector, TEDtsiSPELL );

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt find tool to the current document.				*/
/*									*/
/************************************************************************/

void tedRefreshSpellTool(	SpellTool *			ast,
				int *				pEnabled,
				int *				pPref,
				InspectorSubject *		is,
				const DocumentSelection *	ds,
				const SelectionDescription *	sd,
				const BufferDocument *		bd,
				int				documentId )
    {
    if  ( sd->sdDocumentReadonly			||
	  ! ast->astSpellChecker			||
	  ast->astSpellChecker->scDictionaryCount == 0	)
	{ *pEnabled= 0; return;		}

    appSpellToolEnableCorrect( ast, sd->sdCanReplace );

    return;
    }

/************************************************************************/
/*									*/
/*  Build a find tool and connect it to Ted.				*/
/*									*/
/************************************************************************/

static SpellChecker TED_SpellChecker;
static int TED_SpellCheckerInitialized;

void tedFillSpellTool(		SpellTool *			ast,
				const SpellToolResources *	astr,
				AppInspector *			ai,
				int				subjectPage,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr )
    {
    if  ( ! TED_SpellCheckerInitialized )
	{
	indInitSpellChecker( &TED_SpellChecker );

	TED_SpellChecker.scSetup= indSpellSetup;
	TED_SpellChecker.scFindNext= tedSpellFindNext;
	TED_SpellChecker.scCorrect= tedAppReplace;

	TED_SpellCheckerInitialized= 1;
	}

    appFillSpellTool( &TED_SpellChecker,
			    ast, astr, ai, subjectPage, is, pageWidget, isr );

    return;
    }
