/************************************************************************/
/*									*/
/*  Geometry calculations when looking for a position in the document.	*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<limits.h>
#   include	<math.h>

#   include	"tedApp.h"
#   include	"tedLayout.h"
#   include	"docScreenLayout.h"
#   include	"docPageGrid.h"
#   include	"docPixels.h"
#   include	"docDraw.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Return the X position for an I bar.					*/
/*									*/
/************************************************************************/

static int tedCalculateX(	const BufferItem *	paraBi,
				const TextLine *	tl,
				const TextParticule *	tp,
				int			part,
				int			x0FramePixels,
				const LayoutContext *	lc,
				int			stroff )
    {
    AppDrawingData *		add= lc->lcAdd;
    BufferDocument *		bd= lc->lcDocument;
    double			xfac= add->addMagnifiedPixelsPerTwip;
    int				len;
    int				docXPixels;

    TextAttribute		ta;
    int				textAttr;
    int				screenFont;

    int				x0Pixels= x0FramePixels+ tp->tpXContentXPixels;
    int				pixelsWide= COORDtoGRID( xfac, tp->tpTwipsWide );

    switch( tp->tpKind )
	{
	case DOCkindOBJECT:
	case DOCkindTAB:
	case DOCkindCHFTNSEP:
	case DOCkindCHFTNSEPC:
	    len= stroff- tp->tpStroff;

	    if  ( len == 0 )
		{ docXPixels= x0Pixels;	}
	    else{
		if  ( len == 1 )
		    { docXPixels= x0Pixels+ pixelsWide;	}
		else{
		    LLDEB(stroff,tp->tpStroff);
		    docListParticule( 0, "???", tp-paraBi->biParaParticules,
								    paraBi, tp );
		    docListItem( 0, paraBi, 1 );
		    docXPixels= x0Pixels;
		    }
		}
	    return docXPixels;

	case DOCkindSPAN:
	    textAttr= tp->tpTextAttrNr;

	    screenFont= utilIndexMappingGet( lc->lcAttributeToScreenFont, textAttr );
	    if  ( screenFont < 0 )
		{ LLDEB(textAttr,screenFont); return x0Pixels;	}

	    utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList),
								textAttr );

	    len= stroff- tp->tpStroff;

	    if  ( len == tp->tpStrlen					&&
		  part+ 1 < tl->tlFirstParticule+ tl->tlParticuleCount	)
		{
		docXPixels= x0FramePixels+ tp[1].tpXContentXPixels;
		}
	    else{
		const char *	s= (char *)docParaString( paraBi, tp->tpStroff );

		docXPixels= x0Pixels+ docScreenTextWidth( screenFont, &ta,
							    lc, s, len );
		}

	    return docXPixels;

	case DOCkindFIELDSTART:
	case DOCkindFIELDEND:
	case DOCkindLINEBREAK:
	case DOCkindPAGEBREAK:
	case DOCkindCOLUMNBREAK:
	case DOCkindOPT_HYPH:
	    docXPixels= x0Pixels;
	    return docXPixels;

	default:
	    LDEB(tp->tpKind);
	    docXPixels= x0Pixels;
	    return docXPixels;
	}
    }

/************************************************************************/
/*									*/
/*  Calculate the smallest rectangle that contains the selection.	*/
/*									*/
/*  1)  Same paragraph?							*/
/*  1b) For a single position, widen to contain the whole I-Bar.	*/
/*  2)  Same table row?							*/
/*  3)  Expose the whole cell.						*/
/*									*/
/************************************************************************/

#   define	IW		5

static void tedSelectionRectangle(
				SelectionGeometry *		sg,
				const LayoutContext *		lc,
				const DocumentSelection *	ds,
				const BufferItem *		bodySectBi )
    {
    DocumentRectangle *		drSel= &(sg->sgRectangle);

    BlockFrame			bf;
    ParagraphFrame		pf;
    DocumentRectangle *		drParaContent= &(pf.pfParaContentRect);

    const TextLine *		tlBegin;
    const TextLine *		tlEnd;

    docLayoutInitBlockFrame( &bf );

    if  ( sg->sgBegin.pgLine < 0					||
	  sg->sgBegin.pgLine >= ds->dsHead.dpBi->biParaLineCount	)
	{ LLDEB(sg->sgBegin.pgLine,ds->dsHead.dpBi->biParaLineCount); return; }
    if  ( sg->sgEnd.pgLine < 0					||
	  sg->sgEnd.pgLine >= ds->dsTail.dpBi->biParaLineCount	)
	{ LLDEB(sg->sgEnd.pgLine,ds->dsTail.dpBi->biParaLineCount); return; }

    tlBegin= ds->dsHead.dpBi->biParaLines+ sg->sgBegin.pgLine;
    tlEnd= ds->dsTail.dpBi->biParaLines+ sg->sgEnd.pgLine;

    docPixelRectangleForPositions( drSel, &(sg->sgBegin), &(sg->sgEnd), lc );

    if  ( tlBegin->tlTopPosition.lpPage != tlEnd->tlTopPosition.lpPage ||
	  tlBegin->tlTopPosition.lpColumn != tlEnd->tlTopPosition.lpColumn )
	{
	LayoutPosition		lp;
	DocumentRectangle	dr;

	int			useColumns;

	useColumns= DOClayoutUSE_COLUMNS( ds->dsHead.dpBi->biInExternalItem );

	drSel->drX0= 0;
	drSel->drX1= INT_MAX;

	if  ( useColumns						&&
	      tlBegin->tlTopPosition.lpColumn < bodySectBi->biSectColumnCount- 1 )
	    {
	    docParaBlockFrameRectangle( &dr, ds->dsHead.dpBi, bodySectBi,
					    lc->lcDocument,
					    tlBegin->tlTopPosition.lpPage,
					    tlBegin->tlTopPosition.lpColumn );
	    lp= tlBegin->tlTopPosition;
	    lp.lpPageYTwips= dr.drY1;
	    lp.lpAtTopOfColumn= 0;

	    if  ( drSel->drY1 < LP_YPIXELS( lc->lcAdd, &lp ) )
		{ drSel->drY1=  LP_YPIXELS( lc->lcAdd, &lp );	}
	    }

	if  ( useColumns						&&
	      tlEnd->tlTopPosition.lpColumn > 0				)
	    {
	    docParaBlockFrameRectangle( &dr, ds->dsTail.dpBi, bodySectBi,
					    lc->lcDocument,
					    tlEnd->tlTopPosition.lpPage,
					    tlEnd->tlTopPosition.lpColumn );
	    lp= tlEnd->tlTopPosition;
	    lp.lpPageYTwips= dr.drY0;
	    lp.lpAtTopOfColumn= 1;

	    if  ( drSel->drY0 > LP_YPIXELS( lc->lcAdd, &lp ) )
		{ drSel->drY0=  LP_YPIXELS( lc->lcAdd, &lp );	}
	    }

	return;
	}

    /*  1  */
    if  ( ds->dsTail.dpBi == ds->dsHead.dpBi )
	{
	BufferItem *	paraBi= ds->dsHead.dpBi;

	if  ( sg->sgEnd.pgLine == sg->sgBegin.pgLine )
	    {
	    /*  1b  */
	    if  ( ds->dsTail.dpStroff == ds->dsHead.dpStroff )
		{
		drSel->drX0= sg->sgBegin.pgXPixels- IW;
		drSel->drX1= sg->sgEnd.pgXPixels+ IW;
		}
	    else{
		drSel->drX0= sg->sgBegin.pgXPixels;
		drSel->drX1= sg->sgEnd.pgXPixels;
		}

	    return;
	    }

	docBlockFrameTwips( &bf, paraBi, bodySectBi,
				    lc->lcDocument,
				    paraBi->biTopPosition.lpPage,
				    paraBi->biTopPosition.lpColumn );

	docParagraphFrameTwips( &pf, &bf, paraBi );

	if  ( paraBi->biParaFirstIndentTwips < 0 )
	    { drSel->drX0= X_PIXELS( lc->lcAdd, drParaContent->drX0+
				    paraBi->biParaFirstIndentTwips );	}
	else{ drSel->drX0= X_PIXELS( lc->lcAdd, drParaContent->drX0 );	}
	drSel->drX1= X_PIXELS( lc->lcAdd, drParaContent->drX1 );

	return;
	}

    /*  2  */
    if  ( ds->dsHead.dpBi->biParaTableNesting == 0	||
	  ds->dsTail.dpBi->biParaTableNesting == 0	||
	  ! docSelectionInsideRow( ds )			)
	{
	drSel->drX0= lc->lcAdd->addBackRect.drX0;
	drSel->drX1= lc->lcAdd->addBackRect.drX1;
	}

    /*  3  */
    if  ( ds->dsHead.dpBi->biParaTableNesting > 0 )
	{
	BufferItem *		paraBi= ds->dsHead.dpBi;
	DocumentRectangle	dr;

	docBlockFrameTwips( &bf, paraBi, bodySectBi,
				    lc->lcDocument,
				    paraBi->biTopPosition.lpPage,
				    paraBi->biTopPosition.lpColumn );

	docParagraphFrameTwips( &pf, &bf, paraBi );

	if  ( paraBi->biParaFirstIndentTwips < 0 )
	    { dr.drX0= X_PIXELS( lc->lcAdd, drParaContent->drX0+
				    paraBi->biParaFirstIndentTwips );	}
	else{ dr.drX0= X_PIXELS( lc->lcAdd, drParaContent->drX0 );		}
	dr.drX1= X_PIXELS( lc->lcAdd, drParaContent->drX1 );

	if  ( docSelectionInsideCell( ds ) )
	    {
	    dr.drY0= BI_TOP_PIXELS( lc->lcAdd, paraBi );
	    dr.drY1= BI_BELOW_PIXELS( lc->lcAdd, paraBi );
	    }
	else{
	    BufferItem *	rowBi= paraBi->biParent->biParent;

	    dr.drY0= BI_TOP_PIXELS( lc->lcAdd, rowBi );
	    dr.drY1= BI_BELOW_PIXELS( lc->lcAdd, rowBi );
	    }

	geoUnionRectangle( drSel, drSel, &dr );
	}

    /*  3  */
    if  ( ds->dsTail.dpBi->biParaTableNesting > 0 )
	{
	BufferItem *		paraBi= ds->dsTail.dpBi;
	DocumentRectangle	dr;

	docBlockFrameTwips( &bf, paraBi, bodySectBi,
				    lc->lcDocument,
				    paraBi->biTopPosition.lpPage,
				    paraBi->biTopPosition.lpColumn );

	docParagraphFrameTwips( &pf, &bf, paraBi );

	if  ( paraBi->biParaFirstIndentTwips < 0 )
	    { dr.drX0= X_PIXELS( lc->lcAdd, drParaContent->drX0+
				    paraBi->biParaFirstIndentTwips );	}
	else{ dr.drX0= X_PIXELS( lc->lcAdd, drParaContent->drX0 );		}
	dr.drX1= X_PIXELS( lc->lcAdd, drParaContent->drX1 );

	if  ( docSelectionInsideCell( ds ) )
	    {
	    dr.drY0= BI_TOP_PIXELS( lc->lcAdd, paraBi );
	    dr.drY1= BI_BELOW_PIXELS( lc->lcAdd, paraBi );
	    }
	else{
	    BufferItem *	rowBi= paraBi->biParent->biParent;

	    dr.drY0= BI_TOP_PIXELS( lc->lcAdd, rowBi );
	    dr.drY1= BI_BELOW_PIXELS( lc->lcAdd, rowBi );
	    }

	geoUnionRectangle( drSel, drSel, &dr );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Determine the poition on paper/screen of a certain position in the	*/
/*  document.								*/
/*									*/
/************************************************************************/

void tedPositionGeometry(	PositionGeometry *		pg,
				const DocumentPosition *	dp,
				const BufferItem *		bodySectBi,
				int				lastOne,
				const LayoutContext *		lc )
    {
    int			part;
    int			line;

    TextLine *		tl;
    TextParticule *	tp;

    BlockFrame		bf;
    ParagraphFrame	pf;

    int			x0FramePixels;

    if  ( docFindParticuleOfPosition( &part, dp, lastOne ) )
	{ LDEB(dp->dpStroff); return;	}

    if  ( docFindLineOfPosition( &line, dp, lastOne ) )
	{ LDEB(dp->dpStroff); return;	}

    tp= dp->dpBi->biParaParticules+ part;
    tl= dp->dpBi->biParaLines+ line;

    if  ( dp->dpStroff == tl->tlStroff+ tl->tlStrlen	&&
	  part < dp->dpBi->biParaParticuleCount		&&
	  line < dp->dpBi->biParaLineCount- 1		)
	{
	if  ( tp->tpKind == DOCkindLINEBREAK	||
	      tp->tpKind == DOCkindPAGEBREAK	||
	      tp->tpKind == DOCkindCOLUMNBREAK	)
	    { line++; tl++; part++; tp++;	}
	}

    docLayoutInitBlockFrame( &bf );
    docBlockFrameTwips( &bf, dp->dpBi, bodySectBi, lc->lcDocument,
					tl->tlTopPosition.lpPage,
					tl->tlTopPosition.lpColumn );
    docParagraphFrameTwips( &pf, &bf, dp->dpBi );

    pg->pgParaFrameX0= pf.pfCellContentRect.drX0;
    pg->pgParaFrameX1= pf.pfCellContentRect.drX1;
    pg->pgBlockFrameX0= bf.bfContentRect.drX0;
    pg->pgBlockFrameX1= bf.bfContentRect.drX1;

    pg->pgLine= line;
    pg->pgAfterBreak= 0;
    pg->pgAtLineHead= 0;
    pg->pgAtLineEnd= 0;
    if  ( dp->dpStroff == tl->tlStroff )
	{ pg->pgAtLineHead= 1;	}
    if  ( dp->dpStroff == tl->tlStroff+ tl->tlStrlen )
	{ pg->pgAtLineEnd= 1;	}

    if  ( pg->pgAtLineHead && line > 0 )
	{
	if  ( tp[-1].tpKind == DOCkindLINEBREAK	||
	      tp[-1].tpKind == DOCkindPAGEBREAK	)
	    { pg->pgAfterBreak= 1;	}
	}

    x0FramePixels= X_PIXELS( lc->lcAdd, pf.pfParaContentRect.drX0 );

    pg->pgXPixels= tedCalculateX( dp->dpBi, tl, tp, part,
					    x0FramePixels, lc, dp->dpStroff );
    pg->pgTopPosition= tl->tlTopPosition;
    pg->pgBasePosition= tl->tlTopPosition;
    pg->pgBottomPosition= tl->tlTopPosition;

    pg->pgBasePosition.lpPageYTwips -= tl->tlAscY0;
    pg->pgBottomPosition.lpPageYTwips += tl->tlLineStride;

#   if 0
    Gives silly high I Bar.
    if  ( sg->sgLine == bi->biParaLineCount- 1 )
	{ sg->sgY1 += bi->biParaSpaceAfterPixels; }
#   endif

    return;
    }

void tedSelectionGeometry(	SelectionGeometry *		sg,
				const DocumentSelection *	ds,
				const BufferItem *		bodySectBi,
				int				lastLine,
				const LayoutContext *		lc )
    {
    if  ( ds->dsDirection != 0 )
	{ lastLine= 0;	}

    tedPositionGeometry( &(sg->sgBegin), &(ds->dsHead), bodySectBi,
					    ds->dsDirection > 0 || lastLine,
					    lc );
    tedPositionGeometry( &(sg->sgAnchor), &(ds->dsAnchor), bodySectBi,
					    ds->dsDirection > 0 || lastLine,
					    lc );
    tedPositionGeometry( &(sg->sgEnd), &(ds->dsTail), bodySectBi,
					    lastLine,
					    lc );

    tedSelectionRectangle( sg, lc, ds, bodySectBi );

    return;
    }

