/************************************************************************/
/*									*/
/*  Ted: Management of the selection and the current position.		*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>
#   include	<limits.h>

#   include	"docPageGrid.h"
#   include	"tedApp.h"
#   include	"docScreenLayout.h"
#   include	"tedRuler.h"
#   include	"tedLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Is the selection a position between two chars?			*/
/*									*/
/************************************************************************/

int tedHasIBarSelection(	const TedDocument *   td )
    {
    return docIsIBarSelection( &(td->tdDocumentSelection) );
    }

int tedHasSelection(	const TedDocument *   td )
    {
    const DocumentSelection *	ds= &(td->tdDocumentSelection);

    if  ( ds->dsHead.dpBi )
	{ return 1;	}

    return 0;
    }

int tedGetSelection(	DocumentSelection *		ds,
			SelectionGeometry *		sg,
			SelectionDescription *		sd,
			DocumentTree **			pEi,
			const BufferItem **		pBodySectBi,
			const TedDocument *		td )
    {
    BufferDocument *		bd= td->tdDocument;
    const DocumentSelection *	dss= &(td->tdDocumentSelection);

    BufferItem *		bodySectBi= (BufferItem *)0;
    DocumentTree *		ei= (DocumentTree *)0;

    if  ( ! dss->dsHead.dpBi )
	{ return 1;	}

    if  ( pEi || pBodySectBi )
	{
	if  ( docGetRootForItem( &ei, &bodySectBi, bd, dss->dsHead.dpBi ) )
	    { LDEB(1); return -1;	}
	}

    *ds= td->tdDocumentSelection;
    *sg= td->tdSelectionGeometry;
    *sd= td->tdSelectionDescription;
    if  ( pBodySectBi )
	{ *pBodySectBi= bodySectBi;	}
    if  ( pEi )
	{ *pEi= ei;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Determine the derived properties such as line number and		*/
/*  coordinates of the current selection.				*/
/*									*/
/************************************************************************/

void tedDelimitCurrentSelection(	EditDocument *		ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentSelection		dsDoc;
    SelectionGeometry		sgDoc;
    SelectionDescription	sdDoc;

    const BufferItem *		bodySectBi;

    int				lastLine;

    LayoutContext		lc;

    layoutInitContext( &lc );
    tedSetLayoutContext( &lc, ed );

    if  ( tedGetSelection( &dsDoc, &sgDoc, &sdDoc,
				    (DocumentTree **)0, &bodySectBi, td ) )
	{ LDEB(1); return;	}

    lastLine= sdDoc.sdIsIBarSelection &&
				td->tdSelectionGeometry.sgBegin.pgAtLineHead;

    tedSelectionGeometry( &(td->tdSelectionGeometry), &dsDoc, bodySectBi,
							    lastLine, &lc );

    return;
    }

/************************************************************************/
/*									*/
/*  Remember the text attribute of the beginning of the selection.	*/
/*									*/
/************************************************************************/

void tedSetCurrentTextAttribute(	TedDocument *			td,
					int				IBar,
					const DocumentPosition *	dp )
    {
    const IndexMapping *	a2s= &(td->tdAttributeToScreenFont);
    int				textAttrNr;

    textAttrNr= docGetTextAttributeForInsert(
		     &(td->tdCurrentTextAttribute), td->tdDocument, IBar, dp );
    if  ( textAttrNr < 0 )
	{ return;	}

    td->tdCurrentTextAttributeNumber= textAttrNr;
    td->tdCurrentScreenFont= utilIndexMappingGet( a2s, textAttrNr );
    if  ( td->tdCurrentScreenFont < 0 )
	{ LLDEB(textAttrNr,td->tdCurrentScreenFont);	}

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt tools and rulers to the current position.			*/
/*									*/
/************************************************************************/

static void tedAdaptOptions(	TedDocument *			td,
				const SelectionDescription *	sd )
    {
    appGuiEnableWidget( td->tdCopyWidget,
				! sd->sdIsIBarSelection );

    appGuiEnableWidget( td->tdCutWidget,
				! sd->sdIsIBarSelection		&&
				( sd->sdCanReplace	||
				  sd->sdIsTableSlice	)	);

    appGuiEnableWidget( td->tdPasteWidget, sd->sdCanReplace );

    appGuiEnableWidget( td->tdInsPictOption, sd->sdCanReplace );
    appGuiEnableWidget( td->tdInsFileOption, sd->sdCanReplace );
    appGuiEnableWidget( td->tdInsSymbolOption, sd->sdCanReplace );

    appGuiEnableWidget( td->tdFormatOneParaOption,
			    ! sd->sdIsSingleParagraph	&&
			    sd->sdIsSingleCell );

    appGuiEnableWidget( td->tdInsInsertFootnoteOption,
				    sd->sdCanReplace		&&
				    sd->sdIsSingleParagraph	&&
				    sd->sdInDocumentBody	&&
				    ! sd->sdBeginInTableHeader	&&
				    ! sd->sdBeginInField	);

    appGuiEnableWidget( td->tdInsInsertEndnoteOption,
				    sd->sdCanReplace		&&
				    sd->sdIsSingleParagraph	&&
				    sd->sdInDocumentBody	&&
				    ! sd->sdBeginInTableHeader	&&
				    ! sd->sdBeginInField	);

    appGuiEnableWidget( td->tdInsHyperlinkOption,
				    sd->sdIsSingleParagraph		&&
				    ( sd->sdBeginInHyperlink	||
				      ! sd->sdIsIBarSelection	)	);

    appGuiEnableWidget( td->tdInsBookmarkOption,
				    sd->sdIsSingleParagraph		&&
				    ( sd->sdBeginInBookmark	||
				      ! sd->sdBeginInField	)	);

    appGuiEnableWidget( td->tdInsInsertChftnsepOption,
				    sd->sdCanReplace			&&
				    sd->sdIsSingleParagraph		&&
				    sd->sdInExternalItem == DOCinFTNSEP	);

    appGuiEnableWidget( td->tdInsInsertTableOption,
				    sd->sdCanReplace			&&
				    sd->sdIsSingleParagraph		&&
				    ! sd->sdBeginInTable		&&
				    ! sd->sdEndInTable			);
    appGuiEnableWidget( td->tdTabInsertTableOption,
				    sd->sdCanReplace			&&
				    sd->sdIsSingleParagraph		&&
				    ! sd->sdBeginInTable		&&
				    ! sd->sdEndInTable			);

    appGuiEnableWidget( td->tdInsInsertPageNumberOption, 
				    sd->sdCanReplace		&&
				    sd->sdIsSingleParagraph	&&
				    sd->sdInHeaderFooter	);

    appGuiEnableWidget( td->tdInsInsertLineBreakOption,
				    sd->sdCanReplace		&&
				    sd->sdIsSingleParagraph	);
    appGuiEnableWidget( td->tdInsInsertPageBreakOption,
				    sd->sdCanReplace		&&
				    sd->sdIsSingleParagraph	&&
				    sd->sdInDocumentBody	&&
				    ! sd->sdBeginInTable	&&
				    ! sd->sdEndInTable		);
    appGuiEnableWidget( td->tdInsInsertColumnBreakOption,
				    sd->sdCanReplace		&&
				    sd->sdIsSingleParagraph	&&
				    sd->sdBeginInMultiColumnSection	&&
				    sd->sdInDocumentBody	&&
				    ! sd->sdBeginInTable	&&
				    ! sd->sdEndInTable		);
    appGuiEnableWidget( td->tdInsInsertSectBreakOption,
				    sd->sdCanReplace		&&
				    sd->sdIsSingleParagraph	&&
				    sd->sdInDocumentBody	&&
				    ! sd->sdBeginInTable	&&
				    ! sd->sdEndInTable		);

    appGuiEnableWidget( td->tdTabAddRowOption,
				    sd->sdCanReplace		&&
				    sd->sdBeginInTable		);
    appGuiEnableWidget( td->tdTabAddColumnOption,
				    sd->sdCanReplace		&&
				    sd->sdBeginInTable		);

    appGuiEnableWidget( td->tdSelectTableWidget, sd->sdBeginInTable );
    appGuiEnableWidget( td->tdSelectRowWidget, sd->sdBeginInTable );
    appGuiEnableWidget( td->tdSelectColumnOption, sd->sdBeginInTable );

    appGuiEnableWidget( td->tdDeleteTableWidget,
				    ! sd->sdDocumentReadonly	&&
				    sd->sdBeginInTable		);
    appGuiEnableWidget( td->tdDeleteRowWidget,
				    ! sd->sdDocumentReadonly	&&
				    sd->sdBeginInTable		);
    appGuiEnableWidget( td->tdDeleteColumnOption,
				    ! sd->sdIsRowSlice		&&
				    ! sd->sdDocumentReadonly	&&
				    sd->sdBeginInTable		);

    return;
    }

void tedAdaptToolsToSelection(	EditDocument *		ed )
    {
    EditApplication *		ea= ed->edApplication;
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;
    DocumentTree *		ei;
    const BufferItem *		bodySectBi;

    if  ( tedGetSelection( &ds, &sg, &sd, &ei, &bodySectBi, td ) )
	{ LDEB(1); return;	}

    tedDocAdaptTopRuler( ed, &ds, &sg, &sd, bodySectBi );

    tedSetBottomRulerValues( ed->edBottomRuler,
			sd.sdEndPage,
			sd.sdDocumentPages,
			sd.sdEndSection,
			sd.sdDocumentSections );

    tedAdaptFontIndicatorsToSelection( ea, ed );

    tedAdaptOptions( td, &(td->tdSelectionDescription) );

    td->tdCanReplaceSelection= td->tdSelectionDescription.sdCanReplace;

    if  ( tar->tarInspector )
	{
	const int	choosePage= 0;

	tedFormatToolAdaptToSelection( tar->tarInspector, ed, choosePage, ei,
					    &(td->tdDocumentSelection),
					    &(td->tdSelectionGeometry),
					    &(td->tdSelectionDescription) );
	}
    }
