/************************************************************************/
/*									*/
/*  Format tool:							*/
/*									*/
/************************************************************************/

#   ifndef	TED_SECTION_TOOL_H
#   define	TED_SECTION_TOOL_H

/************************************************************************/
/*									*/
/*  Resources for the 'Section; page.					*/
/*									*/
/************************************************************************/

typedef struct SectionPageResources
    {
    const char *	sprUnitType;

    const char *	sprNumberingRestarts;

    const char *	sprPageNumberStyle;
    const char *	sprNumberStyleMenuTexts[DOCpgn_COUNT];

    const char *	sprBreakKind;
    const char *	sprBreakKindMenuTexts[DOCibk_COUNT];

    const char *	sprColumns;
    const char *	sprColumnCount;
    const char *	sprColumn;
    const char *	sprColumnWidth;
    const char *	sprColumnSpacing;
    const char *	sprLineBetweenColumns;
    const char *	sprColumnsEqualWidth;
    } SectionPageResources;

/************************************************************************/
/*									*/
/*  A section tool, i.e. the 'Section' page of the format tool.		*/
/*									*/
/************************************************************************/

# define SECT_MAX_COLUMNS	4

typedef struct SectionTool
    {
    EditApplication *			stApplication;
    AppInspector *			stInspector;
    const SectionPageResources *	stPageResources;

    int					stUnitInt;

    SectionProperties			stPropertiesSet;
    SectionProperties			stPropertiesChosen;
    int					stFixedCoulumnWidth;

    int					stSectionNumber;

    APP_WIDGET				stNumberText;

    APP_WIDGET				stPageRestartToggle;
    APP_WIDGET				stPageRestartText;

    AppOptionmenu			stNumberStyleOptionmenu;
    APP_WIDGET				stNumberStyleItems[DOCpgn_COUNT];

    AppOptionmenu			stBreakKindOptionmenu;
    APP_WIDGET				stBreakKindItems[DOCibk_COUNT];

    APP_WIDGET				stColumnsFrame;
    APP_WIDGET				stColumnsPaned;

    AppOptionmenu			stColumnCountMenu;
    APP_WIDGET				stColumnCountItems[SECT_MAX_COLUMNS+1];

    APP_WIDGET				stLineBetweenColumnsToggle;
    APP_WIDGET				stEqualWidthToggle;

    APP_WIDGET				stColumnRows[SECT_MAX_COLUMNS];
    APP_WIDGET				stColnoLabels[SECT_MAX_COLUMNS];
    APP_WIDGET				stColwTexts[SECT_MAX_COLUMNS];
    APP_WIDGET				stColsrTexts[SECT_MAX_COLUMNS];
    } SectionTool;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void tedFormatToolGetSectResourceTable(	EditApplication *	ea,
					SectionPageResources *		spr,
					InspectorSubjectResources *	isr );

extern void tedRefreshSectionTool(
				SectionTool *			st,
				int *				pEnabled,
				int *				pPref,
				InspectorSubject *		is,
				const DocumentSelection *	ds,
				const SelectionDescription *	sd,
				const BufferDocument *		bd );

extern void tedFormatCleanSectionTool(		SectionTool *		st );

#   endif	/*  TED_SECTION_TOOL_H */
