/************************************************************************/
/*									*/
/*  Ted: data structures and routines for on screen interactive		*/
/*  editing.								*/
/*									*/
/************************************************************************/

#   ifndef		TED_LAYOUT_H
#   define		TED_LAYOUT_H

#   include	"tedApp.h"
#   include	"docLayout.h"

/************************************************************************/
/*									*/
/*  Routine Declarations:						*/
/*									*/
/************************************************************************/

extern void tedSetLayoutContext(	LayoutContext *		lc,
					EditDocument *		ed );

extern int tedFindPositionInLine(
				DocumentPosition *		dp,
				PositionGeometry *		pg,
				const LayoutContext *		lc,
				const BufferItem *		paraBi,
				int				line,
				const BufferItem *		bodySectBi,
				int				docXPixels );

extern int tedFindPosition(	DocumentPosition *		dp,
				PositionGeometry *		pg,
				int *				pPage,
				int *				pColumn,
				BufferItem *			selRootBi,
				const BufferItem *		bodySectBi,
				const LayoutContext *		lc,
				int				x,
				int				y );

extern void tedPositionGeometry(PositionGeometry *		pg,
				const DocumentPosition *	dp,
				const BufferItem *		bodySectBi,
				int				lastOne,
				const LayoutContext *		lc );

extern void tedSelectionGeometry(
				SelectionGeometry *		sg,
				const DocumentSelection *	ds,
				const BufferItem *		bodySectBi,
				int				lastLine,
				const LayoutContext *		lc );

extern int tedArrowDown(	DocumentPosition *		bp,
				const PositionGeometry *	pg,
				const LayoutContext *		lc );

extern int tedArrowUp(		DocumentPosition *		bp,
				const PositionGeometry *	pg,
				const LayoutContext *		lc );

extern int tedLayoutDocumentTree(	TedDocument *		td,
					const LayoutContext *	lc );

extern void tedGetObjectRectangle(
				DocumentRectangle *		drObject,
				APP_POINT *			xp,
				const InsertedObject *		io,
				const PositionGeometry *	pg,
				const LayoutContext *		lc,
				const TedDocument *		td );

extern void tedSetObjectWindows(EditDocument *			ed,
				const PositionGeometry *	pg,
				const InsertedObject *		io,
				const LayoutContext *		lc );

extern int tedOpenItemObjects(	BufferItem *		bi,
				const LayoutContext *	lc );

extern int tedOpenExternalItemObjects(	DocumentTree *		ei,
					const LayoutContext *	lc );

extern int tedReopenObject(	TextParticule *		tp,
				const LayoutContext *	lc );

extern InsertedObject * tedObjectMakeBitmapObject(
					int *			pObjectNumber,
				    	EditDocument *		ed,
					BufferItem *		bi,
					const LayoutContext *	lc,
					AppBitmapImage *	abi );

extern int tedOpenObject(	InsertedObject *	io,
				const LayoutContext *	lc );

#   endif	/*	TED_LAYOUT_H	*/
