/************************************************************************/
/*									*/
/*  Ted: Handle user input.						*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"docScreenLayout.h"
#   include	"tedApp.h"
#   include	"tedRuler.h"
#   include	"tedLayout.h"

#   include	"appGuiKeys.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Just log events that pass by for debugging purposes.		*/
/*									*/
/*  NOTE the silly constuction to do away with the 'unused' compiler	*/
/*	 warning.							*/
/*									*/
/************************************************************************/

#   ifdef USE_MOTIF_AND_NEEDED

static void tedLogEvent(	Widget		w,
				void *		voided,
				XEvent *	event,
				Boolean *	pRefused )
    {
    EditDocument *		ed= (EditDocument *)voided;

    appDebug( "EVENT \"%s\": %s\n",
			ed->edTitle, APP_X11EventNames[event->type] );

    *pRefused= 1;

    if  ( ! event )
	{ return;	}
    if  ( ! event )
	{ tedLogEvent( w, voided, event, pRefused );	}
    }

#   endif

/************************************************************************/
/*									*/
/*  Handle keyboard input.						*/
/*									*/
/*  a)  Handle miscelaneous keysyms as keysyms, even if they have a	*/
/*	string representation.						*/
/*									*/
/************************************************************************/

static void tedInputSetSelectedPosition(
				EditDocument *			ed,
				const DocumentPosition *	dp,
				int				lastLine )
    {
    int			scrolledX= 0;
    int			scrolledY= 0;

    tedSetSelectedPosition( ed, dp, lastLine, &scrolledX, &scrolledY );

    tedAdaptToolsToSelection( ed );

    return;
    }

static void tedInputExtendSelection(	EditDocument *			ed,
					const DocumentPosition *	dpSet )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    if  ( tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ LDEB(1); return;	}

    tedExtendSelectionToPosition( ed, &(ds.dsAnchor), dpSet );

    tedAdaptToolsToSelection( ed );

    return;
    }

static void tedInputChangeSelection(
				EditDocument *			ed,
				unsigned int			keyState,
				const DocumentPosition *	dp,
				int				lastLine )
    {
    if  ( keyState & KEY_SHIFT_MASK )
	{
	tedInputExtendSelection( ed, dp );
	return;
	}

    tedInputSetSelectedPosition( ed, dp, lastLine );

    return;
    }

static int tedMoveRightOnKey(	DocumentPosition *	dpNew,
				BufferDocument *	bd,
				DocumentTree *		ei,
				int			keyState )
    {
    if  ( keyState & KEY_CONTROL_MASK )
	{
	if  ( docNextWord( dpNew ) )
	    { return -1;	}
	}
    else{
	if  ( docNextPosition( dpNew ) )
	    { return -1;	}
	}

    return 0;
    }

static int tedMoveLeftOnKey(	DocumentPosition *	dpNew,
				BufferDocument *	bd,
				DocumentTree *		ei,
				int			keyState )
    {
    if  ( keyState & KEY_CONTROL_MASK )
	{
	if  ( docPrevWord( dpNew ) )
	    { return -1;	}
	}
    else{
	if  ( docPrevPosition( dpNew ) )
	    { return -1;	}
	}

    return 0;
    }

static int tedStartEdit(	EditDocument *		ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    if  ( ! tedHasSelection( td ) || ! td->tdCanReplaceSelection )
	{
#	ifdef USE_MOTIF
	const AppDrawingData *	add= &(ed->edDocumentWidget.dwDrawingData);

	XBell( add->addDisplay, 0 );
#	endif

#	ifdef USE_GTK
	gdk_beep();
#	endif

	return 1;
	}

    tedStopCursorBlink( ed );
    return 0;
    }

void tedDocGotString(		void *			voided,
				const char *		str,
				int			length )
    {
    EditDocument *		ed= (EditDocument *)voided;

    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    DocumentTree *		ei;
    const BufferItem *		bodySectBi;

    if  ( tedStartEdit( ed ) )
	{ goto ready;	}

    if  ( tedGetSelection( &ds, &sg, &sd, &ei, &bodySectBi, td ) )
	{ LDEB(1); goto ready;	}

    tedDocReplaceSelection( ed, str, length );

  ready:

    if  ( tedHasIBarSelection( td ) )
	{ tedStartCursorBlink( ed );	}
    }

void tedDocGotKey(	void *		voided,
			int		keySym,
			unsigned int	state )
    {
    EditDocument *		ed= (EditDocument *)voided;

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    DocumentTree *		ei;
    const BufferItem *		bodySectBi;

    int				res;

    LayoutContext		lc;

    layoutInitContext( &lc );
    tedSetLayoutContext( &lc, ed );

    if  ( tedStartEdit( ed ) )
	{ goto ready;	}

    if  ( tedGetSelection( &ds, &sg, &sd, &ei, &bodySectBi, td ) )
	{ LDEB(1); goto ready;	}

    /* only interested in these 2 */
    state= state & ( KEY_CONTROL_MASK|KEY_SHIFT_MASK);

    switch( keySym )
	{
	DocumentPosition		dpNew;
	const PositionGeometry *	pgRef;

#	ifdef KEY_ISO_Left_Tab
	case  KEY_ISO_Left_Tab:
	    if  ( ds.dsHead.dpBi				&&
		  ds.dsHead.dpBi->biParaTableNesting > 0	&&
		  ! ( state & KEY_CONTROL_MASK )	)
		{ goto shiftTab;	}
	    else{ goto ready;		}
#	endif

	case KEY_i:
	    if  ( state != KEY_CONTROL_MASK )
		{ goto unknown; }
	    /*FALLTHROUGH*/
	case KEY_Tab:
	    if  ( ds.dsHead.dpBi				&&
		  ds.dsHead.dpBi->biParaTableNesting > 0	&&
		  ! ( state & KEY_CONTROL_MASK )	)
		{
		if  ( state & KEY_SHIFT_MASK )
		    {
		  shiftTab:
		    if  ( docFirstPosition( &dpNew,
					ds.dsHead.dpBi->biParent )	||
			  docPrevPosition( &dpNew )			)
			{ goto ready;	}
		    }
		else{
		    if  ( docLastPosition( &dpNew,
					ds.dsHead.dpBi->biParent )	||
			  docNextPosition( &dpNew )			)
			{ goto ready;	}
		    }

		{
		    const int	lastLine= 0;

		    tedInputSetSelectedPosition( ed, &dpNew, lastLine );
		}

		goto ready;
		}

	    if  ( state & KEY_SHIFT_MASK )
		{ goto ready;	}

	    if  ( ! td->tdCanReplaceSelection )
		{ goto ready;	}

	    tedEditReplaceSelectionWithTab( ed );

	    goto ready;

	case KEY_j: case KEY_m:
	    if  ( state != KEY_CONTROL_MASK )
		{ goto unknown; }
	    /*FALLTHROUGH*/
	case KEY_KP_Enter:
	case KEY_Return:
	    if  ( ! td->tdCanReplaceSelection )
		{ goto ready;	}

	    tedSplitParagraph( ed,
			    state == KEY_CONTROL_MASK	&&
			    keySym != KEY_j		&&
			    keySym != KEY_m		);

	    appDocumentChanged( ed, 1 );

	    goto ready;

	case KEY_KP_Delete:
	case KEY_Delete:

	    res= tedDeleteTableSliceSelection( ed );
	    if  ( res < 0 )
		{ LDEB(res); goto ready;	}
	    if  ( res == 0 )
		{ goto ready;		}

	    if  ( ! td->tdCanReplaceSelection )
		{ goto ready;	}

	    if  ( sd.sdIsIBarSelection )
		{
		dpNew= ds.dsTail;

		if  ( tedMoveRightOnKey( &dpNew, bd, ei, state ) )
		    { goto ready;	}

		if  ( ( ds.dsHead.dpBi->biParaTableNesting > 0	||
		        dpNew.dpBi->biParaTableNesting > 0	)	&&
		      ! docPositionsInsideCell( &(ds.dsHead), &dpNew )	)
		    {
		    const int		keyState= 0;
		    const int		lastLine= 1;

		    tedInputChangeSelection( ed, keyState, &dpNew, lastLine );
		    goto ready;
		    }

		if  ( tedMoveRightOnKey( &(ds.dsTail), bd, ei, state ) )
		    { goto ready;	}

		    {
		    int		scrolledX= 0;
		    int		scrolledY= 0;

		    tedSetSelection( ed, &ds, sg.sgBegin.pgAtLineHead,
						    &scrolledX, &scrolledY );
		    }
		}

	    tedDocReplaceSelection( ed, (const char *)0, 0 );

	    goto ready;

	case KEY_BackSpace:

	    res= tedDeleteTableSliceSelection( ed );
	    if  ( res < 0 )
		{ LDEB(res); goto ready;	}
	    if  ( res == 0 )
		{ goto ready;		}

	    if  ( ! td->tdCanReplaceSelection )
		{ goto ready;	}

	    if  ( sd.sdIsIBarSelection )
		{
		dpNew= ds.dsHead;

		if  ( tedMoveLeftOnKey( &dpNew, bd, ei, state ) )
		    { goto ready;	}

		if  ( ( dpNew.dpBi->biParaTableNesting > 0	||
		        ds.dsTail.dpBi->biParaTableNesting > 0	)	&&
		      ! docPositionsInsideCell( &dpNew, &(ds.dsTail) )	)
		    {
		    const int		keyState= 0;
		    const int		lastLine= 1;

		    tedInputChangeSelection( ed, keyState, &dpNew, lastLine );
		    goto ready;
		    }

		if  ( tedMoveLeftOnKey( &(ds.dsHead), bd, ei, state ) )
		    { goto ready;	}

		    {
		    int		scrolledX= 0;
		    int		scrolledY= 0;

		    tedSetSelection( ed, &ds, sg.sgBegin.pgAtLineHead,
						    &scrolledX, &scrolledY );
		    }
		}

	    tedDocReplaceSelection( ed, (const char *)0, 0 );
	    goto ready;

	case KEY_KP_Home:
	case KEY_Home:
	    if  ( ( state & KEY_CONTROL_MASK ) )
		{
		if  ( docFirstDocumentPosition( &dpNew, bd ) )
		    { goto ready;	}
		}
	    else{
		if  ( ( state & KEY_SHIFT_MASK ) && ds.dsDirection >= 0 )
		    {
		    dpNew= ds.dsTail;

		    if  ( docBeginOfLine( &dpNew, sg.sgEnd.pgAtLineHead ) )
			{ goto ready;	}
		    }
		else{
		    dpNew= ds.dsHead;

		    if  ( docBeginOfLine( &dpNew, sg.sgBegin.pgAtLineHead ) )
			{ goto ready;	}
		    }
		}

	    docAvoidParaHeadField( &dpNew, (int *)0, bd );

	    {
	    const int	lastLine= 1;

	    tedInputChangeSelection( ed, state, &dpNew, lastLine );
	    }
	    goto ready;

	case KEY_KP_End:
	case KEY_End:
	    if  ( ( state & KEY_CONTROL_MASK ) )
		{
		if  ( docLastDocumentPosition( &dpNew, bd ) )
		    { goto ready;	}
		}
	    else{
		if  ( ! ( state & KEY_SHIFT_MASK ) || ds.dsDirection >= 0 )
		    {
		    dpNew= ds.dsTail;

		    if  ( docEndOfLine( &dpNew, sg.sgEnd.pgAtLineHead ) )
			{ goto ready;	}
		    }
		else{
		    dpNew= ds.dsHead;

		    if  ( docEndOfLine( &dpNew, sg.sgBegin.pgAtLineHead ) )
			{ goto ready;	}
		    }
		}

	    {
	    const int	lastLine= 0;

	    tedInputChangeSelection( ed, state, &dpNew, lastLine );
	    }
	    goto ready;

	case KEY_KP_Left:
	case KEY_Left:
	    if  ( ! state			&&
		  sd.sdIsIBarSelection		&&
		  ds.dsHead.dpStroff > 0	&&
		  sg.sgBegin.pgAtLineHead	&&
		  ! sg.sgBegin.pgAfterBreak	&&
		  ! sg.sgBegin.pgAtLineEnd	)
		{
		const int	lastLine= 0;

		tedInputChangeSelection( ed, state, &(ds.dsHead), lastLine );
		goto ready;
		}

	    if  ( ( state & KEY_SHIFT_MASK ) && ds.dsDirection >= 0 )
		{ dpNew= ds.dsTail;	}
	    else{ dpNew= ds.dsHead;	}

	    if  ( state != 0		||
		  ! sd.sdIsListBullet	||
		  sd.sdIsIBarSelection	)
		{
		if  ( tedMoveLeftOnKey( &dpNew, bd, ei, state ) )
		    { goto ready;	}
		}

	    {
	    const int	lastLine= 1;

	    tedInputChangeSelection( ed, state, &dpNew, lastLine );
	    }
	    goto ready;

	case KEY_KP_Right:
	case KEY_Right:
	    if  ( ! state						&&
		  sd.sdIsIBarSelection					&&
		  ds.dsHead.dpStroff < docParaStrlen( ds.dsHead.dpBi )	&&
		  sg.sgBegin.pgAtLineEnd				&&
		  ! sg.sgBegin.pgAtLineHead				)
		{
		const int	lastLine= 1;

		tedInputChangeSelection( ed, state, &ds.dsHead, lastLine );
		goto ready;
		}

	    if  ( ! ( state & KEY_SHIFT_MASK ) || ds.dsDirection >= 0 )
		{ dpNew= ds.dsTail;	}
	    else{ dpNew= ds.dsHead;	}

	    if  ( state != 0 || sd.sdIsIBarSelection )
		{
		if  ( tedMoveRightOnKey( &dpNew, bd, ei, state ) )
		    { goto ready;	}
		}

	    {
	    const int	lastLine= 0;

	    tedInputChangeSelection( ed, state, &dpNew, lastLine );
	    }
	    goto ready;

	case KEY_KP_Up:
	case KEY_Up:
	    if  ( ! ( state & KEY_SHIFT_MASK ) || ds.dsDirection >= 0 )
		{ pgRef= &(sg.sgEnd); dpNew= ds.dsTail;		}
	    else{ pgRef= &(sg.sgBegin); dpNew= ds.dsHead;	}

	    if  ( state & KEY_CONTROL_MASK )
		{
		if  ( dpNew.dpStroff == 0 )
		    {
		    dpNew.dpBi= docPrevParagraph( dpNew.dpBi );
		    if  ( ! dpNew.dpBi )
			{ goto ready;	}

		    if  ( docParaBegin( &dpNew ) )
			{ goto ready;	}
		    }
		else{
		    if  ( docParaBegin( &dpNew ) )
			{ goto ready;	}
		    }
		}
	    else{
		if  ( tedArrowUp( &dpNew, pgRef, &lc ) )
		    { goto ready;	}
		}

	    {
	    const int	lastLine= sg.sgBegin.pgAtLineHead;

	    tedInputChangeSelection( ed, state, &dpNew, lastLine );
	    }
	    goto ready;

	case KEY_KP_Down:
	case KEY_Down:
	    if  ( ! ( state & KEY_SHIFT_MASK ) || ds.dsDirection >= 0 )
		{ pgRef= &(sg.sgEnd); dpNew= ds.dsTail;		}
	    else{ pgRef= &(sg.sgBegin); dpNew= ds.dsHead;	}

	    if  ( state & KEY_CONTROL_MASK )
		{
		if  ( dpNew.dpStroff < docParaStrlen( dpNew.dpBi )	&&
		      ( state & KEY_SHIFT_MASK )			)
		    {
		    if  ( docParaEnd( &dpNew ) )
			{ goto ready;	}
		    }
		else{
		    dpNew.dpBi= docNextParagraph( dpNew.dpBi );
		    if  ( ! dpNew.dpBi )
			{ goto ready;	}

		    if  ( docParaBegin( &dpNew ) )
			{ goto ready;	}
		    }
		}
	    else{
		if  ( tedArrowDown( &dpNew, pgRef, &lc ) )
		    { goto ready;	}
		}

	    {
	    const int	lastLine= sg.sgBegin.pgAtLineHead;

	    tedInputChangeSelection( ed, state, &dpNew, lastLine );
	    }
	    goto ready;

	case KEY_KP_Prior:
	case KEY_Prior:
	    if  ( ( state & KEY_SHIFT_MASK ) && ds.dsDirection >= 0 )
		{ dpNew= ds.dsTail;	}
	    else{ dpNew= ds.dsHead;	}

	    if  ( dpNew.dpBi->biInExternalItem != DOCinBODY )
		{
		int		page= -1;
		int		column= -1;

		if  ( ! docPrevSimilarRoot( &dpNew, &page, &column, bd ) )
		    {
		    const int		lastLine= 0;
		    DocumentTree *	eiPrev= (DocumentTree *)0;
		    BufferItem *	bodySectBi;

		    if  ( docGetRootForItem( &eiPrev, &bodySectBi,
							bd, dpNew.dpBi ) )
			{ LDEB(1); goto ready;	}

		    if  ( eiPrev && eiPrev->eiPageSelectedUpon < 0 && page >= 0 )
			{
			eiPrev->eiPageSelectedUpon= page;
			eiPrev->eiColumnSelectedIn= column;
			}

		    docAvoidParaHeadField( &dpNew, (int *)0, bd );

		    tedInputSetSelectedPosition( ed, &dpNew, lastLine );
		    }

		goto ready;
		}

	    if  ( docPrevPosition( &dpNew )			&&
		  docFirstDocumentPosition( &dpNew, bd )	)
		{ goto ready;	}

	    {
		PositionGeometry	pg;
		const int		lastLine= 1;
		int			partNew;
		int			lineNew;

		int			page;

		tedPositionGeometry( &pg, &dpNew, bodySectBi, 0, &lc );

		page= pg.pgTopPosition.lpPage;
		while( page >= 0 )
		    {
		    int		res;

		    res= docGetTopOfColumn( &dpNew, &lineNew, &partNew,
								bd, page, 0 );
		    if  ( res < 0 )
			{ LDEB(res); goto ready;	}
		    if  ( res == 0 )
			{
			tedInputChangeSelection( ed, state, &dpNew, lastLine );
			goto ready;
			}

		    page--;
		    }
	    }
	    goto ready;

	case KEY_KP_Next:
	case KEY_Next:
	    if  ( ! ( state & KEY_SHIFT_MASK ) || ds.dsDirection >= 0 )
		{ dpNew= ds.dsTail;	}
	    else{ dpNew= ds.dsHead;	}

	    if  ( dpNew.dpBi->biInExternalItem != DOCinBODY )
		{
		int		page= -1;
		int		column= -1;

		if  ( ! docNextSimilarRoot( &dpNew, &page, &column, bd ) )
		    {
		    const int		lastLine= 0;
		    DocumentTree *	eiNext= (DocumentTree *)0;
		    BufferItem *	bodySectBi;

		    if  ( docGetRootForItem( &eiNext, &bodySectBi,
							bd, dpNew.dpBi ) )
			{ LDEB(1); goto ready;	}

		    if  ( eiNext && eiNext->eiPageSelectedUpon < 0 && page >= 0 )
			{
			eiNext->eiPageSelectedUpon= page;
			eiNext->eiColumnSelectedIn= column;
			}

		    docAvoidParaHeadField( &dpNew, (int *)0, bd );

		    tedInputSetSelectedPosition( ed, &dpNew, lastLine );
		    }

		goto ready;
		}

	    {
		PositionGeometry	pg;
		const int		lastLine= 1;
		int			partNew;
		int			lineNew;

		int			page;
		BufferItem *		bodyBi= bd->bdBody.eiRoot;

		tedPositionGeometry( &pg, &dpNew, bodySectBi, lastLine, &lc );

		page= pg.pgTopPosition.lpPage+ 1;
		while( page <= bodyBi->biBelowPosition.lpPage )
		    {
		    int		res;

		    res= docGetTopOfColumn( &dpNew, &lineNew, &partNew,
								bd, page, 0 );
		    if  ( res < 0 )
			{ LDEB(res); goto ready;	}
		    if  ( res == 0 )
			{
			tedInputChangeSelection( ed, state, &dpNew, lastLine );
			goto ready;
			}

		    page++;
		    }

		page= bodyBi->biBelowPosition.lpPage;
		res= docGetBottomOfColumn( &dpNew, &partNew, bd, page, 0 );
		if  ( res == 0 )
		    {
		    tedInputChangeSelection( ed, state, &dpNew, lastLine );
		    goto ready;
		    }
	    }
	    goto ready;

#	if 0
	case KEY_y:
	    docListItem(0,ds.dsHead.dpBi);
	    break;
#	endif

	case KEY_Shift_L:
	case KEY_Shift_R:
	case KEY_Alt_L:
	case KEY_Alt_R:
	case KEY_Control_L:
	case KEY_Control_R:
	case KEY_Caps_Lock:
	case KEY_Insert:
	case KEY_KP_Insert:
	case KEY_Num_Lock:
#	ifdef XK_ISO_Level3_Shift
	case XK_ISO_Level3_Shift:
#	endif

	    goto ready;

	default: unknown:
#	    ifdef USE_GTK
#		if GTK_MAJOR_VERSION < 2
		gtk_accel_group_activate( ed->edToplevel.atAccelGroup,
							    keySym, state );
#		else
		gtk_accel_groups_activate(
			    G_OBJECT( ed->edToplevel.atAccelGroup ),
							    keySym, state );
#		endif
#	    endif
	    goto ready;
	}

  ready:

    if  ( tedHasIBarSelection( td ) )
	{ tedStartCursorBlink( ed );	}

    return;
    }

APP_EVENT_HANDLER_H( tedScrollEventHandler, w, voided, scrollEvent )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;
    int			direction= SCROLL_DIRECTION_FROM_EVENT( scrollEvent );


    tedStopCursorBlink( ed );

    switch( direction )
	{
#	ifdef USE_MOTIF
	case Button1:
	case Button2:
	case Button3:
	    break;
#	endif

	case SCROLL_UP:
	    appMouseWheelUp( ed );
	    break;

	case SCROLL_DOWN:
	    appMouseWheelDown( ed );
	    break;

	default:
	    LLDEB(scrollEvent->type,direction);
	    break;
	}

    if  ( tedHasIBarSelection( td ) )
	{ tedStartCursorBlink( ed );	}

    return;
    }

