/************************************************************************/
/*									*/
/*  Replace the selection in a document with another document.		*/
/*  ( Used with 'paste', 'insert file', 'undo', 'redo'. )		*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedEdit.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Wrapper around docIncludeDocument(): More relayout admin.		*/
/*									*/
/************************************************************************/

static int tedIncludeDocument(	TedEditOperation *		teo,
				DocumentCopyJob *		dcj )
    {
    EditOperation *	eo= &(teo->teoEo);
    int			beginStrlenOld= docParaStrlen( eo->eoHeadDp.dpBi );

    if  ( docIncludeDocument( dcj ) )
	{ LDEB(1); return -1;	}

    if  ( eo->eoParagraphsInserted == 0 )
	{
	int	beginStrlenNew= docParaStrlen( eo->eoHeadDp.dpBi );
	int	stroffTail= eo->eoSelectedRange.erTail.epStroff;
	int	stroffShift= beginStrlenNew- beginStrlenOld;

	/*  C  */
	docSetParagraphAdjust( eo, eo->eoHeadDp.dpBi, stroffShift, stroffTail );
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Include a plain text document into the current document.		*/
/*									*/
/*  This is the implementation of 'Include File', but also of a paste	*/
/*  E.G. from a program that does not support pasting RTF such as	*/
/*  Xterm.								*/
/*									*/
/*  1)  Determine the text attributes of the target location.		*/
/*  2)  Merge the font of the current position n the TARGER document	*/
/*	into the font list of the SOURCE document. This sounds to be	*/
/*	the wrong direction, but it makes subsequent steps a lot	*/
/*	easier.								*/
/*  3)  Determine the attribute number in the source document of the	*/
/*	text attribute at the target position. This is possible as we	*/
/*	have just inserted the font into the source document.		*/
/*  5)  Make a mapping of the fonts in the source document to those in	*/
/*	the target document.						*/
/*  6)  Allocate memory to keep an administration of the fields that	*/
/*	have been copied from one document to the other.		*/
/*  7)  Actually include the source in the target.			*/
/*									*/
/************************************************************************/

int tedIncludePlainDocument(	EditDocument *		ed,
				BufferDocument *	bdFrom )
    {
    TedDocument *		tdTo= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bdTo= tdTo->tdDocument;

    DocumentPosition		dpBeginTo;

    int				rval;

    DocumentCopyJob		dcj;

    TedEditOperation		teo;
    EditOperation *		eo= &(teo.teoEo);
    SelectionGeometry		sg;
    SelectionDescription	sd;

    int				forceAttributeTo;

    docInitDocumentCopyJob( &dcj );

    tedStartEditOperation( &teo, &sg, &sd, ed, 1 );

    dpBeginTo= eo->eoHeadDp;
    if  ( ! dpBeginTo.dpBi				||
	  dpBeginTo.dpBi->biParaParticuleCount == 0	)
	{ LDEB(1); rval= -1; goto ready;	}

    /*  2  */
    {
    DocumentProperties *	dpFrom= &(bdFrom->bdProperties);
    DocumentFontList *		dflFrom= &(dpFrom->dpFontList);

    DocumentProperties *	dpTo= &(bdTo->bdProperties);
    DocumentFontList *		dflTo= &(dpTo->dpFontList);

    DocumentFont *		dfTo;

    int				to;

    TextAttribute		ta;

    ta= teo.teoSavedTextAttribute;

    dfTo= docFontListGetFontByNumber( dflTo, ta.taFontNumber );
    if  ( ! dfTo )
	{ XDEB(dfTo); rval= -1; goto ready;	}
    to= docMergeFontIntoFontlist( dflFrom, dfTo );
    if  ( to < 0 )
	{ LDEB(to); rval= -1; goto ready;	}
    ta.taFontNumber= to;

    if  ( ta.taTextColorNumber > 0 )
	{
	RGB8Color *	rgb8= dpTo->dpColors+ ta.taTextColorNumber;

	to= docAllocateDocumentColor( dpFrom, rgb8 );
	if  ( to < 0 )
	    { LDEB(to); rval= -1; goto ready;	}
	ta.taTextColorNumber= to;
	}

    /*  3  */
    forceAttributeTo= utilTextAttributeNumber(
					&(bdTo->bdTextAttributeList), &ta );
    if  ( forceAttributeTo < 0 )
	{ LDEB(forceAttributeTo); rval= -1; goto ready;	}
    }

    /*  5,6  */
    if  ( docSet2DocumentCopyJob( &dcj, eo, bdFrom, ed->edFilename ) )
	{ LDEB(1); rval= -1; goto ready;	}

    dcj.dcjForceAttributeTo= forceAttributeTo;

    /*  7  */
    rval= tedIncludeDocument( &teo, &dcj );
    if  ( rval )
	{ LDEB(rval); goto ready;	}

    tedEditFinishIBarSelection( &teo,
			eo->eoTailDp.dpBi, eo->eoTailDp.dpStroff );

  ready:

    docCleanDocumentCopyJob( &dcj );

    return rval;
    }

int tedIncludeRtfDocument(	EditDocument *		ed,
				BufferDocument *	bdFrom )
    {
    int				rval= 0;

    DocumentCopyJob		dcj;

    TedEditOperation		teo;
    EditOperation *		eo= &(teo.teoEo);
    SelectionGeometry		sg;
    SelectionDescription	sd;

    docInitDocumentCopyJob( &dcj );

    tedStartEditOperation( &teo, &sg, &sd, ed, 1 );

    if  ( bdFrom->bdProperties.dpContainsTables )
	{
	if  ( sd.sdBeginInTable )
	    { goto ready;	}
	if  ( sd.sdEndInTable )
	    { goto ready;	}
	}

    if  ( docSet2DocumentCopyJob( &dcj, eo, bdFrom, ed->edFilename ) )
	{ LDEB(1); rval= -1; goto ready;	}

    rval= tedIncludeDocument( &teo, &dcj );
    if  ( rval )
	{ LDEB(rval); goto ready;	}

    tedEditFinishIBarSelection( &teo,
			teo.teoEo.eoTailDp.dpBi, teo.teoEo.eoTailDp.dpStroff );

  ready:

    docCleanDocumentCopyJob( &dcj );

    return rval;
    }

