/************************************************************************/
/*									*/
/*  Edit/Make headers and footers.					*/
/*  Jump back and forth between the body of a document and notes.	*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>
#   include	<limits.h>

#   include	"tedApp.h"
#   include	"tedLayout.h"
#   include	"docScreenLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Move the current selection to a certain header/Footer. If the	*/
/*  header or footer does not exist, make it.				*/
/*									*/
/************************************************************************/

static int TED_TryPageOffsets[]=
    {
     0,
     1,
    -1,
     2
    };

void tedAppEditHeaderFooter(		EditApplication *	ea,
					APP_WIDGET		relative,
					APP_WIDGET		option,
					int			which )
    {
    EditDocument *		ed= ea->eaCurrentDocument;
    AppDrawingData *		add;
    TedDocument *		td;
    BufferDocument *		bd;

    DocumentTree *		ei;
    DocumentTree *		x_ei;
    DocumentTree *		eiTry;
    const BufferItem *		x_bodySectBi;
    BufferItem *		bodySectBi;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;
    SelectionScope *		ss;

    int				page= -1;
    const int			column= 0;
    int				i;

    int				scrolledX= 0;
    int				scrolledY= 0;

    DocumentRectangle		drChanged;
    IndexMapping *		a2s;

    LayoutContext		lc;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    add= &(ed->edDocumentWidget.dwDrawingData);
    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    a2s= &(td->tdAttributeToScreenFont);

    layoutInitContext( &lc );
    tedSetLayoutContext( &lc, ed );

    if  ( tedGetSelection( &ds, &sg, &sd, &x_ei, &x_bodySectBi, td ) )
	{ LDEB(1); return;	}
    ss= &(ds.dsSelectionScope);

    drChanged= sg.sgRectangle;

    if  ( docGetHeaderFooter( &ei, &bodySectBi, &ds, bd, which ) )
	{ LDEB(which); return;	}

    if  ( ss->ssInExternalItem == which					&&
	  ss->ssOwnerSectNr == bodySectBi->biNumberInParent	)
	{ return;	}

    if  ( ! ei->eiRoot )
	{
	BufferItem *	paraBi;
	const int	ownerNumber= -1;

	paraBi= docMakeExternalParagraph( bd, ei, bodySectBi,
			td->tdCurrentTextAttributeNumber, ownerNumber, which );
	if  ( ! paraBi )
	    { XDEB(paraBi); return; }

	if  ( docScreenLayoutItem( bodySectBi, &lc, &drChanged ) )
	    { LDEB(1); return;	}

	appDocumentChanged( ed, 1 );
	}

    switch( which )
	{
	int		isEmpty;

	case DOCinFIRST_HEADER:
	case DOCinFIRST_FOOTER:
	    page= bodySectBi->biTopPosition.lpPage;
	    break;

	case DOCinLEFT_HEADER:
	case DOCinRIGHT_HEADER:
	    for ( i= 0; i < sizeof(TED_TryPageOffsets)/sizeof(int); i++ )
		{
		int pg= sg.sgBegin.pgTopPosition.lpPage+ TED_TryPageOffsets[i];

		if  ( pg < bodySectBi->biTopPosition.lpPage		||
		      pg > bodySectBi->biBelowPosition.lpPage	)
		    { continue;	}

		if  ( docWhatPageHeader( &eiTry, &isEmpty,
					    bodySectBi, pg, bd ) == which )
		    { page= pg; break;	}
		}
	    break;

	case DOCinLEFT_FOOTER:
	case DOCinRIGHT_FOOTER:
	    for ( i= 0; i < sizeof(TED_TryPageOffsets)/sizeof(int); i++ )
		{
		int pg= sg.sgBegin.pgTopPosition.lpPage+ TED_TryPageOffsets[i];

		if  ( pg < bodySectBi->biTopPosition.lpPage		||
		      pg > bodySectBi->biBelowPosition.lpPage	)
		    { continue;	}

		if  ( docWhatPageFooter( &eiTry, &isEmpty,
					    bodySectBi, pg, bd ) == which )
		    { page= pg; break;	}
		}
	    break;

	default:
	    LDEB(which); return;
	}

    if  ( page < bodySectBi->biTopPosition.lpPage		||
	  page > bodySectBi->biBelowPosition.lpPage		)
	{
	TedAppResources *	tar= (TedAppResources *)ea->eaResourceData;

	appQuestionRunErrorDialog( ea, relative, option,
					    tar->tarHeadFootNotReachable );
	return;
	}

    ei->eiPageSelectedUpon= page;
    ei->eiColumnSelectedIn= column;

    tedSelectItemHome( ed, ei->eiRoot, &scrolledX, &scrolledY );

    tedAdaptToolsToSelection( ed );

    return;
    }

/************************************************************************/
/*									*/
/*  Delete a particular page Header/Footer from the first section of	*/
/*  the selection.							*/
/*									*/
/*  1)  Get the given header/footer.					*/
/*  2)  If it exists.. Delete it.					*/
/*  3)  If the current selection is inside the header/footer to be	*/
/*	deleted.. Move the selection to the body somewhere nearby.	*/
/*									*/
/************************************************************************/

void tedAppDeleteHeaderFooter(		EditApplication *	ea,
					int			which )
    {
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;
    BufferDocument *		bd;

    DocumentTree *		ei= (DocumentTree *)0;
    DocumentTree *		x_ei= (DocumentTree *)0;
    const BufferItem *		x_bodySectBi;
    BufferItem *		bodySectBi;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    int				scrolledX= 0;
    int				scrolledY= 0;

    IndexMapping *		a2s;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    a2s= &(td->tdAttributeToScreenFont);

    if  ( tedGetSelection( &ds, &sg, &sd, &x_ei, &x_bodySectBi, td ) )
	{ LDEB(1); return;	}

    /*  1  */
    if  ( docGetHeaderFooter( &ei, &bodySectBi, &ds, bd, which ) )
	{ LDEB(which); return;	}

    /*  2  */
    if  ( ei && ei->eiRoot )
	{
	AppDrawingData *	add= &(ed->edDocumentWidget.dwDrawingData);
	DocumentRectangle	drChanged= add->addBackRect;

	/*  3  */
	if  ( ds.dsHead.dpBi->biInExternalItem == which )
	    {
	    int			part;
	    int			line;
	    const int		lastLine= 0;
	    BufferItem *	bodyBi= bd->bdBody.eiRoot;

	    DocumentPosition	dp;

	    switch( which )
		{
		case DOCinFIRST_HEADER:
		case DOCinLEFT_HEADER:
		case DOCinRIGHT_HEADER:
		    if  ( docGetFirstInColumnForItem( &dp,
				&line, &part, bodySectBi,
				ds.dsHead.dpBi->biTopPosition.lpPage, 0 ) )
			{
			LDEB(ds.dsHead.dpBi->biTopPosition.lpPage);
			if  ( docFirstPosition( &dp, bodySectBi )	&&
			      docFirstPosition( &dp, bodyBi )		)
			    { LDEB(1); return;	}
			}
		    break;

		case DOCinFIRST_FOOTER:
		case DOCinLEFT_FOOTER:
		case DOCinRIGHT_FOOTER:
		    if  ( docGetLastInColumnForItem( &dp,
				&line, &part, bodySectBi,
				ds.dsHead.dpBi->biTopPosition.lpPage, 0 ) )
			{
			LDEB(ds.dsHead.dpBi->biTopPosition.lpPage);
			if  ( docLastPosition( &dp, bodySectBi )	&&
			      docLastPosition( &dp, bodyBi )		)
			    { LDEB(1); return;	}
			}
		    break;

		default:
		    LDEB(which); break;
		}

	    tedSetSelectedPosition( ed, &dp, lastLine, &scrolledX, &scrolledY );

	    tedAdaptToolsToSelection( ed );
	    }

	docCleanExternalItem( bd, ei );
	docInitExternalItem( ei );

	appDocumentChanged( ed, 1 );

	appDocExposeRectangle( ed, &drChanged, scrolledX, scrolledY );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Jump to the foot/end note thet is selected in the body of the	*/
/*  document.								*/
/*									*/
/************************************************************************/

void tedAppEditNote(		EditApplication *	ea )
    {
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;
    BufferDocument *		bd;

    DocumentNote *		dn= (DocumentNote *)0;
    DocumentTree *		eiNote= (DocumentTree *)0;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    int				scrolledX= 0;
    int				scrolledY= 0;

    DocumentField *		dfNote= (DocumentField *)0;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;

    if  ( tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ LDEB(1); return;	}

    if  ( ds.dsSelectionScope.ssInExternalItem != DOCinBODY )
	{ LDEB(ds.dsSelectionScope.ssInExternalItem); return;	}

    dfNote= docGetSelectedNote( &dn, bd, &ds );
    if  ( ! dfNote )
	{ XDEB(dfNote); return;	}

    eiNote= &(dn->dnDocumentTree);

    if  ( ! eiNote->eiRoot )
	{ XDEB(eiNote->eiRoot); return;	}

    tedSelectItemHome( ed, eiNote->eiRoot, &scrolledX, &scrolledY );

    tedAdaptToolsToSelection( ed );

    return;
    }

/************************************************************************/
/*									*/
/*  Jump to the foot/end note reference in the body of the document to	*/
/*  the note text that is selected.					*/
/*									*/
/************************************************************************/

void tedAppGotoNoteRef(		EditApplication *	ea )
    {
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;
    BufferDocument *		bd;

    DocumentNote *		dn= (DocumentNote *)0;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    int				scrolledX= 0;
    int				scrolledY= 0;

    DocumentField *		dfNote= (DocumentField *)0;

    DocumentPosition		dpNote;
    const int			lastLine= 0;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;

    if  ( tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ LDEB(1); return;	}

    if  ( ds.dsSelectionScope.ssInExternalItem != DOCinFOOTNOTE	&&
	  ds.dsSelectionScope.ssInExternalItem != DOCinENDNOTE	)
	{ LDEB(ds.dsSelectionScope.ssInExternalItem); return;	}

    dfNote= docGetSelectedNote( &dn, bd, &ds );
    if  ( ! dfNote )
	{ XDEB(dfNote); return;	}

    if  ( docPositionForEditPosition( &dpNote,
				&(dfNote->dfHeadPosition), &(bd->bdBody) ) )
	{ LDEB(1); return;	}

    tedSetIBarSelection( ed, &dpNote, lastLine, &scrolledX, &scrolledY );

    return;
    }

