/************************************************************************/
/*									*/
/*  Format tool:							*/
/*									*/
/************************************************************************/

#   ifndef	TED_FORMAT_TOOL_H
#   define	TED_FORMAT_TOOL_H

#   include	"docSetRowProperties.h"

#   include	"tedParaLayoutTool.h"
#   include	"tedParaOrnamentsTool.h"
#   include	"tedTextOrnamentsTool.h"
#   include	"tedRowTool.h"
#   include	"tedSectionTool.h"
#   include	"tedPageLayoutTool.h"
#   include	"tedNotesTool.h"
#   include	"tedHeaderFooterTool.h"
#   include	"tedTableTool.h"
#   include	"tedColumnTool.h"
#   include	"tedCellTool.h"
#   include	"tedTabsTool.h"
#   include	"tedListTool.h"
#   include	"tedFontTool.h"
#   include	"tedSymbolPicker.h"
#   include	"tedLinkTool.h"
#   include	"tedBookmarkTool.h"
#   include	"tedImageTool.h"
#   include	"tedFrameTool.h"
#   include	"tedTextOrnamentsTool.h"
#   include	"tedTocTool.h"
#   include	"tedFindTool.h"
#   include	"tedSpellTool.h"

#   include	<appRgbChooserPage.h>

/************************************************************************/
/*									*/
/*  The different pages in a Format tool:				*/
/*									*/
/************************************************************************/

# define USE_FRAME_TOOL 0

typedef enum ToolSubjectIndex
    {
    TEDtsiFONT= 0,
    TEDtsiTEXT_ORN,

    TEDtsiPARA_LAY,
    TEDtsiTABS,
    TEDtsiPARA_ORN,
    TEDtsiLISTS,
    TEDtsiSECT,

    TEDtsiTABLE,
    TEDtsiROW,
    TEDtsiCOLUMN,
    TEDtsiCELL,

    TEDtsiPAGE,
    TEDtsiHEADFOOT,
    TEDtsiNOTES,
    TEDtsiLINK,
    TEDtsiBOOKMARK,
    TEDtsiIMAGE,
#   if USE_FRAME_TOOL
    TEDtsiFRAME,
#   endif
    TEDtsiTOC,
    TEDtsiSYMBOL,

    TEDtsiFIND,
    TEDtsiSPELL,

    TEDtsiRGB,

    TEDtsi_COUNT

    } ToolSubjectIndex;

/************************************************************************/
/*									*/
/*  Represents a format tool.						*/
/*									*/
/************************************************************************/

typedef struct TedFormatTool
    {
    EditApplication *		tftApplication;
    AppInspector *		tftInspector;

    TableTool			tftTableTool;
    RowTool			tftRowTool;
    ColumnTool			tftColumnTool;
    CellTool			tftCellTool;
    ParagraphLayoutTool		tftParagraphLayoutTool;
    TabsTool			tftTabsTool;
    ParagraphOrnamentsTool	tftParagraphOrnamentsTool;
    ListTool			tftListsTool;
    SectionTool			tftSectionTool;
    PageLayoutTool		tftPageLayoutTool;
    HeaderFooterTool		tftHeaderFooterTool;
    NotesTool			tftNotesTool;
    AppFontChooser		tftFontTool;
    TextOrnamentsTool		tftTextOrnamentsTool;
    LinkTool			tftLinkTool;
    BookmarkTool		tftBookmarkTool;
    ImageTool			tftImageTool;
    FrameTool			tftFrameTool;
    TocTool			tftTocTool;
    SymbolPicker		tftSymbolPicker;
    FindTool			tftFindTool;
    SpellTool			tftSpellTool;

    RgbChooserPage		tftRgbPage;
    } TedFormatTool;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int tedFormatToolGetRowLeftIndent( const RowProperties *	rp,
					const int		pageLeftMargin,
					int *			pValue,
					APP_WIDGET		w );

extern int tedFormatToolGetGapWidth(	const RowProperties *	rp,
					int *			pValue,
					APP_WIDGET		w );

extern void tedFormatFillSectionPage(	SectionTool *		st,
				const SectionPageResources *	spr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern void tedFormatFillSectionChoosers( SectionTool *			st,
					const SectionPageResources *	spr );

extern void tedFormatFinishSectionPage(	SectionTool *			st,
					TedFormatTool *			tft,
					const SectionPageResources *	spr );

extern void tedFormatFinishPageLayoutPage(	PageLayoutTool *	plt,
					TedFormatTool *			tft,
					const PageLayoutPageResources *	plpr );

extern void tedFormatFillNotesPage( NotesTool *			nt,
				const NotesPageResources *	npr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern void tedFormatFillNotesChoosers(	NotesTool *			nt,
					const NotesPageResources *	npr );

extern void tedFormatFinishNotesPage(	NotesTool *			nt,
					TedFormatTool *			tft,
					const NotesPageResources *	npr );

extern int tedFormatValidateDimension(		int *		pNewValue,
						int *		pChanged,
						APP_WIDGET	w,
						int		oldValue );

extern void tedColumnToolFillChoosers( ColumnTool *			ct,
					const ColumnPageResources *	cpr );

extern void tedFormatFinishCellPage(	CellTool *			ct,
					TedFormatTool *			tft,
					const CellPageResources *	cpr );

extern void tedFormatFillPageLayoutPage(
			PageLayoutTool *			plt,
			const PageLayoutPageResources *		plpr,
			InspectorSubject *			is,
			APP_WIDGET				pageWidget,
			const InspectorSubjectResources *	isr );

extern void tedFormatFillHeaderFooterPage(
			HeaderFooterTool *			hft,
			const HeaderFooterPageResources *	hfpr,
			InspectorSubject *			is,
			APP_WIDGET				pageWidget,
			const InspectorSubjectResources *	isr );

extern void tedFormatFillHeaderFooterChoosers( HeaderFooterTool *	hft,
				    const HeaderFooterPageResources *	hfpr );

extern void tedFormatFinishHeaderFooterPage( HeaderFooterTool *		hft,
				    TedFormatTool *			tft,
				    const HeaderFooterPageResources *	hfpr );

extern void tedFormatToolGetColumnResourceTable(
					EditApplication *		ea,
					ColumnPageResources *		cpr,
					InspectorSubjectResources *	isr );

extern void tedFinishParaLayoutPage(
				ParagraphLayoutTool *			plt,
				TedFormatTool *				tft,
				const ParagraphLayoutPageResources *	plpr );

extern void tedFormatFinishParaOrnamentsPage(
				ParagraphOrnamentsTool *		pot,
				TedFormatTool *				tft,
				const ParagraphOrnamentsPageResources *	popr );

extern int tedFormatToolGetShading(	PropertyMask *		cpSetMask,
					RowProperties *		rp,
					int			col0,
					int			col1,
					BufferDocument *	bd,
					ShadingTool *		st );

extern BufferDocument * tedFormatCurDoc(
					EditDocument **		pEd,
					EditApplication *	ea );

#   endif	/*  TED_FORMAT_TOOL_H */
