/************************************************************************/
/*									*/
/*  The 'Format Tool':							*/
/*									*/
/*  An inpector with pages for the different formatting properties of	*/
/*  the document.							*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<limits.h>

#   include	<geoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Resources for the format tool.					*/
/*									*/
/************************************************************************/

typedef struct TedFormatToolResources
    {
    InspectorSubjectResources	tttrSubjectResources[TEDtsi_COUNT];

    TablePageResources			tttrTableToolResources;
    RowPageResources			tttrRowToolResources;
    ColumnPageResources			tttrColumnToolResources;
    CellPageResources			tttrCellToolResources;
    ParagraphLayoutPageResources	tttrParaLayoutToolResources;
    TabsPageResources			tttrTabsToolResources;
    ParagraphOrnamentsPageResources	tttrParaOrnamentsToolResources;
    TextOrnamentsPageResources		tttrTextOrnamentsToolResources;
    ListsPageResources			tttrListsToolResources;
    SectionPageResources		tttrSectToolResources;
    PageLayoutPageResources		tttrPageLayoutToolResources;
    HeaderFooterPageResources		tttrHeadFootToolResources;
    NotesPageResources			tttrNotesToolResources;
    AppFontToolResources		tttrFontToolResources;
    RgbChooserPageResources		tttrRgbChooserToolResources;
    LinkToolResources			tttrLinkToolResources;
    BookmarkPageResources		tttrBookmarkToolResources;
    ImagePageResources			tttrImageToolResources;
    FramePageResources			tttrFrameToolResources;
    TocPageResources			tttrTocToolResources;
    SymbolPickerResources		tttrSymbolPickerResources;
    FindToolResources			tttrFindToolResources;
    SpellToolResources			tttrSpellToolResources;
    } TedFormatToolResources;

static void tedFormatFillPages(	const TedFormatToolResources *	tftr,
				TedFormatTool *			tft,
				AppInspector *			ai )
    {
    appFontToolFillPage( &(tft->tftFontTool),
			    &(tftr->tttrFontToolResources),
			    TEDtsiFONT,
			    &(ai->aiSubjects[TEDtsiFONT]),
			    ai->aiSubjects[TEDtsiFONT].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiFONT]) );

    tedFormatFillTextOrnamentsPage( &(tft->tftTextOrnamentsTool),
			    &(tftr->tttrTextOrnamentsToolResources),
			    ai, TEDtsiTEXT_ORN,
			    &(ai->aiSubjects[TEDtsiTEXT_ORN]),
			    ai->aiSubjects[TEDtsiTEXT_ORN].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiTEXT_ORN]) );

    tedFormatFillParagraphLayoutPage( &(tft->tftParagraphLayoutTool),
			    &(tftr->tttrParaLayoutToolResources),
			    &(ai->aiSubjects[TEDtsiPARA_LAY]),
			    ai->aiSubjects[TEDtsiPARA_LAY].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiPARA_LAY]) );

    tedFormatFillTabsPage( &(tft->tftTabsTool),
			    &(tftr->tttrTabsToolResources),
			    &(ai->aiSubjects[TEDtsiTABS]),
			    ai->aiSubjects[TEDtsiTABS].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiTABS]) );

    tedFormatFillParagraphOrnamentsPage( &(tft->tftParagraphOrnamentsTool),
			    &(tftr->tttrParaOrnamentsToolResources),
			    ai, TEDtsiPARA_ORN,
			    &(ai->aiSubjects[TEDtsiPARA_ORN]),
			    ai->aiSubjects[TEDtsiPARA_ORN].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiPARA_ORN]) );

    tedFormatFillListsPage( &(tft->tftListsTool),
			    &(tftr->tttrListsToolResources),
			    &(ai->aiSubjects[TEDtsiLISTS]),
			    ai->aiSubjects[TEDtsiLISTS].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiLISTS]) );

    tedFormatFillSectionPage( &(tft->tftSectionTool),
			    &(tftr->tttrSectToolResources),
			    &(ai->aiSubjects[TEDtsiSECT]),
			    ai->aiSubjects[TEDtsiSECT].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiSECT]) );

    tedFormatFillTablePage( &(tft->tftTableTool),
			    &(tftr->tttrTableToolResources),
			    &(ai->aiSubjects[TEDtsiTABLE]),
			    ai->aiSubjects[TEDtsiTABLE].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiTABLE]) );

    tedFormatFillRowPage( &(tft->tftRowTool),
			    &(tftr->tttrRowToolResources),
			    ai, TEDtsiROW,
			    &(ai->aiSubjects[TEDtsiROW]),
			    ai->aiSubjects[TEDtsiROW].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiROW]) );

    tedFormatFillColumnPage( &(tft->tftColumnTool),
			    &(tftr->tttrColumnToolResources),
			    ai, TEDtsiCOLUMN,
			    &(ai->aiSubjects[TEDtsiCOLUMN]),
			    ai->aiSubjects[TEDtsiCOLUMN].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiCOLUMN]) );

    tedFormatFillCellPage( &(tft->tftCellTool),
			    &(tftr->tttrCellToolResources),
			    ai, TEDtsiCELL,
			    &(ai->aiSubjects[TEDtsiCELL]),
			    ai->aiSubjects[TEDtsiCELL].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiCELL]) );

    tedFormatFillPageLayoutPage( &(tft->tftPageLayoutTool),
			    &(tftr->tttrPageLayoutToolResources),
			    &(ai->aiSubjects[TEDtsiPAGE]),
			    ai->aiSubjects[TEDtsiPAGE].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiPAGE]) );

    tedFormatFillHeaderFooterPage( &(tft->tftHeaderFooterTool),
			    &(tftr->tttrHeadFootToolResources),
			    &(ai->aiSubjects[TEDtsiHEADFOOT]),
			    ai->aiSubjects[TEDtsiHEADFOOT].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiHEADFOOT]) );

    tedFormatFillNotesPage( &(tft->tftNotesTool),
			    &(tftr->tttrNotesToolResources),
			    &(ai->aiSubjects[TEDtsiNOTES]),
			    ai->aiSubjects[TEDtsiNOTES].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiNOTES]) );

    tedFillLinkTool( &(tft->tftLinkTool),
			    &(tftr->tttrLinkToolResources),
			    &(ai->aiSubjects[TEDtsiLINK]),
			    ai->aiSubjects[TEDtsiLINK].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiLINK]) );

    tedFillBookmarkTool( &(tft->tftBookmarkTool),
			    &(tftr->tttrBookmarkToolResources),
			    &(ai->aiSubjects[TEDtsiBOOKMARK]),
			    ai->aiSubjects[TEDtsiBOOKMARK].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiBOOKMARK]) );

    tedFormatFillImagePage( &(tft->tftImageTool),
			    &(tftr->tttrImageToolResources),
			    &(ai->aiSubjects[TEDtsiIMAGE]),
			    ai->aiSubjects[TEDtsiIMAGE].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiIMAGE]) );

#   if USE_FRAME_TOOL
    tedFormatFillFramePage( &(tft->tftFrameTool),
			    &(tftr->tttrFrameToolResources),
			    ai, TEDtsiFRAME,
			    &(ai->aiSubjects[TEDtsiFRAME]),
			    ai->aiSubjects[TEDtsiFRAME].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiFRAME]) );
#   endif

    tedFormatFillTocPage( &(tft->tftTocTool),
			    &(tftr->tttrTocToolResources),
			    ai, TEDtsiTOC,
			    &(ai->aiSubjects[TEDtsiTOC]),
			    ai->aiSubjects[TEDtsiTOC].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiTOC]) );

    appFillSymbolPicker( &(tft->tftSymbolPicker),
			    &(tftr->tttrSymbolPickerResources),
			    ai, TEDtsiSYMBOL,
			    &(ai->aiSubjects[TEDtsiSYMBOL]),
			    ai->aiSubjects[TEDtsiSYMBOL].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiSYMBOL]) );

    tedFillFindTool( &(tft->tftFindTool),
			    &(tftr->tttrFindToolResources),
			    ai, TEDtsiFIND,
			    &(ai->aiSubjects[TEDtsiFIND]),
			    ai->aiSubjects[TEDtsiFIND].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiFIND]) );

    tedFillSpellTool( &(tft->tftSpellTool),
			    &(tftr->tttrSpellToolResources),
			    ai, TEDtsiSPELL,
			    &(ai->aiSubjects[TEDtsiSPELL]),
			    ai->aiSubjects[TEDtsiSPELL].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiSPELL]) );

    /**/
    appRgbChooserPageFillPage( &(tft->tftRgbPage),
			    &(tftr->tttrRgbChooserToolResources),
			    &(ai->aiSubjects[TEDtsiRGB]),
			    ai->aiSubjects[TEDtsiRGB].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiRGB]) );

    /**/
    appInspectorSetRgbPage( ai, (void *)&(tft->tftRgbPage), TEDtsiRGB );

    return;
    }

/************************************************************************/
/*									*/
/*  The user destroys the format tool.					*/
/*									*/
/************************************************************************/

static void tedDestroyFormatTool(	void *	voidtft )
    {
    TedFormatTool *	tft= (TedFormatTool *)voidtft;

    EditApplication *	ea= tft->tftApplication;
    TedAppResources *	tar= (TedAppResources *)ea->eaResourceData;

    tedFormatCleanTableTool( &(tft->tftTableTool) );
    tedCleanRowTool( &(tft->tftRowTool) );
    tedCleanColumnTool( &(tft->tftColumnTool) );
    tedCleanCellTool( &(tft->tftCellTool) );
    tedFormatCleanParaLayoutTool( &(tft->tftParagraphLayoutTool) );
    tedFormatCleanParaTabsTool( &(tft->tftTabsTool) );
    tedCleanParaOrnamentsTool( &(tft->tftParagraphOrnamentsTool) );
    tedFormatCleanListsTool( &(tft->tftListsTool) );
    tedFormatCleanSectionTool( &(tft->tftSectionTool) );
    tedFormatCleanPageLayoutTool( &(tft->tftPageLayoutTool) );
    tedFormatCleanHeaderFooterTool( &(tft->tftHeaderFooterTool) );
    tedFormatCleanNotesTool( &(tft->tftNotesTool) );
    appFontChooserCleanPage( &(tft->tftFontTool) );
    tedCleanTextOrnamentsTool( &(tft->tftTextOrnamentsTool) );
    tedFormatCleanLinkTool( &(tft->tftLinkTool) );
    tedFormatCleanBookmarkTool( &(tft->tftBookmarkTool) );
    tedCleanImageTool( &(tft->tftImageTool) );
    tedCleanFrameTool( &(tft->tftFrameTool) );
    tedCleanTocTool( &(tft->tftTocTool) );
    appCleanSymbolPicker( &(tft->tftSymbolPicker) );
    appCleanFindTool( &(tft->tftFindTool) );
    appCleanSpellTool( &(tft->tftSpellTool) );

    appRgbChooserPageCleanPage( &(tft->tftRgbPage) );

    free( tft );

    tar->tarInspector= (void *)0;

    return;
    }

/************************************************************************/
/*									*/
/*  Called when the user switches to another page of the format tool.	*/
/*									*/
/************************************************************************/

static void tedFormatToolNotifySubject(	AppInspector *		ai,
					int			subjectFrom,
					int			subjectTo )
    {
    if  ( subjectFrom == TEDtsiRGB && subjectTo != TEDtsiRGB )
	{
	const int	enabled= 0;

	appEnableInspectorSubject( ai, TEDtsiRGB, enabled );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  make/show the format tool.						*/
/*									*/
/************************************************************************/

void tedShowFormatTool(	APP_WIDGET		option,
			EditApplication *	ea )
    {
    AppInspector *			ai;
    TedFormatTool *			tft;

    static TedFormatToolResources	tftr;
    static int				gotResources;

    TedAppResources *			tar;

    const char *		widgetName= "tedFormatTool";
    const char *		pixmapName= "tedtable";

    tar= (TedAppResources *)ea->eaResourceData;

    if  ( tar->tarInspector )
	{
	ai= tar->tarInspector;

	appShowShellWidget( ai->aiApplication, ai->aiTopWidget );

	return;
	}

    if  ( ! gotResources )
	{
	tedFontToolGetResourceTable( ea,
				&(tftr.tttrFontToolResources),
				&(tftr.tttrSubjectResources[TEDtsiFONT]) );

	tedFormatToolGetTextOrnamentsResourceTable( ea,
				&(tftr.tttrTextOrnamentsToolResources),
				&(tftr.tttrSubjectResources[TEDtsiTEXT_ORN]) );

	tedFormatToolGetParaLayoutResourceTable( ea,
				&(tftr.tttrParaLayoutToolResources),
				&(tftr.tttrSubjectResources[TEDtsiPARA_LAY]) );

	tedFormatToolGetTabsResourceTable( ea,
				&(tftr.tttrTabsToolResources),
				&(tftr.tttrSubjectResources[TEDtsiTABS]) );

	tedFormatToolGetParaOrnamentsResourceTable( ea,
				&(tftr.tttrParaOrnamentsToolResources),
				&(tftr.tttrSubjectResources[TEDtsiPARA_ORN]) );

	tedFormatToolGetListsResourceTable( ea,
				&(tftr.tttrListsToolResources),
				&(tftr.tttrSubjectResources[TEDtsiLISTS]) );

	tedFormatToolGetSectResourceTable( ea,
				&(tftr.tttrSectToolResources),
				&(tftr.tttrSubjectResources[TEDtsiSECT]) );

	tedFormatToolGetTableResourceTable( ea,
				&(tftr.tttrTableToolResources),
				&(tftr.tttrSubjectResources[TEDtsiTABLE]) );

	tedFormatToolGetRowResourceTable( ea,
				&(tftr.tttrRowToolResources),
				&(tftr.tttrSubjectResources[TEDtsiROW]) );

	tedFormatToolGetColumnResourceTable( ea,
				&(tftr.tttrColumnToolResources),
				&(tftr.tttrSubjectResources[TEDtsiCOLUMN]) );

	tedFormatToolGetCellResourceTable( ea,
				&(tftr.tttrCellToolResources),
				&(tftr.tttrSubjectResources[TEDtsiCELL]) );

	appPageLayoutPageGetResourceTable( ea,
				&(tftr.tttrPageLayoutToolResources),
				&(tftr.tttrSubjectResources[TEDtsiPAGE]) );

	tedFormatToolGetHeaderFooterResourceTable( ea,
				&(tftr.tttrHeadFootToolResources),
				&(tftr.tttrSubjectResources[TEDtsiHEADFOOT]) );

	tedFormatToolGetNotesResourceTable( ea,
				&(tftr.tttrNotesToolResources),
				&(tftr.tttrSubjectResources[TEDtsiNOTES]) );

	tedLinkToolGetResourceTable( ea,
				&(tftr.tttrLinkToolResources),
				&(tftr.tttrSubjectResources[TEDtsiLINK]) );

	tedBookmarkToolGetResourceTable( ea,
				&(tftr.tttrBookmarkToolResources),
				&(tftr.tttrSubjectResources[TEDtsiBOOKMARK]) );

	tedImageToolGetResourceTable( ea,
				&(tftr.tttrImageToolResources),
				&(tftr.tttrSubjectResources[TEDtsiIMAGE]) );

#	if USE_FRAME_TOOL
	tedFrameToolGetResourceTable( ea,
				&(tftr.tttrFrameToolResources),
				&(tftr.tttrSubjectResources[TEDtsiFRAME]) );
#	endif

	tedTocToolGetResourceTable( ea,
				&(tftr.tttrTocToolResources),
				&(tftr.tttrSubjectResources[TEDtsiTOC]) );

	appSymbolPickerGetResourceTable( ea,
				&(tftr.tttrSymbolPickerResources),
				&(tftr.tttrSubjectResources[TEDtsiSYMBOL]) );

	appFindToolGetResourceTable( ea,
				&(tftr.tttrFindToolResources),
				&(tftr.tttrSubjectResources[TEDtsiFIND]) );

	appSpellToolGetResourceTable( ea,
				&(tftr.tttrSpellToolResources),
				&(tftr.tttrSubjectResources[TEDtsiSPELL]) );

	appRgbChooserPageGetResourceTable( ea,
				&(tftr.tttrRgbChooserToolResources),
				&(tftr.tttrSubjectResources[TEDtsiRGB]) );

	gotResources= 1;
	}

    tft= (TedFormatTool *)malloc( sizeof(TedFormatTool) );
    if  ( ! tft )
	{ XDEB(tft); return;	}

    tft->tftApplication= ea;

    /******/
    tedInitColumnTool( &(tft->tftColumnTool) );
    tedInitCellTool( &(tft->tftCellTool) );
    tedInitParaOrnamentsTool( &(tft->tftParagraphOrnamentsTool) );
    tedInitRowTool( &(tft->tftRowTool) );
    tedInitLinkTool( &(tft->tftLinkTool) );
    tedInitBookmarkTool( &(tft->tftBookmarkTool) );
    tedInitImageTool( &(tft->tftImageTool) );
    tedInitFrameTool( &(tft->tftFrameTool) );
    tedInitTocTool( &(tft->tftTocTool) );
    appInitSymbolPicker( &(tft->tftSymbolPicker) );
    appInitFindTool( &(tft->tftFindTool) );
    appInitSpellTool( &(tft->tftSpellTool) );

    /******/
    tft->tftTableTool.ttApplication= ea;
    tft->tftRowTool.rtApplication= ea;
    tft->tftColumnTool.ctApplication= ea;
    tft->tftCellTool.ctApplication= ea;
    tft->tftParagraphLayoutTool.ptApplication= ea;
    tft->tftTabsTool.ttApplication= ea;
    tft->tftParagraphOrnamentsTool.potApplication= ea;
    tft->tftListsTool.ltApplication= ea;
    tft->tftSectionTool.stApplication= ea;
    tft->tftPageLayoutTool.pltApplication= ea;
    tft->tftHeaderFooterTool.hftApplication= ea;
    tft->tftNotesTool.ntApplication= ea;
    tft->tftFontTool.afcApplication= ea;
    tft->tftTextOrnamentsTool.totApplication= ea;
    tft->tftLinkTool.ltApplication= ea;
    tft->tftBookmarkTool.btApplication= ea;
    tft->tftImageTool.itApplication= ea;
    tft->tftFrameTool.ftApplication= ea;
    tft->tftTocTool.ttApplication= ea;
    tft->tftSymbolPicker.spApplication= ea;
    tft->tftFindTool.aftApplication= ea;
    tft->tftSpellTool.astApplication= ea;
    tft->tftRgbPage.rcpApplication= ea;

    ai= appMakeInspector( ea, option, pixmapName, widgetName,
				    tftr.tttrSubjectResources, TEDtsi_COUNT,
				    tedDestroyFormatTool, (void *)tft );

    tft->tftInspector= ai;
    ai->aiNotifySubject= tedFormatToolNotifySubject;

    /******/
    tft->tftTableTool.ttInspector= ai;
    tft->tftRowTool.rtInspector= ai;
    tft->tftColumnTool.ctInspector= ai;
    tft->tftCellTool.ctInspector= ai;
    tft->tftParagraphLayoutTool.ptInspector= ai;
    tft->tftTabsTool.ttInspector= ai;
    tft->tftParagraphOrnamentsTool.potInspector= ai;
    tft->tftListsTool.ltInspector= ai;
    tft->tftSectionTool.stInspector= ai;
    tft->tftPageLayoutTool.pltInspector= ai;
    tft->tftHeaderFooterTool.hftInspector= ai;
    tft->tftNotesTool.ntInspector= ai;
    tft->tftFontTool.afcInspector= ai;
    tft->tftTextOrnamentsTool.totInspector= ai;
    tft->tftLinkTool.ltInspector= ai;
    tft->tftBookmarkTool.btInspector= ai;
    tft->tftImageTool.itInspector= ai;
    tft->tftFrameTool.ftInspector= ai;
    tft->tftTocTool.ttInspector= ai;
    tft->tftSymbolPicker.spInspector= ai;
    tft->tftFindTool.aftInspector= ai;
    tft->tftSpellTool.astInspector= ai;
    tft->tftRgbPage.rcpInspector= ai;

    /******/

    tedFormatFillPages( &tftr, tft, ai );

    /******/

    tft->tftFontTool.afcSetFont= tedFontToolSet;

    tft->tftSymbolPicker.spTarget= ea;
    tft->tftSymbolPicker.spInsert= tedSymbolPickerInsert;

    /******/
    /*tedFormatFillTableChoosers()*/
    tedRowToolFillChoosers( &(tft->tftRowTool),
					    &(tftr.tttrRowToolResources) );
    tedColumnToolFillChoosers( &(tft->tftColumnTool),
					&(tftr.tttrColumnToolResources) );
    tedCellToolFillChoosers( &(tft->tftCellTool),
					&(tftr.tttrCellToolResources) );
    tedParaLayoutToolFillChoosers( &(tft->tftParagraphLayoutTool),
				    &(tftr.tttrParaLayoutToolResources) );
    tedTabsToolFillChoosers( &(tft->tftTabsTool) );
    tedParaOrnamentsToolFillChoosers( &(tft->tftParagraphOrnamentsTool),
				    &(tftr.tttrParaOrnamentsToolResources) );
    tedFormatFillListChoosers( &(tft->tftListsTool) );
    tedFormatFillSectionChoosers( &(tft->tftSectionTool),
					    &(tftr.tttrSectToolResources) );
    appPageLayoutPageFillChoosers( &(tft->tftPageLayoutTool),
					&(tftr.tttrPageLayoutToolResources) );
    tedFormatFillHeaderFooterChoosers( &(tft->tftHeaderFooterTool),
					&(tftr.tttrHeadFootToolResources) );
    tedFormatFillNotesChoosers( &(tft->tftNotesTool),
					&(tftr.tttrNotesToolResources) );
    appFontToolFillChoosers( &(tft->tftFontTool),
					&(tftr.tttrFontToolResources) );
    tedFormatFillTextOrnamentsChoosers( &(tft->tftTextOrnamentsTool),
				    &(tftr.tttrTextOrnamentsToolResources) );
    tedLinkToolFillChoosers( &(tft->tftLinkTool) );
    tedBookmarkToolFillChoosers( &(tft->tftBookmarkTool) );
    /*tedImageToolFillChoosers()*/
#   if USE_FRAME_TOOL
    tedFrameToolFillChoosers( &(tft->tftFrameTool),
					&(tftr.tttrFrameToolResources) );
#   endif
    tedTocToolFillChoosers( &(tft->tftTocTool),
					&(tftr.tttrTocToolResources) );
    appSymbolPickerFillChoosers( &(tft->tftSymbolPicker),
					&(tftr.tttrSymbolPickerResources) );
    appSpellToolFillChoosers( &(tft->tftSpellTool),
					&(tftr.tttrSpellToolResources) );
    /******/

    appFinishInspector( ai );

    tedFormatFinishRowPage( &(tft->tftRowTool),
					    &(tftr.tttrRowToolResources) );
    tedFinishParaLayoutPage( &(tft->tftParagraphLayoutTool), tft,
					&(tftr.tttrParaLayoutToolResources) );
    tedFormatFinishTabsPage( &(tft->tftTabsTool) );
    tedFormatFinishParaOrnamentsPage( &(tft->tftParagraphOrnamentsTool), tft,
				    &(tftr.tttrParaOrnamentsToolResources) );
    tedFormatFinishListPage( &(tft->tftListsTool) );
    tedFormatFinishSectionPage( &(tft->tftSectionTool), tft,
					    &(tftr.tttrSectToolResources) );
    tedFormatFinishPageLayoutPage( &(tft->tftPageLayoutTool), tft,
					&(tftr.tttrPageLayoutToolResources) );
    tedFormatFinishHeaderFooterPage( &(tft->tftHeaderFooterTool), tft,
					&(tftr.tttrHeadFootToolResources) );
    tedFormatFinishColumnPage( &(tft->tftColumnTool),
					&(tftr.tttrColumnToolResources) );
    tedFormatFinishCellPage( &(tft->tftCellTool), tft,
					&(tftr.tttrCellToolResources) );
    tedFormatFinishNotesPage( &(tft->tftNotesTool), tft,
					&(tftr.tttrNotesToolResources) );
    appFontToolFinishPage( &(tft->tftFontTool),
					&(tftr.tttrFontToolResources) );
    tedFinishTextOrnamentsPage( &(tft->tftTextOrnamentsTool),
				    &(tftr.tttrTextOrnamentsToolResources) );
    tedFinishLinkTool( &(tft->tftLinkTool) );
    tedFinishBookmarkTool( &(tft->tftBookmarkTool) );
#   if USE_FRAME_TOOL
    tedFinishFrameTool( &(tft->tftFrameTool),
					&(tftr.tttrFrameToolResources) );
#   endif
    tedFinishTocTool( &(tft->tftTocTool),
					&(tftr.tttrTocToolResources) );
    appFinishSymbolPicker( &(tft->tftSymbolPicker),
					&(tftr.tttrSymbolPickerResources) );
    appFinishSpellTool( &(tft->tftSpellTool),
					&(tftr.tttrSpellToolResources) );

    appRgbChooserPageFinishPage( &(tft->tftRgbPage),
					&(tftr.tttrRgbChooserToolResources) );

    tar->tarInspector= ai;

    return;
    }

/************************************************************************/
/*									*/
/*  Ask the table tool to adapt itself to the selection.		*/
/*									*/
/************************************************************************/

void tedFormatShowPagePage(	EditApplication *	ea )
    {
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;

    if  ( ! tar->tarInspector )
	{ XDEB(tar->tarInspector); return;	}

    appEnableInspectorSubject( tar->tarInspector, TEDtsiPAGE, 1 );

    appInspectorSelectSubject( tar->tarInspector, TEDtsiPAGE );

    return;
    }

void tedFormatShowLinkPage(	EditApplication *	ea )
    {
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;

    if  ( ! tar->tarInspector )
	{ XDEB(tar->tarInspector); return;	}

    appEnableInspectorSubject( tar->tarInspector, TEDtsiLINK, 1 );

    appInspectorSelectSubject( tar->tarInspector, TEDtsiLINK );

    return;
    }

void tedFormatShowBookmarkPage(	EditApplication *	ea )
    {
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;

    if  ( ! tar->tarInspector )
	{ XDEB(tar->tarInspector); return;	}

    appEnableInspectorSubject( tar->tarInspector, TEDtsiBOOKMARK, 1 );

    appInspectorSelectSubject( tar->tarInspector, TEDtsiBOOKMARK );

    return;
    }

static void tedFormatRefreshToolPages(	int *				enabled,
					int *				prefs,
					TedFormatTool *			tft,
					AppInspector *			ai,
					EditDocument *			ed,
					DocumentTree *			ei,
					const DocumentSelection *	ds,
					const SelectionGeometry *	sg,
					const SelectionDescription *	sd )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    tedRefreshFontTool( &(tft->tftFontTool),
				    enabled+ TEDtsiFONT,
				    prefs+ TEDtsiFONT,
				    ai->aiSubjects+ TEDtsiFONT,
				    ds, sd, bd, ed->edDocumentId );

    tedRefreshTextOrnamentsTool( &(tft->tftTextOrnamentsTool),
				    enabled+ TEDtsiTEXT_ORN,
				    prefs+ TEDtsiTEXT_ORN,
				    ai->aiSubjects+ TEDtsiTEXT_ORN,
				    ed, ds, sg, sd );

    tedRefreshParaLayoutTool(  &(tft->tftParagraphLayoutTool),
				    enabled+ TEDtsiPARA_LAY,
				    prefs+ TEDtsiPARA_LAY,
				    ai->aiSubjects+ TEDtsiPARA_LAY,
				    ds, sg, sd );

    tedRefreshTabsTool( &(tft->tftTabsTool),
				    enabled+ TEDtsiTABS,
				    prefs+ TEDtsiTABS,
				    ai->aiSubjects+ TEDtsiTABS,
				    ds, sg, sd, &(bd->bdProperties) );

    tedRefreshParaOrnamentsTool(  &(tft->tftParagraphOrnamentsTool),
				    enabled+ TEDtsiPARA_ORN,
				    prefs+ TEDtsiPARA_ORN,
				    ai->aiSubjects+ TEDtsiPARA_ORN,
				    ds, sg, sd );

    tedRefreshListTool(  &(tft->tftListsTool),
				    enabled+ TEDtsiLISTS,
				    prefs+ TEDtsiLISTS,
				    ai->aiSubjects+ TEDtsiLISTS,
				    ds, sd, bd );

    tedRefreshTableTool( &(tft->tftTableTool),
				    enabled+ TEDtsiTABLE,
				    prefs+ TEDtsiTABLE,
				    ai->aiSubjects+ TEDtsiTABLE,
				    ds, sg, sd );

    tedRefreshColumnTool( &(tft->tftColumnTool),
				    enabled+ TEDtsiCOLUMN,
				    prefs+ TEDtsiCOLUMN,
				    ai->aiSubjects+ TEDtsiCOLUMN,
				    ds, sg, sd );

    tedRefreshRowTool( &(tft->tftRowTool),
				    enabled+ TEDtsiROW,
				    prefs+ TEDtsiROW,
				    ai->aiSubjects+ TEDtsiROW,
				    ds, sg, sd );

    tedRefreshCellTool( &(tft->tftCellTool),
				    enabled+ TEDtsiCELL,
				    prefs+ TEDtsiCELL,
				    ai->aiSubjects+ TEDtsiCELL,
				    ds, sd, bd );

    tedRefreshSectionTool( &(tft->tftSectionTool),
				    enabled+ TEDtsiSECT,
				    prefs+ TEDtsiSECT,
				    ai->aiSubjects+ TEDtsiSECT,
				    ds, sd, bd );

    tedRefreshPageLayoutTool( &(tft->tftPageLayoutTool),
				    enabled+ TEDtsiPAGE,
				    prefs+ TEDtsiPAGE,
				    ai->aiSubjects+ TEDtsiPAGE,
				    ds, sd, bd );

    tedRefreshHeaderFooterTool( &(tft->tftHeaderFooterTool),
				    enabled+ TEDtsiHEADFOOT,
				    prefs+ TEDtsiHEADFOOT,
				    ai->aiSubjects+ TEDtsiHEADFOOT,
				    ds, sd, sg, bd );

    tedRefreshNotesTool( &(tft->tftNotesTool),
				    enabled+ TEDtsiNOTES,
				    prefs+ TEDtsiNOTES,
				    ai->aiSubjects+ TEDtsiNOTES,
				    ds, sd, bd );

    tedRefreshLinkTool( &(tft->tftLinkTool),
				    enabled+ TEDtsiLINK,
				    prefs+ TEDtsiLINK,
				    ai->aiSubjects+ TEDtsiLINK,
				    ds, sd, bd );

    tedRefreshBookmarkTool( &(tft->tftBookmarkTool),
				    enabled+ TEDtsiBOOKMARK,
				    prefs+ TEDtsiBOOKMARK,
				    ai->aiSubjects+ TEDtsiBOOKMARK,
				    ds, sd, ei, bd );

    tedRefreshImageTool( &(tft->tftImageTool),
				    enabled+ TEDtsiIMAGE,
				    prefs+ TEDtsiIMAGE,
				    ai->aiSubjects+ TEDtsiIMAGE,
				    ds, sd, bd );

#   if USE_FRAME_TOOL
    tedRefreshFrameTool( &(tft->tftFrameTool),
				    enabled+ TEDtsiFRAME,
				    prefs+ TEDtsiFRAME,
				    ai->aiSubjects+ TEDtsiFRAME,
				    ds, sd, bd );
#   endif

    tedRefreshTocTool( &(tft->tftTocTool),
				    enabled+ TEDtsiTOC,
				    prefs+ TEDtsiTOC,
				    ai->aiSubjects+ TEDtsiTOC,
				    ds, sd, bd );

    tedRefreshSymbolPicker( &(tft->tftSymbolPicker),
				    enabled+ TEDtsiSYMBOL,
				    prefs+ TEDtsiSYMBOL,
				    ai->aiSubjects+ TEDtsiSYMBOL,
				    ds, sd, bd, ed->edDocumentId );

    tedRefreshFindTool( &(tft->tftFindTool),
				    enabled+ TEDtsiFIND,
				    prefs+ TEDtsiFIND,
				    ai->aiSubjects+ TEDtsiFIND,
				    ds, sd, bd, ed->edDocumentId );

    tedRefreshSpellTool( &(tft->tftSpellTool),
				    enabled+ TEDtsiSPELL,
				    prefs+ TEDtsiSPELL,
				    ai->aiSubjects+ TEDtsiSPELL,
				    ds, sd, bd, ed->edDocumentId );

    /*  no refresh  */
    enabled[TEDtsiRGB]= 0;

    return;
    }

void tedFormatToolAdaptToSelection( AppInspector *		ai,
				EditDocument *			ed,
				int				choosePage,
				DocumentTree *			ei,
				const DocumentSelection *	ds,
				const SelectionGeometry *	sg,
				const SelectionDescription *	sd )
    {
    TedFormatTool *		tft= (TedFormatTool *)ai->aiTarget;

    int				subject;
    int				enabled[TEDtsi_COUNT];
    int				prefs[TEDtsi_COUNT];
    int				highest= -1;
    int				preferred= -1;

    for ( subject= 0; subject < TEDtsi_COUNT; subject++ )
	{
	enabled[subject]= 1;
	prefs[subject]= 5;
	}

    if  ( ! ds->dsHead.dpBi )
	{ appEnableInspector( ai, 0 ); return; }
    else{
	tedFormatRefreshToolPages( enabled, prefs, tft, ai, ed,
							ei, ds, sg, sd );

	/*
	if  ( ed->edFileReadOnly )
	    { appEnableInspector( ai, 0 );	}
	else{ appEnableInspector( ai, 1 );	}
	*/
	}

    for ( subject= 0; subject < TEDtsi_COUNT; subject++ )
	{
	appEnableInspectorSubject( ai, subject,
				    enabled[subject] != 0 );

	if  ( enabled[subject] && prefs[subject] > highest )
	    { preferred= subject; highest= prefs[subject]; }
	}

    if  ( ai->aiCurrentSubject < 0				||
	  choosePage						||
	  ! ai->aiSubjects[ai->aiCurrentSubject].isEnabled	)
	{ appInspectorSelectSubject( ai, preferred );	}
    }

BufferDocument * tedFormatCurDoc(	EditDocument **		pEd,
					EditApplication *	ea )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    TedDocument *		td;
    BufferDocument *		bd;

    if  ( ! ed )
	{ XDEB(ed); return (BufferDocument *)0;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;

    *pEd= ed; return bd;
    }

