/************************************************************************/
/*									*/
/*  The 'Font Tool':							*/
/*									*/
/*  Most of the ont tool calls directly go to the AppFontTool.		*/
/*  the document.							*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<limits.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Intermediary routine to refresh the text font tool.			*/
/*									*/
/************************************************************************/

void tedRefreshFontTool(	AppFontChooser *		afc,
				int *				pEnabled,
				int *				pPref,
				InspectorSubject *		is,
				const DocumentSelection *	ds,
				const SelectionDescription *	sd,
				const BufferDocument *		bd,
				int				documentId )
    {
    const DocumentProperties *	dp= &(bd->bdProperties);
    const DocumentFontList *	dfl= &(dp->dpFontList);

    if  ( sd->sdIsListBullet )
	{
	afc->afcSetFont= tedListFontToolSet;
	}
    else{
	afc->afcSetFont= tedFontToolSet;
	(*pPref)++;
	}

    if  ( appFontExpandCurrentFont( afc, &(sd->sdTextAttributeMask),
				    &(sd->sdTextAttribute), documentId,
				    dfl, dp->dpColors, dp->dpColorCount ) )
	{ LDEB(1);	}

    *pEnabled= ! sd->sdDocumentReadonly;

    return;
    }

void tedFormatShowFontPage(	EditApplication *	ea )
    {
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;

    if  ( ! tar->tarInspector )
	{ XDEB(tar->tarInspector); return;	}

    appEnableInspectorSubject( tar->tarInspector, TEDtsiFONT, 1 );

    appInspectorSelectSubject( tar->tarInspector, TEDtsiFONT );

    return;
    }

/************************************************************************/
/*									*/
/*  Resources.								*/
/*									*/
/************************************************************************/

static AppConfigurableResource TED_FontToolSubjectResourceTable[]=
    {
    APP_RESOURCE( "fontToolFont",
		offsetof(InspectorSubjectResources,isrSubjectName),
		"Font" ),
    APP_RESOURCE( "fontToolSet",
		offsetof(InspectorSubjectResources,isrApplyToSubject),
		"Set" ),
    APP_RESOURCE( "fontToolRevert",
		offsetof(InspectorSubjectResources,isrRevert),
		"Revert" ),
    };

void tedFontToolGetResourceTable(	EditApplication *		ea,
					AppFontToolResources *		aftr,
					InspectorSubjectResources *	isr )
    {
    static int	gotSubjectResources= 0;

    appFontToolGetResourceTable( ea, aftr );

    if  ( ! gotSubjectResources )
	{
	appGuiGetResourceValues( &gotSubjectResources, ea, (void *)isr,
				TED_FontToolSubjectResourceTable,
				sizeof(TED_FontToolSubjectResourceTable)/
				sizeof(AppConfigurableResource) );
	}

    return;
    }

