/************************************************************************/
/*									*/
/*  Ted: Manipulation of font and text attributes.			*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	"tedEdit.h"
#   include	"docScreenLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Get font properties of the current position or selection.		*/
/*									*/
/************************************************************************/

int tedGetDocumentAttributes(	TedDocument *		td,
				PropertyMask *		pUpdMask,
				TextAttribute *		pTaNew )
    {
    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    if  ( ! tedHasSelection( td ) )
	{ return 1;	}

    if  ( tedGetSelection( &ds, &sg, &sd,
			    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ LDEB(1); return 1;	}

    *pUpdMask= sd.sdTextAttributeMask;
    *pTaNew= sd.sdTextAttribute;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Change the attributes of a particule.				*/
/*									*/
/************************************************************************/

int tedChangeParticuleAttributes(
				PropertyMask *			pTaAllMask,
				const LayoutContext *		lc,
				BufferItem *			paraBi,
				int				partFrom,
				int				partUpto,
				const TextAttribute *		taSet,
				const PropertyMask *		taSetMask )
    {
    if  ( docChangeParticuleAttributes( pTaAllMask, lc->lcDocument,
						paraBi, partFrom, partUpto,
						taSet, taSetMask ) )
	{ LDEB(1); return -1;	}

    if  ( docScreenLayoutOpenParaFonts( lc, paraBi, partFrom, partUpto ) )
	{ LDEB(1); return -1;	}

    return 0;
    }
