/************************************************************************/
/*									*/
/*  Ted: Interface to the generic find tool.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	"tedFind.h"
#   include	"tedFormatTool.h"
#   include	"tedFindTool.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Switch to the find page of the inspector.				*/
/*									*/
/************************************************************************/

void tedFormatShowFindPage(	EditApplication *	ea )
    {
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;

    if  ( ! tar->tarInspector )
	{ XDEB(tar->tarInspector); return;	}

    appEnableInspectorSubject( tar->tarInspector, TEDtsiFIND, 1 );

    appInspectorSelectSubject( tar->tarInspector, TEDtsiFIND );

    return;
    }

/************************************************************************/
/*									*/
/*  Enter a predefined pattern in the format tool.			*/
/*									*/
/************************************************************************/

void tedFormatSetFindPattern(	EditApplication *	ea,
				const char *		findPattern,
				int			findRegexp )
    {
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;
    AppInspector *		ai= tar->tarInspector;
    TedFormatTool *		tft;
    FindTool *			aft;

    if  ( ! tar->tarInspector )
	{ XDEB(tar->tarInspector); return;	}
    tft= (TedFormatTool *)ai->aiTarget;
    aft= &(tft->tftFindTool);

    appFindToolSetPattern( aft, findPattern, findRegexp );

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt find tool to the current document.				*/
/*									*/
/************************************************************************/

void tedRefreshFindTool(	FindTool *			aft,
				int *				pEnabled,
				int *				pPref,
				InspectorSubject *		is,
				const DocumentSelection *	ds,
				const SelectionDescription *	sd,
				const BufferDocument *		bd,
				int				documentId )
    {
    appFindToolEnableReplace( aft, sd->sdCanReplace );
    return;
    }

/************************************************************************/
/*									*/
/*  Build a find tool and connect it to Ted.				*/
/*									*/
/************************************************************************/

void tedFillFindTool(		FindTool *			aft,
				const FindToolResources *	aftr,
				AppInspector *			ai,
				int				subjectPage,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr )
    {
    appFillFindTool( aft, aftr, ai, subjectPage, is, pageWidget, isr );

    aft->aftFindNext= tedFindToolFindNext;
    aft->aftFindPrev= tedFindToolFindPrev;
    aft->aftSetPattern= tedFindToolSetPattern;
    aft->aftReplace= tedAppReplace;

    return;
    }
