/************************************************************************/
/*									*/
/*  Ted, main module.							*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>
#   include	<ctype.h>
#   include	<ctype.h>

#   include	<appSystem.h>

#   include	"tedApp.h"

#   include	<psTtf.h>
#   include	<psBuildConfigFiles.h>
#   include	<sioStdio.h>
#   include	<sioStdin.h>
#   include	<sioStdout.h>
#   include	<sioMemory.h>
#   include	<sioBase64.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Miscelaneous file conversion calls.					*/
/*									*/
/************************************************************************/

static int tedFileConvert(
		    const char *	nameIn,
		    const char *	nameOut,
		    int (*cvf)(	SimpleOutputStream *	_sosOut,
				const char *		_nameIn,
				SimpleInputStream *	_sisIn ) )
    {
    int				rval= 0;
    SimpleOutputStream *	sosOut= (SimpleOutputStream *)0;
    SimpleInputStream *		sisIn= (SimpleInputStream *)0;

    if  ( ! strcmp( nameIn, "-" ) )
	{
	sisIn= sioInStdinOpen();
	if  ( ! sisIn )
	    { SXDEB(nameIn,sisIn); rval= -1; goto ready;	}
	}
    else{
	sisIn= sioInStdioOpen( nameIn );
	if  ( ! sisIn )
	    { SXDEB(nameIn,sisIn); rval= -1; goto ready;	}
	}

    if  ( ! strcmp( nameOut, "-" ) )
	{
	sosOut= sioOutStdoutOpen();
	if  ( ! sosOut )
	    { SXDEB(nameOut,sosOut); rval= -1; goto ready;	}
	}
    else{
	sosOut= sioOutStdioOpen( nameOut );
	if  ( ! sosOut )
	    { SXDEB(nameOut,sosOut); rval= -1; goto ready;	}
	}

    if  ( (*cvf)( sosOut, nameIn, sisIn ) )
	{ SSDEB(nameOut,nameIn); rval= -1; goto ready;	}

  ready:

    if  ( sosOut )
	{ sioOutClose( sosOut );	}
    if  ( sisIn )
	{ sioInClose( sisIn );	}

    return rval;
    }

int tedTtfToAfm(		EditApplication *	ea,
				const char *		prog,
				const char *		call,
				int			argc,
				char **			argv )
    {
    if  ( argc < 2 )
	{ SLDEB(argv[0],argc); return 1;	}

    if  ( tedFileConvert( argv[0], argv[1], psTtfToAfm ) )
	{ SSSDEB(call,argv[0],argv[1]); return -1;	}

    return 2;
    }

int tedAfmToGSFontmap(		EditApplication *	ea,
				const char *		prog,
				const char *		call,
				int			argc,
				char **			argv )
    {
    if  ( argc < 2 )
	{ SLDEB(argv[0],argc); return 1;	}

    if  ( tedFileConvert( argv[0], argv[1], psAfmToGSFontmap ) )
	{ SSSDEB(call,argv[0],argv[1]); return -1;	}

    return 2;
    }
