/************************************************************************/
/*									*/
/*  Ted: data structures and routines for on screen interactive		*/
/*  editing.								*/
/*									*/
/************************************************************************/

#   ifndef		TED_EDIT_H
#   define		TED_EDIT_H

#   include	"tedApp.h"
#   include	"docEdit.h"
#   include	"layoutContext.h"

typedef struct TedEditOperation
    {
    EditDocument *	teoEditDocument;
    EditOperation	teoEo;
    LayoutContext	teoLayoutContext;

    DocumentRectangle	teoChangedRect;
    int			teoChangedRectSet;
    int			teoOldBackY1;

    /**/
    TextAttribute	teoSavedTextAttribute;
    int			teoSavedTextAttributeNumber;
    } TedEditOperation;

/************************************************************************/
/*									*/
/*  Routine Declarations:						*/
/*									*/
/************************************************************************/

extern void tedInitTedEditOperation(	TedEditOperation *	teo );

extern int tedAdjustParagraphLayout(
				TedEditOperation *		teo,
				BufferItem *			paraBi );

extern int tedStartEditOperation(
				TedEditOperation *		teo,
				SelectionGeometry *		sg,
				SelectionDescription *		sd,
				EditDocument *			ed,
				int				fullWidth );

extern int tedEditFinishIBarSelection(	TedEditOperation *	teo,
					BufferItem *		bi,
					int			stroff );

extern int tedEditFinishSelection(
				TedEditOperation *		teo,
				const DocumentSelection *	dsNew );

extern int tedEditFinishOldSelection(
				TedEditOperation *		teo );

extern int tedEditFinishOldSelectionEnd(
				TedEditOperation *		teo );

extern int tedEditReplaceSelection(	TedEditOperation *	teo,
					const char *		addedText,
					int			addedLength );

extern int tedEditDeleteSelection(	TedEditOperation *	teo );

extern int tedSplitParaItem(		BufferItem **		pNewParaBi,
					TedEditOperation *	teo,
					int			splitLevel,
					int			onNewPage );

extern int tedEditIncludeItemInRedraw(	TedEditOperation *	teo,
					const BufferItem *	bi );

extern int tedEditIncludeRowsInRedraw(	TedEditOperation *	teo,
					const BufferItem *	sectBi,
					int			row0,
					int			row1 );

extern int tedChangeParticuleAttributes( PropertyMask *		pTaAllMask,
					const LayoutContext *	lc,
					BufferItem *		bi,
					int			partFrom,
					int			partUpto,
					const TextAttribute *	taSet,
					const PropertyMask *	taSetMask );

extern void tedIncludeRectangleInChange( TedEditOperation *		teo,
					const DocumentRectangle *	dr );

extern int tedFinishSetField(	DocumentSelection *		dsField,
				TedEditOperation *		teo,
				unsigned int			whenMask );

extern void tedFlattenField(	EditDocument *			ed,
				const DocumentSelection *	dsAroundField,
				int				headPart,
				int				tailPart,
				DocumentField *			df );

extern int tedDocReplaceSelectionWithField(
					DocumentField **	pDf,
					int *			pHeadPart,
					int *			pTailPart,
					DocumentSelection *	dsField,
					TedEditOperation *	teo,
					const MemoryBuffer *	mbFieldInst,
					int			fieldKind,
					const PropertyMask *	taSetMask,
					const TextAttribute *	taSet );

extern int tedLayoutFieldItem(		TedEditOperation *	teo,
					DocumentSelection *	dsField,
					unsigned int		whenMask );

extern int tedDocFlattenTypedField(	EditDocument *		ed,
					int			fieldType );

extern int tedReplaceSelectionWithBitmapImage(	EditDocument *		ed,
						AppBitmapImage *	abi );

#   endif	/*	TED_EDIT_H	*/
