/************************************************************************/
/*									*/
/*  Ted, Screen drawing and forcing drawing through			*/
/*  appExposeRectangle().						*/
/*									*/
/************************************************************************/

#   ifndef	TED_DRAW_H
#   define	TED_DRAW_H

#   include	"docDraw.h"
#   include	"appDraw.h"

#   include	<appDebugon.h>

#   define	LOG_REDRAWS	0
#   define	BLINK_IBAR	1

#   if		LOG_REDRAWS
#	undef	BLINK_IBAR
#	define	BLINK_IBAR	0
#   endif

typedef struct ScreenDrawingData
    {
    RGB8Color			sddForeColor;
    RGB8Color			sddBackColor;
    RGB8Color			sddGridColor;
    RGB8Color			sddPageColor;

    DocumentTree *		sddSelRootEi;
    BufferItem *		sddSelRootBi;
    BufferItem *		sddSelRootBodySectBi;
    int				sddBoxFirstPage;
    int				sddBoxLastPage;
    } ScreenDrawingData;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int tedDrawDrawingShape(	const DocumentRectangle *	drTwips,
				int				page,
				DrawingShape *			ds,
				DrawingContext *		dc,
				void *				vsdd );

extern int tedDrawTextReverse(	BufferItem *			paraBi,
				int				line,
				const ParagraphFrame *		pf,
				const DocumentRectangle *	drLine,
				void *				vsdd,
				DrawingContext *		dc,
				const BlockOrigin *		bo );

extern int tedDrawTextSelected(	BufferItem *			paraBi,
				int				line,
				const ParagraphFrame *		pf,
				const DocumentRectangle *	drLine,
				void *				vsdd,
				DrawingContext *		dc,
				const BlockOrigin *		bo );

extern int tedDrawTextLine(	BufferItem *			paraBi,
				int				line,
				const ParagraphFrame *		pf,
				const DocumentRectangle *	drLine,
				void *				vsdd,
				DrawingContext *		dc,
				const BlockOrigin *		bo );

extern void tedOriginalClipping( DrawingContext *		dc,
				ScreenDrawingData *		sdd );

extern void tedDrawPixmap(	const LayoutContext *		lc,
				const ScreenPixmap		sp,
				int				xSrc,
				int				ySrc,
				int				wide,
				int				high,
				int				xDest,
				int				yDest );

extern void tedDrawFreePixmap(	ScreenPixmap			sp );

extern int tedDrawIBar(	const DocumentRectangle *	drPixels,
			const LayoutContext *		lc );

extern void tedGetIBarRect(
			DocumentRectangle *		drPixels,
			const PositionGeometry *	pg,
			const LayoutContext *		lc );

extern int tedDrawObject(
			const TextParticule *		tp,
			int				x0PixelsShifted,
			int				baseLinePixels,
			const DocumentRectangle *	drClip,
			const LayoutContext *		lc );

extern void tedDrawShadedRectangle(
			const LayoutContext *	lc,
			APP_BITMAP_IMAGE	shadingPixmaps[DOCsp_COUNT],
			int			pattern,
			int			x0,
			int			x1,
			int			y0,
			int			y1 );

extern void tedDrawHorizontalBorderLine(AppDrawingData *	add,
					int			style,
					int			minThick,
					int			x0,
					int			x1,
					int			y );

#   endif	/*  TED_DRAW_H	*/
