/************************************************************************/
/*									*/
/*  Ted: Boormark manipulation.						*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>

#   include	"tedEdit.h"
#   include	"docEvalField.h"

#   include	<appDebugon.h>

int tedDocGetBookmarkField(	DocumentField **		pDf,
				EditDocument *			ed,
				const char *			markName,
				int				markSize )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    return docGetBookmarkField( pDf, &(bd->bdFieldList), markName, markSize );
    }

int tedDocSetBookmark(	EditDocument *		ed,
			const char *		mark )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    DocumentField *		dfBookmark;
    int				newMarkSize;

    char *			adaptedMark= (char *)0;

    TedEditOperation		teo;
    EditOperation *		eo= &(teo.teoEo);

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    TextAttribute		taSet;
    PropertyMask		taSetMask;

    DocumentField *		dfFound;

    utilInitTextAttribute( &taSet );
    utilPropMaskClear( &taSetMask );

    tedStartEditOperation( &teo, &sg, &sd, ed, 0 );

    docEditOperationGetSelection( &ds, eo );

    adaptedMark= strdup( mark );
    if  ( ! adaptedMark )
	{ XDEB(adaptedMark); return -1;	}

    docAdaptBookmarkName( &newMarkSize, adaptedMark );

    if  ( docGetBookmarkField( &dfFound, &(bd->bdFieldList),
					    adaptedMark, newMarkSize ) >= 0 )
	{ SDEB(adaptedMark); return -1;	}

    dfBookmark= docFindTypedFieldForPosition( bd, &(ds.dsHead),
							    DOCfkBOOKMARK );
    if  ( ! dfBookmark )
	{
	DocumentSelection	dsRep;

	DocumentSelection	dsInside;
	DocumentSelection	dsAround;
	int			headPart;
	int			tailPart;
	const int		singlePara= 0;

	dsRep= ds;

	/*  4  */
	if  ( docSurroundTextSelectionByField( &dfBookmark,
						&dsInside, &dsAround,
						&headPart, &tailPart,
						bd, teo.teoEo.eoEi,
						singlePara, &dsRep,
						&taSetMask, &taSet ) )
	    { LDEB(1); return -1;	}

	if  ( docFieldSetBookmark( dfBookmark, adaptedMark, newMarkSize ) )
	    { SDEB(adaptedMark); return -1;	}

	/*  5  */
	if  ( tedFinishSetField( &dsInside, &teo, FIELDdoNOTHING ) )
	    { LDEB(1); return -1;	}

	return 0;
	}
    else{
	if  ( docFieldSetBookmark( dfBookmark, adaptedMark, newMarkSize ) )
	    { SDEB(adaptedMark); return -1;	}

	appDocumentChanged( ed, 1 );

	return 0;
	}
    }

/************************************************************************/
/*									*/
/*  Remove the bookmark that holds the head of the selection.		*/
/*  The contents of the bookmark are retained: Only the field is	*/
/*  removed.								*/
/*									*/
/************************************************************************/

int tedDocRemoveBookmark(	EditDocument *		ed )
    { return tedDocFlattenTypedField( ed, DOCfkBOOKMARK );	}

/************************************************************************/
/*									*/
/*  Select a particular bookmark in a document.				*/
/*									*/
/************************************************************************/

int tedDocGoToBookmark(	EditDocument *		ed,
			const char *		markName,
			int			markSize )
    {
    DocumentSelection		dsInside;
    int				partHead;
    int				partTail;

    TedDocument *		td;

    int				scrolledX= 0;
    int				scrolledY= 0;

    const int			lastLine= 0;

    td= (TedDocument *)ed->edPrivateData;

    docInitDocumentSelection( &dsInside );

    if  ( docFindBookmarkInDocument( &dsInside, &partHead, &partTail,
					td->tdDocument, markName, markSize ) )
	{ SDEB(markName); return -1;	}

    tedSetSelection( ed, &dsInside, lastLine, &scrolledX, &scrolledY );

    tedAdaptToolsToSelection( ed );

    return 0;
    }

