/************************************************************************/
/*									*/
/*  Ted, main module.							*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>
#   include	<ctype.h>
#   include	<sioGeneral.h>
#   include	<sioMemory.h>
#   include	<utilMatchFont.h>

#   include	"tedApp.h"
#   include	"appFileChooser.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Determine application specific default settings.			*/
/*									*/
/*  2)	Determine default for show table grid.				*/
/*									*/
/************************************************************************/

void tedDetermineDefaultSettings(	TedAppResources *	tar )
    {
    char *	past;

    /*  2  */
    if  ( tar->tarShowTableGridString		&&
	  tar->tarShowTableGridInt == 0		)
	{
	if  ( ! strcmp( tar->tarShowTableGridString, "0" ) )
	    { tar->tarShowTableGridInt= -1;	}
	if  ( ! strcmp( tar->tarShowTableGridString, "1" ) )
	    { tar->tarShowTableGridInt=  1;	}

	if  ( tar->tarShowTableGridInt == 0 )
	    { SDEB(tar->tarShowTableGridString);	}
	}

    /*  3  */
    if  ( tar->tarAutoHyphenateString		&&
	  tar->tarAutoHyphenateInt == 0		)
	{
	if  ( ! strcmp( tar->tarAutoHyphenateString, "0" ) )
	    { tar->tarAutoHyphenateInt= -1;	}
	if  ( ! strcmp( tar->tarAutoHyphenateString, "1" ) )
	    { tar->tarAutoHyphenateInt=  1;	}

	if  ( tar->tarAutoHyphenateInt == 0 )
	    { SDEB(tar->tarAutoHyphenateString);	}
	}

    /*  3  */
    if  ( tar->tarShadingMeshTwipsString	&&
	  tar->tarShadingMeshPointsDouble <= 0	)
	{
	long meshTwips= strtol( tar->tarShadingMeshTwipsString, &past, 10 );

	if  ( meshTwips <= 0 || meshTwips > 400 )
	    { SFDEB(tar->tarShadingMeshTwipsString,meshTwips); }

	tar->tarShadingMeshPointsDouble= meshTwips/ 20.0;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Handle a replace from one of the tools.				*/
/*									*/
/************************************************************************/

void tedAppReplace(	void *		voidea,
			const char *	word )
    {
    EditApplication *	ea= (EditApplication *)voidea;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;

    if  ( tedHasSelection( td )		&&
	  ! tedHasIBarSelection( td )	&&
	  td->tdCanReplaceSelection	)
	{ tedDocReplaceSelection( ed, word, strlen( word ) ); }

    return;
    }

/************************************************************************/
/*									*/
/*  Callback for the 'Insert File' menu option.				*/
/*									*/
/************************************************************************/

static int tedInsertFile(	EditApplication *	ea,
				void *			voided,
				APP_WIDGET		relative,
				APP_WIDGET		option,
				const char *		filename )
    {
    EditDocument *		ed= (EditDocument *)voided;

    int				format;
    BufferDocument *		bd;

    if  ( tedOpenDocumentFile( ea, &format, &bd, filename, relative, option ) )
	{ SDEB(filename); return -1;	}

    switch( format )
	{
	case 0:
	    if  ( tedIncludeRtfDocument( ed, bd ) )
		{ LDEB(1); docFreeDocument( bd ); return -1;	}
	    break;

	case 1:
	case 2:
	    if  ( tedIncludePlainDocument( ed, bd ) )
		{ LDEB(1); docFreeDocument( bd ); return -1;	}
	    break;

	default:
	    LDEB(format);
	    docFreeDocument( bd ); return -1;
	}
	    
    docFreeDocument( bd );

    appDocumentChanged( ed, 1 );

    return 0;
    }

APP_MENU_CALLBACK_H( tedDocInsertFile, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    appRunOpenChooser( option, ed->edToplevel.atTopWidget,
			    ea->eaFileExtensionCount, ea->eaFileExtensions,
			    ea->eaDefaultFileFilter,
			    tedInsertFile, ea, voided );

    return;
    }

/************************************************************************/
/*									*/
/*  'Select All' from the 'Edit' menu.					*/
/*									*/
/************************************************************************/

void tedDocSelAll(		EditDocument *	ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    DocumentSelection		dsNew;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    int				scrolledX= 0;
    int				scrolledY= 0;

    const int			lastLine= 0;

    if  ( tedGetSelection( &dsNew, &sg, &sd,
		    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ docInitDocumentSelection( &dsNew );	}

    if  ( docSelectWholeTree( &dsNew, bd ) )
	{ LDEB(1); return;	}

    tedSetSelection( ed, &dsNew, lastLine, &scrolledX, &scrolledY );
    tedAdaptToolsToSelection( ed );

    return;
    }

/************************************************************************/
/*									*/
/*  Callback from 'Frame' tool.						*/
/*									*/
/************************************************************************/

int tedDocSelectCurrentFrame(	EditDocument *	ed )
    {
    TedDocument *		td;
    BufferDocument *		bd;

    DocumentSelection		dsNew;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    int				scrolledX= 0;
    int				scrolledY= 0;

    const int			lastLine= 0;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;

    if  ( tedGetSelection( &dsNew, &sg, &sd,
		    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{ docInitDocumentSelection( &dsNew );	}

    if  ( docSelectFrameOfPosition( &dsNew, &(dsNew.dsHead) ) )
	{ LDEB(1); return -1;	}

    tedSetSelection( ed, &dsNew, lastLine, &scrolledX, &scrolledY );

    tedAdaptToolsToSelection( ed );

    return 0;
    }

int tedAppSelectCurrentFrame(	EditApplication *	ea )
    {
    EditDocument *		ed= ea->eaCurrentDocument;
    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocSelectCurrentFrame( ed );
    }

int tedAppDeleteCurrentFrame(	EditApplication *	ea )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocDeleteCurrentFrame( ed );
    }

int tedAppDeleteSelectedParagraphs(	EditApplication *	ea )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocDeleteSelectedParagraphs( ed );
    }

void tedAppSetTocField(		EditApplication *	ea,
				const TocField *	tf )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed);	}

    tedDocSetTocField( ed, tf );
    }

void tedAppAddTocField(		EditApplication *	ea,
				const TocField *	tf )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed);	}

    tedDocAddTocField( ed, tf );
    }

void tedAppDeleteTocField(	EditApplication *	ea )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedDocDeleteTocField( ed );
    }

int tedAppSetHyperlink(	EditApplication *	ea,
			const char *		file,
			const char *		mark )
    {
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocSetHyperlink( ed, file, mark );
    }

int tedAppRemoveHyperlink(	EditApplication *	ea )
    {
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocRemoveHyperlink( ed );
    }

int tedAppGetBookmarkField(	DocumentField **		pDf,
				EditApplication *		ea,
				const char *			markName,
				int				markSize )
    {
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocGetBookmarkField( pDf, ed, markName, markSize );
    }

int tedAppSetBookmark(	EditApplication *	ea,
			const char *		mark )
    {
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocSetBookmark( ed, mark );
    }

int tedAppRemoveBookmark(	EditApplication *	ea )
    {
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocRemoveBookmark( ed );
    }

int tedAppGoToBookmark(	EditApplication *	ea,
			const char *		markName,
			int			markSize )
    {
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    return tedDocGoToBookmark( ed, markName, markSize );
    }

void tedAppSetParaOutlineLevel(	EditApplication *	ea,
				int			level )
    {
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedDocSetParaOutlineLevel( ed, level );

    return;
    }

/************************************************************************/
/*									*/
/*  Run the 'Link Dialog' from the 'Insert Link' menu option.		*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocInsertLink, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    EditApplication *		ea= ed->edApplication;

    tedShowFormatTool( td->tdToolsFormatToolOption, ea );

    tedAdaptFormatToolToDocument( ed, 0 );

    tedFormatShowLinkPage( ea );

    return;
    }

APP_MENU_CALLBACK_H( tedDocInsertFootnote, option, voided, e )
    {
    tedDocInsertNote( (EditDocument *)voided, DOCinFOOTNOTE, DOCinFTNSEP );
    }

APP_MENU_CALLBACK_H( tedDocInsertEndnote, option, voided, e )
    {
    tedDocInsertNote( (EditDocument *)voided, DOCinENDNOTE, DOCinAFTNSEP );
    }

/************************************************************************/
/*									*/
/*  Run the 'Bookmark Dialog' from the 'Insert Bookmark' menu option.	*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocInsertBookmark, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    EditApplication *		ea= ed->edApplication;

    tedShowFormatTool( td->tdToolsFormatToolOption, ea );

    tedAdaptFormatToolToDocument( ed, 0 );

    tedFormatShowBookmarkPage( ea );
    }

APP_MENU_CALLBACK_H( tedDocTableSelectTable, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    TableRectangle		tr;

    if  ( tedGetSelection( &ds, &sg, &sd,
		    (DocumentTree **)0, (const BufferItem **)0, td  ) )
	{ LDEB(1); return;	}

    if  ( docGetTableRectangle( &tr, &ds ) )
	{ LDEB(1); return;	}

    docExpandTableRectangleToWholeTable( &tr );

    tedDocTableSelectTableRectangle( ed, &tr );

    return;
    }

APP_MENU_CALLBACK_H( tedDocTableSelectRow, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    TableRectangle	tr;

    if  ( tedGetSelection( &ds, &sg, &sd,
		    (DocumentTree **)0, (const BufferItem **)0, td  ) )
	{ LDEB(1); return;	}

    if  ( docGetTableRectangle( &tr, &ds ) )
	{ LDEB(1); return;	}

    docExpandTableRectangleToWholeRows( &tr );

    tedDocTableSelectTableRectangle( ed, &tr );

    return;
    }

APP_MENU_CALLBACK_H( tedDocTableSelectColumn, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    TableRectangle		tr;

    if  ( tedGetSelection( &ds, &sg, &sd,
		    (DocumentTree **)0, (const BufferItem **)0, td  ) )
	{ LDEB(1); return;	}

    if  ( docGetTableRectangle( &tr, &ds ) )
	{ LDEB(1); return;	}

    docExpandTableRectangleToWholeColumns( &tr );

    tedDocTableSelectTableRectangle( ed, &tr );

    return;
    }

/************************************************************************/
/*									*/
/*  Callback for the 'DrawTableGrid' toggle.				*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocTableDrawGrid, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    int				set;

    set= appGuiGetMenuToggleStateFromCallback( option, e );

    if  ( set )
	{ td->tdDrawTableGrid=  1;	}
    else{ td->tdDrawTableGrid= -1;	}

    appDocExposeRectangle( ed, (const DocumentRectangle *)0, 0,0 );

    return;
    }

APP_MENU_CALLBACK_H( tedDocTableDeleteTable, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    TableRectangle		tr;

    if  ( tedGetSelection( &ds, &sg, &sd,
		    (DocumentTree **)0, (const BufferItem **)0, td  ) )
	{ LDEB(1); return;	}

    if  ( docGetTableRectangle( &tr, &ds ) )
	{ LDEB(1); return;	}

    if  ( tedDeleteRowsFromTable( ed, tr.trRow00, tr.trRow11 ) )
	{ LLDEB(tr.trRow00,tr.trRow11); return;	}

    return;
    }

APP_MENU_CALLBACK_H( tedDocTableDeleteRow, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    TableRectangle		tr;

    if  ( tedGetSelection( &ds, &sg, &sd,
		    (DocumentTree **)0, (const BufferItem **)0, td  ) )
	{ LDEB(1); return;	}

    if  ( docGetTableRectangle( &tr, &ds ) )
	{ LDEB(1); return;	}

    if  ( tedDeleteRowsFromTable( ed, tr.trRow0, tr.trRow1 ) )
	{ LLDEB(tr.trRow00,tr.trRow11); return;	}

    return;
    }

APP_MENU_CALLBACK_H( tedDocTableDeleteColumn, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    TableRectangle		tr;

    if  ( tedGetSelection( &ds, &sg, &sd,
		    (DocumentTree **)0, (const BufferItem **)0, td  ) )
	{ LDEB(1); return;	}

    if  ( docGetTableRectangle( &tr, &ds ) )
	{ LDEB(1); return;	}

    if  ( tedDeleteColumnsFromRows( ed,
		tr.trRow00, tr.trRow11, tr.trCol0, tr.trCol1 ) )
	{ LLDEB(tr.trRow00,tr.trRow11); return;	}

    return;
    }

/************************************************************************/
/*									*/
/*  Insert a line/page/column break in the document.			*/
/*  Insert a note separator.						*/
/*									*/
/*  Note that page breaks and column breaks at the head of a paragraph	*/
/*  are modified into a paragraph property by the editing code.		*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocInsertLineBreak, option, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    const int		redoLayout= 1;

    tedEditInsertSpecialParticule( ed, DOCkindLINEBREAK, redoLayout );

    return;
    }

APP_MENU_CALLBACK_H( tedDocInsertPageBreak, option, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    const int		redoLayout= 1;

    tedEditInsertSpecialParticule( ed, DOCkindPAGEBREAK, redoLayout );

    return;
    }

APP_MENU_CALLBACK_H( tedDocInsertColumnBreak, option, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    const int		redoLayout= 1;

    tedEditInsertSpecialParticule( ed, DOCkindCOLUMNBREAK, redoLayout );

    return;
    }

APP_MENU_CALLBACK_H( tedDocInsertChftnsep, option, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    const int		redoLayout= 0;

    tedEditInsertSpecialParticule( ed, DOCkindCHFTNSEP, redoLayout );

    return;
    }

/************************************************************************/
/*									*/
/*  Menu options to change paragraph alignment.				*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocFormatAlignLeft, w, voided, e )
    { tedFormatSetParaIndent( (EditDocument *)voided, DOCiaLEFT ); }

APP_MENU_CALLBACK_H( tedDocFormatAlignRight, w, voided, e )
    { tedFormatSetParaIndent( (EditDocument *)voided, DOCiaRIGHT ); }

APP_MENU_CALLBACK_H( tedDocFormatAlignCenter, w, voided, e )
    { tedFormatSetParaIndent( (EditDocument *)voided, DOCiaCENTERED ); }

APP_MENU_CALLBACK_H( tedDocFormatAlignJustify, w, voided, e )
    { tedFormatSetParaIndent( (EditDocument *)voided, DOCiaJUSTIFIED ); }

/************************************************************************/
/*									*/
/*  Increase/Decrease the indentation level of the paragraphs in the	*/
/*  selection.								*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocFormatIncreaseIndent, w, voided, e )
    { tedFormatShiftIndent( (EditDocument *)voided,  1 ); }

APP_MENU_CALLBACK_H( tedDocFormatDecreaseIndent, w, voided, e )
    { tedFormatShiftIndent( (EditDocument *)voided, -1 ); }

/************************************************************************/
/*									*/
/*  Replace the current selection with a page number field.		*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocInsertPageNumber, option, voided, e )
    { tedInsertPageNumber( (EditDocument *)voided );	}

/************************************************************************/
/*									*/
/*  Open a document.							*/
/*									*/
/*  1)  Read the file.							*/
/*  1b) Forget the name of document templates to force a save-as.	*/
/*	Also forget it is a template, to make sure that it is saved as	*/
/*	an ordinary document.						*/
/*  2)  Get the list of fonts that are available on the machine.	*/
/*  3)  Add them to the font list of the document.			*/
/*									*/
/************************************************************************/

int tedOpenDocument(	EditApplication *	ea,
			void *			voidtd,
			int *			pFormat,
			APP_WIDGET		relative,
			APP_WIDGET		option,
			const char *		filename )
    {
    TedDocument *		td= (TedDocument *)voidtd;
    BufferDocument *		bd= td->tdDocument;
    DocumentProperties *	dp= &(bd->bdProperties);

    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;

    /*  1,2  */
    if  ( tedOpenDocumentFile( ea, pFormat, &(td->tdDocument),
					    filename, relative, option ) )
	{ /*SDEB(filename);*/ return -1;	}

    bd= td->tdDocument;
    dp= &(bd->bdProperties);

    /*  3  */
    if  ( ! ea->eaAvoidFontconfig && ea->eaPreferBase35Fonts )
	{
	if  ( utilAddBase35FontsToDocList( &(dp->dpFontList) ) )
	    { LDEB(35); return -1; }
	}
    else{
	if  ( utilAddPsFontsToDocList( &(dp->dpFontList), 
					&(ea->eaPostScriptFontList) ) )
	    { LDEB(ea->eaPostScriptFontList.psflFamilyCount); return -1; }
	}

    bd->bdAutoHyphenate= tar->tarAutoHyphenateInt > 0;
    return 0;
    }

APP_MENU_CALLBACK_H( tedDocFilePrint, printOption, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;
    BufferDocument *	bd= td->tdDocument;

    int			pageCount= bd->bdBody.eiRoot->biBelowPosition.lpPage+ 1;
    int			firstPage= -1;
    int			lastPage= -1;

    DocumentSelection		ds;
    SelectionGeometry		sg;
    SelectionDescription	sd;

    const DocumentGeometry *	dgDoc= &(bd->bdProperties.dpGeometry);

    if  ( ! tedGetSelection( &ds, &sg, &sd,
		    (DocumentTree **)0, (const BufferItem **)0, td ) )
	{
	firstPage= sg.sgBegin.pgTopPosition.lpPage;
	lastPage= sg.sgEnd.pgTopPosition.lpPage;
	}

    appRunPrintDialog( ed, dgDoc, pageCount, firstPage, lastPage,
					printOption, "print" );

    tedRedoDocumentLayout( ed );
    }

/************************************************************************/
/*									*/
/*  Table related menu option callbacks.				*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocTableInsertTable, option, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;

    int			rows= 2;
    int			columns= 2;

    if  ( tedInsertTable( ed, rows, columns ) )
	{ LLDEB(rows,columns);	}

    appDocumentChanged( ed, 1 );

    return;
    }

APP_MENU_CALLBACK_H( tedDocTableAddRow, option, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;

    tedAppendRowToTable( ed );

    appDocumentChanged( ed, 1 );

    return;
    }

APP_MENU_CALLBACK_H( tedDocTableAddColumn, option, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;

    if  ( tedAppendColumnToTable( ed ) )
	{ LDEB(1);	}

    appDocumentChanged( ed, 1 );
    }

APP_MENU_CALLBACK_H( tedDocFormatTool, option, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    EditApplication *	ea= ed->edApplication;

    /* option == td->tdToolsFormatToolOption */

    tedShowFormatTool( option, ea );
    tedAdaptFormatToolToDocument( ed, 0 );
    }

APP_MENU_CALLBACK_H( tedDocShowPageTool, pageOption, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    EditApplication *	ea= ed->edApplication;

    {
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    /*  To get the correct title  */
    tedShowFormatTool( td->tdToolsFormatToolOption, ea );
    tedAdaptFormatToolToDocument( ed, 0 );

    tedFormatShowPagePage( ea );
    }

    return;
    }

/************************************************************************/
/*									*/
/*  Font Menu.								*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocFontPaste, option, voided, e )
    {
    EditDocument *			ed= (EditDocument *)voided;

    appDocAskForPaste( ed, "RTFFONT" );
    }

APP_MENU_CALLBACK_H( tedDocToolFont, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    /*  To get the correct title  */
    tedShowFormatTool( td->tdToolsFormatToolOption, ea );
    tedAdaptFormatToolToDocument( ed, 0 );

    tedFormatShowFontPage( ea );

    return;
    }

APP_MENU_CALLBACK_H( tedDocToolInsertSymbol, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    /*  To get the correct title  */
    tedShowFormatTool( td->tdToolsFormatToolOption, ea );
    tedAdaptFormatToolToDocument( ed, 0 );

    tedFormatShowSymbolPage( ea );

    return;
    }

/************************************************************************/
/*									*/
/*  Run document properties dialog.					*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocFileProps, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    DocumentStatistics		ds;

    docCollectDocumentStatistics( &ds, bd );

    tedRunPropertyDialog( ed, &ds, option, "props" );
    }

/************************************************************************/
/*									*/
/*  Mail a document.							*/
/*									*/
/************************************************************************/

APP_MENU_CALLBACK_H( tedDocInsertPicture, option, voided, e )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    static AppFileExtension *	openExtensions;
    static int			openExtensionCount;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    if  ( openExtensionCount == 0 )
	{
	AppFileExtension *	afe;

	if  ( appImgMakeFileExtensions( &openExtensions,
					&openExtensionCount ) )
	    { LDEB(1); return;	}

	afe= (AppFileExtension *) realloc( openExtensions,
			(openExtensionCount+ 1)* sizeof(AppFileExtension) );
	if  ( ! afe )
	    { LXDEB(openExtensionCount,afe); return; }
	openExtensions= afe;

	afe += openExtensionCount;

	afe->afeId= "wmfFile";
	afe->afeFilter= "*.wmf";
	afe->afeDescription= "Windows Metafile ( *.wmf )";
	afe->afeExtension= "wmf";
	afe->afeUseFlags= APPFILE_CAN_OPEN;

	openExtensionCount++;
	}

    appRunOpenChooser( option, ed->edToplevel.atTopWidget,
			openExtensionCount, openExtensions, (char *)0,
			tedObjectOpenPicture, ea, (void *)ed );

    return;
    }

