/************************************************************************/
/*									*/
/*  Layout of a section.						*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	<appImage.h>
#   include	"docPageGrid.h"
#   include	"docLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Adjust the position of the top of a section, depending on the kind	*/
/*  of break								*/
/*									*/
/*  1)  Note that even and odd are swapped as from the users point of	*/
/*	view page numbers count from one.				*/
/*  2)  As this routine is only called for the body of the document,	*/
/*	page wraps can be performed unconditionally.			*/
/*									*/
/************************************************************************/

void docLayoutPlaceSectTop(		BufferItem *		sectBi,
					LayoutPosition *	lpHere,
					BlockFrame *		bf,
					LayoutJob *		lj )
    {
    if  ( sectBi->biNumberInParent == 0 )
	{
	lpHere->lpPage= 0;
	lpHere->lpColumn= 0;
	lpHere->lpAtTopOfColumn= 1;

	if  ( lj->ljBodySectBi != sectBi )
	    { XXDEB(lj->ljBodySectBi,sectBi);	}

	docLayoutColumnTop( lpHere, bf, sectBi, lj );
	}
    else{
	if  ( ! DOC_SECTitemBELOW_PREVIOUS( sectBi ) )
	    {
	    const int		belowText= 0;
	    LayoutPosition	lpBelowNotes;

	    if  ( BF_HAS_FOOTNOTES( bf )				&&
		  ( sectBi->biInExternalItem == DOCinBODY	||
		    sectBi->biInExternalItem == DOCinENDNOTE	)	&&
		  docLayoutFootnotesForColumn( &lpBelowNotes, lpHere, bf,
						      belowText, lj )	)
		{ LDEB(1); return;	}

	    docLayoutToNextColumn( lpHere, bf, sectBi, lj );
	    }
	}

    switch( sectBi->biSectBreakKind )
	{
	case DOCibkNONE:
	    if  ( ! DOC_SECTitemBELOW_PREVIOUS( sectBi ) )
		{ goto pageCase;	}

	    lpHere->lpColumn= 0;

	    docLayoutBlockFrame( bf, sectBi, lj,
					lpHere->lpPage, lpHere->lpColumn );
	    break;
	case DOCibkCOL:
	    break;

	case DOCibkPAGE:
	  pageCase:
	    while( lpHere->lpColumn > 0 )
		{
		docLayoutToNextColumn( lpHere, bf, sectBi, lj );
		}
	    break;

	case DOCibkEVEN:	/*  1  */
	    while( lpHere->lpColumn > 0 )
		{
		docLayoutToNextColumn( lpHere, bf, sectBi, lj );
		}
	    while( ! ( lpHere->lpPage % 2 ) )
		{
		docLayoutToNextColumn( lpHere, bf, sectBi, lj );
		}
	    break;

	case DOCibkODD:	/*  1  */
	    while( lpHere->lpColumn > 0 )
		{
		docLayoutToNextColumn( lpHere, bf, sectBi, lj );
		}
	    while( lpHere->lpPage % 2 )
		{
		docLayoutToNextColumn( lpHere, bf, sectBi, lj );
		}
	    break;

	default:
	    LDEB(sectBi->biSectBreakKind);
	    break;
	}

    sectBi->biTopPosition= *lpHere;

    if  ( sectBi->biNumberInParent == 0		&&
	  sectBi->biParent			)
	{ sectBi->biParent->biTopPosition= *lpHere; }

    return;
    }

/************************************************************************/
/*									*/
/*  Do the layout of the children of a section.				*/
/*									*/
/*  2)  See whether and where to restart if a row does not fit in the	*/
/*	column.								*/
/*  3)  Between tables.							*/
/*  4)  Tables.								*/
/*  5)  Finally do the layout of the end notes belonging to this	*/
/*	section. Though strictly spoken notes are not children, they	*/
/*	appear at the end of the section and they are part of the	*/
/*	balancing if multi column sections.				*/
/*									*/
/************************************************************************/

static int docLayoutTableSlice(	LayoutPosition *	lpBelow,
				const LayoutPosition *	lpTop,
				BufferItem *		sectBi,
				int			from,
				int			upto,
				BlockFrame *		bf,
				LayoutJob *		lj )
    {
    int			i= from;
    int			restartFrom= from;

    LayoutPosition	lpHere= *lpTop;
    LayoutPosition	lpRestartFrom= *lpTop;

    int			stayInThisColumn= 0;
    int			attempt= 0;

    while( i < upto )
	{
	int		found= FORMATstopREADY;
	BufferItem *	rowBi= sectBi->biChildren[i];

	LayoutPosition	lpRowTop= lpHere;

	docLayoutStartItemLayout( rowBi, lj, &lpHere );

	if  ( docLayoutRowItem( &found, &lpHere, &lpHere,
			rowBi, bf, stayInThisColumn && attempt == 0, lj ) )
	    { LDEB(i); return -1;	}

	if  ( found == FORMATstopFRAME_FULL )
	    {
	    if  ( ! stayInThisColumn )
		{ LLDEB(found,stayInThisColumn);	}
	    else{
		attempt++;

		lpHere= lpRestartFrom;
		docLayoutToNextColumn( &lpHere, bf, sectBi, lj );

		i= restartFrom;
		continue;
		}
	    }

	docLayoutFinishItemLayout( rowBi, lj, &lpHere );

	if  ( attempt == 0						&&
	      ( rowBi->biRowIsTableHeader || rowBi->biRow_Keepfollow )	)
	    {
	    if  ( ! stayInThisColumn )
		{
		lpRestartFrom= lpRowTop;
		stayInThisColumn= 1; restartFrom= i;
		}
	    }
	else{ stayInThisColumn= 0; restartFrom= i+ 1;	}

	i++;
	}

    *lpBelow= lpHere;
    return 0;
    }

int docLayoutSectChildren(	LayoutPosition *	lpBelow,
				const LayoutPosition *	lpTop,
				BufferItem *		sectBi,
				int			from,
				BlockFrame *		bf,
				LayoutJob *		lj )
    {
    const LayoutContext *	lc= &(lj->ljContext);
    int				i;

    int				stayInThisColumn= 0;
    int				restartFrom= from+ 1;

    LayoutPosition		lpRestartFrom= *lpTop;
    LayoutPosition		lpHere= *lpTop;

    /*  2  */
    i= from;
    while( i > 0 )
	{
	BufferItem *	childBi= sectBi->biChildren[--i];

	if  ( ! docIsRowItem( childBi ) )
	    { break;	}
	if  ( ! childBi->biRow_Keepfollow )
	    { break;	}

	lpRestartFrom= childBi->biTopPosition;
	stayInThisColumn= 1; restartFrom= i;
	}

    i= from;
    while( i < sectBi->biChildCount )
	{
	/*  3  */
	while( i < sectBi->biChildCount )
	    {
	    BufferItem *	childBi= sectBi->biChildren[i];

	    if  ( docIsRowItem( childBi ) )
		{ break;	}

	    if  ( docLayoutItemImplementation( &lpHere, &lpHere,
							childBi, bf, lj ) )
		{ LDEB(i); return -1;	}

	    i++;
	    stayInThisColumn= 0; restartFrom= i+ 1;
	    }

	/*  4  */
	if  ( i < sectBi->biChildCount )
	    {
	    int			upto= i+ 1;

	    while( upto < sectBi->biChildCount )
		{
		BufferItem *	childBi= sectBi->biChildren[upto];

		if  ( ! docIsRowItem( childBi ) )
		    { break;	}

		upto++;
		}

	    if  ( docLayoutTableSlice( &lpHere, &lpHere,
						sectBi, i, upto, bf, lj ) )
		{ LLDEB(i,upto); return -1;	}

	    i= upto;
	    }
	}

    /*  5  */
    {
    const DocumentProperties *	dp= &(lc->lcDocument->bdProperties);
    const NotesProperties *	npEndnotes= &(dp->dpEndnoteProperties);

    if  ( sectBi->biInExternalItem == DOCinBODY		&&
	  npEndnotes->npPosition == FTN_POS_SECT_END	)
	{
	if  ( docLayoutEndnotesForSection( &lpHere, &lpHere,
					sectBi->biNumberInParent, bf, lj ) )
	    { LDEB(sectBi->biNumberInParent); return -1;	}
	}
    }

    *lpBelow= lpHere;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Balance the columns on the last page of a multi-column section.	*/
/*									*/
/*  The approach:							*/
/*  -------------							*/
/*									*/
/*  A)  Calculate the total surface of that the text of the section	*/
/*	covers on the last page of the section.				*/
/*  B)  Calculate the height that the section would have if it were	*/
/*	perfectly balanced. Realize that various formatting properties	*/
/*	of the text might make a perfect balance impossible.		*/
/*  C)  Use the value calculated in (B) as a first guess and use an	*/
/*	iterative algorithm to find the minimal height of the page	*/
/*	strip occupied by this section. The fact that the value from	*/
/*	(B) is irrealistic helps: We can use binary search to find the	*/
/*	correct value.							*/
/*									*/
/*  1)  MS-Word 2003 does not try to balance the columns of a section	*/
/*	that starts after the first column on its last page.		*/
/*									*/
/************************************************************************/

static int docBalanceSectionColumns(	LayoutPosition *	lpBelow,
					BlockFrame *		bf,
					BufferItem *		sectBi,
					const LayoutJob *	refLj )
    {
    const LayoutContext *	lc= &(refLj->ljContext);
    BufferDocument *		bd= lc->lcDocument;
    int				l, m, r;

    int				fromSectTop;
    int				pageY0;
    int				col0;
    int				from;

    int				col;

    BufferItem *		childBi;

    BlockFrame			bfFrom;
    LayoutPosition		lpFrom;
    DocumentPosition		dpFrom;

    LayoutPosition		lpHere;
    LayoutJob			balanceLj;

    const int			partFrom= 0;
    const int			columnFrom= 0;

    if  ( sectBi->biTopPosition.lpPage < lpBelow->lpPage )
	{
	col0= 0;
	fromSectTop= 0;
	}
    else{
	if  ( sectBi->biTopPosition.lpPage > lpBelow->lpPage )
	    { LLDEB(sectBi->biTopPosition.lpPage,lpBelow->lpPage);	}

	col0= sectBi->biTopPosition.lpColumn;
	fromSectTop= 1;
	}

    /*  1  */
    if  ( col0 > 0 )
	{ return 0;	}

    {
    BlockFrame			bfCol;

    col= lpBelow->lpColumn;
    docLayoutInitBlockFrame( &bfCol );
    docBlockFrameTwips( &bfCol, sectBi, sectBi, bd, lpBelow->lpPage, col );

    if  ( fromSectTop )
	{ pageY0= sectBi->biTopPosition.lpPageYTwips;	}
    else{ pageY0= bfCol.bfContentRect.drY0;		}
    }

    childBi= (BufferItem *)0;
    for ( from= 0; from < sectBi->biChildCount; from++ )
	{
	childBi= sectBi->biChildren[from];

	if  ( childBi->biBelowPosition.lpPage >= lpBelow->lpPage )
	    { break;	}
	}
    if  ( from >= sectBi->biChildCount )
	{ LLDEB(sectBi->biChildCount,lpBelow->lpPage); return -1; }

    lpFrom= childBi->biTopPosition;
    balanceLj= *refLj;
    balanceLj.ljBodySectBi= sectBi;
    balanceLj.ljBalancePage= lpBelow->lpPage;

    l= 240;
    r= bf->bfPageGeometry.dgPageHighTwips- pageY0-
				    bf->bfPageGeometry.dgBottomMarginTwips;
    m= ( l+ r )/ 2;

    bfFrom= *bf;

    if  ( docFirstPosition( &dpFrom, childBi ) )
	{ LDEB(1); return -1;	}

    docLayoutInitBlockFrame( &bfFrom );

    balanceLj.ljBalanceY1= pageY0+ m;
    docLayoutBlockFrame( &bfFrom, sectBi, &balanceLj,
					lpFrom.lpPage, lpFrom.lpColumn );

    if  ( docCollectFootnotesFromColumn( &bfFrom, &dpFrom, partFrom, bd,
						lpFrom.lpPage, columnFrom ) )
	{ LLDEB(lpFrom.lpPage,columnFrom); return -1;	}

    for (;;)
	{
	balanceLj.ljBalanceY1= pageY0+ m;
	lpHere= lpFrom;
	*bf= bfFrom;
	docLayoutBlockFrame( bf, sectBi, &balanceLj,
					lpHere.lpPage, lpHere.lpColumn );
	if  ( docLayoutSectChildren( &lpHere, &lpHere, sectBi, from,
							bf, &balanceLj ) )
	    { LDEB(1); return -1;	}

	if  ( lpHere.lpPage > lpBelow->lpPage )
	    {
	    l= m+ 1;
	    m= ( l+ r )/ 2;
	    continue;
	    }
	else{
	    r= m; m= ( l+ r )/ 2;
	    if  ( l == m )
		{ break;	}
	    }
	}

    lpHere.lpPageYTwips= balanceLj.ljBalanceY1;

    *lpBelow= lpHere;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Last step in the layout of a section: Endnotes and balancing.	*/
/*									*/
/************************************************************************/

int docLayoutFinishSectItem(	LayoutPosition *		lpBelow,
				const LayoutPosition *		lpTop,
				BufferItem *			sectBi,
				BlockFrame *			bf,
				LayoutJob *			lj )
    {
    const SectionProperties *	sp= &(sectBi->biSectProperties);
    LayoutPosition		lpHere= *lpTop;

    if  ( sp->spColumnCount > 1						&&
	  sectBi->biParent						&&
	  sectBi->biNumberInParent < sectBi->biParent->biChildCount- 1	)
	{
	const BufferItem *	nextSectBi;

	nextSectBi= sectBi->biParent->biChildren[sectBi->biNumberInParent+ 1];

	if  ( DOC_SECTitemBELOW_PREVIOUS( nextSectBi ) )
	    {
	    if  ( docBalanceSectionColumns( &lpHere, bf, sectBi, lj ) )
		{ LDEB(1); return -1;	}
	    }
	}

    *lpBelow= lpHere;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Do the layout of a section.						*/
/*									*/
/************************************************************************/

int docLayoutSectItem(	LayoutPosition *		lpBelow,
			const LayoutPosition *		lpTop,
			BufferItem *			sectBi,
			BlockFrame *			bf,
			LayoutJob *			lj )
    {
    LayoutPosition		lpHere= *lpTop;

    if  ( sectBi->biInExternalItem != DOCinBODY )
	{ SDEB(docExternalKindStr(sectBi->biInExternalItem));	}

    /**/
    docDelimitTables( sectBi );

    /**/

    if  ( docSectHeaderFooterPrelayout( sectBi, lj ) )
	{ LDEB(1); return -1;	}

    /**/
    if  ( docSectNotesPrelayout( sectBi->biNumberInParent, sectBi, lj ) )
	{ LDEB(sectBi->biNumberInParent); return -1;	}

    /**/

    if  ( sectBi->biInExternalItem == DOCinBODY )
	{ lj->ljBodySectBi= sectBi;	}

    docLayoutPlaceSectTop( sectBi, &lpHere, bf, lj );

    if  ( docLayoutSectChildren( &lpHere, &lpHere, sectBi, 0, bf, lj ) )
	{ LDEB(1); return -1;	}

    if  ( sectBi->biChildCount > 0 )
	{ sectBi->biTopPosition=  sectBi->biChildren[0]->biTopPosition; }

    /**/

    if  ( docLayoutFinishSectItem( &lpHere, &lpHere, sectBi, bf, lj ) )
	{ LDEB(1); return -1;	}

    *lpBelow= lpHere;
    return 0;
    }

