/************************************************************************/
/*									*/
/*  Layout of a table row in the document.				*/
/*  Setup rowspan related administration.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	"docLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Find the top of group of vertically merged cells.			*/
/*									*/
/*  1)  Look at the table rows above the cell in reverse order.		*/
/*  2)  Find a matching cell.						*/
/*									*/
/************************************************************************/

static void docLayoutTopOfRowspan(	ParagraphLayoutJob *	plj,
					BufferItem *		cellBi,
					const BufferItem *	rowBi,
					int			l,
					int			r )
    {
    int		topRow;

    /*  1  */
    for ( topRow= rowBi->biNumberInParent- 1;
	  topRow >= rowBi->biRowTableFirst;
	  topRow-- )
	{
	int			colspan;
	int			topCol;
	const BufferItem *	topRowBi;
	const CellProperties *	topCp;

	/*  2  */
	topRowBi= rowBi->biParent->biChildren[topRow];

	topCol= docGetMatchingCell( &colspan, topRowBi, l, r );
	if  ( topCol < 0 )
	    { LDEB(topCol); continue;	}

	topCp= topRowBi->biRowCells+ topCol;
	if  ( topCp->cpMergedWithAbove )
	    { continue;	}

	if  ( topCp->cpTopInMergedColumn )
	    {
	    const BufferItem *	topCellBi= topRowBi->biChildren[topCol];

	    cellBi->biCellMergedCellTopRow= topRow;
	    cellBi->biCellMergedCellTopCol= topCol;
	    plj->cljMergedCellBelowPosion= topCellBi->biBelowPosition;
	    break;
	    }

	LLDEB(topCp->cpMergedWithAbove,topCp->cpTopInMergedColumn);
	break;
	}

    if  ( cellBi->biCellMergedCellTopRow < 0 )
	{ LDEB(cellBi->biCellMergedCellTopRow);	}

    return;
    }

/************************************************************************/
/*									*/
/*  Calculate the layout of a row in the document.			*/
/*									*/
/*  3)  Columns with a colspan do not push the bottom of THIS row down.	*/
/*	Remember this.							*/
/*  4)  But in a cell with a rowspan, the top cell of the cell might	*/
/*	push the bottom down. Look for it.				*/
/*									*/
/************************************************************************/

void docRowLayoutRowspanAdmin(	BufferItem *			cellBi,
				const BufferItem *		rowBi,
				const BufferItem *		nextRowBi,
				int				nextRow,
				const CellProperties *		cp,
				int				l,
				int				r,
				ParagraphLayoutJob *		plj )

    {
    if  ( nextRow < rowBi->biRowTablePast )
	{
	int			nextColspan= 1;
	int			nextCol;

	nextCol= docGetMatchingCell( &nextColspan, nextRowBi, l, r );

	if  ( nextCol >= 0 )
	    {
	    const CellProperties *	nextCp;

	    nextCp= &(nextRowBi->biRowCells[nextCol]);

	    /*  3  */
	    if  ( cp->cpTopInMergedColumn	&&
		  nextCp->cpMergedWithAbove	)
		{ cellBi->biCellIsMergedWithBelow= 1; }

	    /*  4  */
	    if  ( cp->cpMergedWithAbove		&&
		  ! nextCp->cpMergedWithAbove	)
		{ docLayoutTopOfRowspan( plj, cellBi, rowBi, l, r );	}
	    }
	else{
	    if  ( cp->cpMergedWithAbove )
		{ docLayoutTopOfRowspan( plj, cellBi, rowBi, l, r );	}
	    }
	}
    else{
	/*  4  */
	if  ( cp->cpMergedWithAbove )
	    { docLayoutTopOfRowspan( plj, cellBi, rowBi, l, r );	}
	}
    }

