/************************************************************************/
/*									*/
/*  Layout of a document. Layout of a series of paragraphs in a common	*/
/*  parent.								*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	"docLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Layout as much of a paragraph as fits on the current page		*/
/*  page.								*/
/*									*/
/*  2)  When Widow/Orphan control is active and we could only place	*/
/*	one line on the page without finishing the paragraph. Force	*/
/*	the formatting of this paragraph to restart on the next page.	*/
/*  3)  When the paragraph is to be kept on one page, and it is not	*/
/*	possible to finish it on this page, Force the formatting of	*/
/*	paragraph to restart on the next page.				*/
/*  4)  When Widow/Orphan control is active and we finish the paragraph	*/
/*	by placing its last line on this page, skip back to the		*/
/*	penulimate line.						*/
/*  5)	NOTE the special case for 3 line paragraphs: The whole		*/
/*	paragraph is moved to the next page.				*/
/*									*/
/*  Return FORMATstopPAGE_FULL						*/
/*	Nothing done because the paragraph does not fit on the page	*/
/*  Return FORMATstopPARTIAL						*/
/*	Starting point rewound becase of widow/orphan control.		*/
/*  Return FORMATstopREADY						*/
/*	Paragraph successfully finished.				*/
/*  Return -1								*/
/*	Error.								*/
/*									*/
/************************************************************************/

int docLayoutParagraphInStrip(	int *				pStopCode,
				ParagraphLayoutPosition *	plp,
				BlockFrame *			bf,
				const LayoutJob *		lj,
				int				cellTopInset,
				BufferItem *			paraBi )
    {
    const LayoutContext *	lc= &(lj->ljContext);
    int				stopCode= FORMATstopREADY;
    int				accepted;
    int				prevLine;
    LayoutPosition		lpBefore= plp->plpPos;

    int				changed= 0;

    if  ( plp->pspPart == 0 )
	{
	int		toNextPage= 0;

	/*  1  */
	if  ( docLayoutStartParagraph( &toNextPage, lj, paraBi, bf, plp ) )
	    { LDEB(1); return -1;	}

	if  ( toNextPage )
	    { *pStopCode= FORMATstopPAGE_FULL; return FORMATstopPAGE_FULL; }

	paraBi->biTopPosition= plp->plpPos;

	if  ( plp->pspChild == 0 )
	    { plp->plpPos.lpPageYTwips += cellTopInset;	}
	}

    prevLine= plp->pspLine;

    accepted= docLayoutParaLines( &stopCode,
				    &(plp->plpParagraphFrame),
				    &(plp->plpPos), &(plp->pspLine),
				    bf, lj, paraBi, plp->pspPart );
    if  ( accepted < 0 )
	{ LDEB(accepted); return -1;	}

    /*  2  */
    if  ( paraBi->biParaWidowControl					&&
	  stopCode == FORMATstopPAGE_FULL				&&
	  ! lpBefore.lpAtTopOfColumn					&&
	  plp->pspLine == 1						&&
	  ! ( paraBi->biParaLines[0].tlFlags & TLflagPAGEBREAK )	)
	{
	docStripLayoutStartChild( plp, plp->pspChild );
	*pStopCode= stopCode; /* FORMATstopPAGE_FULL */
	return FORMATstopPAGE_FULL;
	}

    /*  3  */
    if  ( ( paraBi->biParaKeepOnPage	||
	    paraBi->biParaKeepWithNext	)				&&
	  ! lpBefore.lpAtTopOfColumn					&&
	  stopCode == FORMATstopPAGE_FULL				&&
	  paraBi->biParaLineCount >= plp->pspLine			&&
	  plp->pspLine > 0						&&
	  ! ( paraBi->biParaLines[plp->pspLine- 1].tlFlags &
						TLflagPAGEBREAK )	)
	{
	docStripLayoutStartChild( plp, plp->pspChild );
	*pStopCode= stopCode; /* FORMATstopPAGE_FULL */
	return FORMATstopPAGE_FULL;
	}

    plp->pspPart += accepted;
    if  ( accepted > 0 )
	{ plp->pspChildAdvanced= 1;	}

    if  ( stopCode != FORMATstopREADY				&&
	  ( accepted > 0 || ! lpBefore.lpAtTopOfColumn )	)
	{ *pStopCode= stopCode; return FORMATstopPAGE_FULL;	}

    /*  4  */
    if  ( paraBi->biParaWidowControl				&&
	  plp->pspLine > 1					&&
	  plp->pspLine- prevLine == 1				)
	{
	TextLine *		tl= paraBi->biParaLines+ prevLine- 1;

	if  ( ! ( tl[0].tlFlags & TLflagPAGEBREAK )			&&
	      ! tl[0].tlTopPosition.lpAtTopOfColumn			&&
	      tl[0].tlTopPosition.lpPage < tl[1].tlTopPosition.lpPage	)
	    {
	    /*  5  */
	    if  ( paraBi->biParaLineCount == 3 )
		{
		BufferItem *	bi= paraBi;

		docStripLayoutStartChild( plp, plp->pspChild );
		plp->plpPos= tl[1].tlTopPosition;

		while( bi->biNumberInParent > 0 )
		    {
		    bi= bi->biParent->biChildren[bi->biNumberInParent-1];
		    if  ( ! bi->biParaKeepWithNext )
			{ *pStopCode= FORMATstopPAGE_FULL; break; }

		    plp->pspChild--;
		    }
		}
	    else{
		plp->pspLine= prevLine- 1;
		plp->pspPart= tl->tlFirstParticule;
		plp->plpPos= tl[1].tlTopPosition;

		plp->pspChildAdvanced= ( plp->pspPart > 0 );
		}

	    return FORMATstopPARTIAL;
	    }
	}

    docLayoutSetItemBottom( &changed, paraBi, &(plp->plpPos),
				    lc, lj->ljChangedRectanglePixels );

    docStripLayoutNextChild( plp );
    return FORMATstopREADY;
    }

