/************************************************************************/
/*									*/
/*  Layout of a document.						*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<limits.h>

#   include	<docBuf.h>
#   include	"docLayout.h"
#   include	"docPageGrid.h"

#   include	<appDebugon.h>

void docLayoutBlockFrame(	BlockFrame *			bf,
				BufferItem *			bi,
				const LayoutJob *		lj,
				int				page,
				int				column )
    {
    const LayoutContext *	lc= &(lj->ljContext);
    const BufferDocument *	bd= lc->lcDocument;

    docBlockFrameTwips( bf, bi, lj->ljBodySectBi, bd, page, column );

    if  ( page == lj->ljBalancePage )
	{
	bf->bfContentRect.drY1= lj->ljBalanceY1;
	bf->bfFlowRect.drY1= lj->ljBalanceY1;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Continue to lay out the text on a subsequent page.			*/
/*									*/
/*  1)  Continuous section wrap to the same position as where they	*/
/*	started on the page.						*/
/*									*/
/************************************************************************/

void docLayoutColumnTop(	LayoutPosition *	lpTop,
				BlockFrame *		bf,
				BufferItem *		bodySectBi,
				const LayoutJob *	lj )
    {
    if  ( bodySectBi->biInExternalItem != DOCinBODY )
	{ SDEB(docExternalKindStr(bodySectBi->biInExternalItem));	}

    if  ( lj->ljBodySectBi != bodySectBi )
	{ XXDEB(lj->ljBodySectBi,bodySectBi);	}

    docLayoutBlockFrame( bf, bodySectBi, lj, lpTop->lpPage, lpTop->lpColumn );

    lpTop->lpPageYTwips= bf->bfContentRect.drY0;
    lpTop->lpAtTopOfColumn= 1;

    /*  1  */
    if  ( DOC_SECTitemBELOW_PREVIOUS( bodySectBi )		&&
	  lpTop->lpPage == bodySectBi->biTopPosition.lpPage	&&
	  bodySectBi->biSectColumnCount > 1			&&
	  lpTop->lpColumn > 0					)
	{
	lpTop->lpPageYTwips= bodySectBi->biTopPosition.lpPageYTwips;
	lpTop->lpAtTopOfColumn= 0;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Skip to the next column. Without newspaper style columns, that is	*/
/*  the next page.							*/
/*									*/
/************************************************************************/

void docLayoutToNextColumn(	LayoutPosition *	lpTop,
				BlockFrame *		bf,
				BufferItem *		bi,
				const LayoutJob *	lj )
    {
    const LayoutContext *	lc= &(lj->ljContext);
    const BufferDocument *	bd= lc->lcDocument;
    BufferItem *		bodyBi= bd->bdBody.eiRoot;
    BufferItem *		bodySectBi;

    bi= docGetSectItem( bi );
    if  ( ! bi )
	{ XDEB(bi); return;	}

    switch( bi->biInExternalItem )
	{
	SelectionScope *	ss;
	int			extTo;

	case DOCinBODY:
	    bodySectBi= bi;
	    break;

	case DOCinAFTNSEP:
	    extTo= bodyBi->biChildCount- 1;
	    bodySectBi= bodyBi->biChildren[extTo];
	    break;

	default:
	    ss= &(bi->biSectSelectionScope);
	    extTo= ss->ssOwnerSectNr;
	    if  ( extTo < 0 )
		{
		SLDEB(docExternalKindStr(bi->biInExternalItem),extTo);
		return;
		}
	    bodySectBi= bodyBi->biChildren[extTo];
	    break;
	}

    lpTop->lpColumn++;
    if  ( lpTop->lpColumn >= bodySectBi->biSectColumnCount )
	{ lpTop->lpPage++; lpTop->lpColumn= 0; }

    if  ( lj->ljBodySectBi != bodySectBi )
	{
	XXDEB(lj->ljBodySectBi,bodySectBi);
	SDEB(docExternalKindStr(bi->biInExternalItem));
	}

    docLayoutColumnTop( lpTop, bf, bodySectBi, lj );

    return;
    }

/************************************************************************/
/*									*/
/*  Adjust geometry to position paragraphs in a text frame.		*/
/*									*/
/************************************************************************/

void docLayoutFinishFrame(	const FrameProperties *		fp,
				BlockFrame *			bfTextFrame,
				const BlockFrame *		bfFlow,
				const LayoutJob *		lj,
				const ParagraphLayoutPosition *	plpFlow,
				BufferItem *			cellBi,
				int				paraFrom,
				int				paraUpto )
    {
    BufferItem *		paraBi0= cellBi->biChildren[paraFrom];
    BufferItem *		paraBi1= cellBi->biChildren[paraUpto- 1];

    int				y0= bfTextFrame->bfContentRect.drY0;
    int				y1= paraBi1->biBelowPosition.lpPageYTwips;

    int				frameHeight;
    BlockFrame			bfRedo;

    if  ( ! DOCisFRAME( fp ) )
	{ LDEB(1); return;	}

    if  ( fp->fpHighTwips < 0 )
	{
	y1= y0- fp->fpHighTwips;

	/*
	if  ( paraBi1->biBelowPosition.lpPageYTwips > y1 )
	    { LLDEB(paraBi1->biBelowPosition.lpPageYTwips,y1);	}
	*/
	}

    if  ( fp->fpHighTwips > 0 )
	{ y1= y0+ fp->fpHighTwips;	}

    if  ( paraBi1->biBelowPosition.lpPageYTwips < y1 )
	{ paraBi1->biBelowPosition.lpPageYTwips=  y1;	}

    frameHeight= y1- y0;
    docLayoutInitBlockFrame( &bfRedo );
    docLayoutSetTextFrame( &bfRedo, &(plpFlow->plpPos),
						bfFlow, fp, frameHeight );

    if  ( bfRedo.bfContentRect.drY0		!=
	  bfTextFrame->bfContentRect.drY0	)
	{
	int		yBelow;
	LayoutPosition	lpTop= paraBi0->biTopPosition;

	lpTop.lpPageYTwips= bfRedo.bfContentRect.drY0;

	yBelow= bfRedo.bfContentRect.drY0+ frameHeight;

	docRedoParaStripLayout( lj, bfTextFrame, &lpTop,
						cellBi, paraFrom, paraUpto );

	paraBi1->biBelowPosition.lpPageYTwips= yBelow;
	}

    return;
    }

