/************************************************************************/
/*									*/
/*  Document Layout and Printing related functionality.			*/
/*									*/
/************************************************************************/

#   ifndef	DOC_LAYOUT_H
#   define	DOC_LAYOUT_H

#   include	<docBuf.h>
#   include	"docEditRange.h"
#   include	<utilIndexMapping.h>
#   include	"docParticuleData.h"
#   include	"docStripFrame.h"
#   include	"docStripLayoutJob.h"
#   include	"docBlockOrnaments.h"
#   include	"docLayoutExternalItem.h"
#   include	"docBlockFrame.h"
#   include	"layoutContext.h"

/************************************************************************/

#   define	includeRectangleY( dr1, dr2 ) \
		{ \
		if  ( (dr1)->drY0 > (dr2)->drY0 )  \
		    { (dr1)->drY0=  (dr2)->drY0; } \
		if  ( (dr1)->drY1 < (dr2)->drY1 )  \
		    { (dr1)->drY1=  (dr2)->drY1; } \
		}

/************************************************************************/
/*									*/
/*  Reasons why the formatter stops.					*/
/*									*/
/************************************************************************/

typedef enum FormatterResult
    {
    FORMATstopREADY= 0,
    FORMATstopFRAME_FULL,
    FORMATstopPAGE_FULL,
    FORMATstopNEXT_FRAME,

    FORMATstopPARTIAL,

    FORMATstop_COUNT
    } FormatterResult;

/************************************************************************/
/*									*/
/*  Pass through information for a layout job.				*/
/*									*/
/************************************************************************/

struct LayoutJob;

typedef int (*LAYOUT_SCREEN_LINE)( 
				const TextLine *		tl,
				const BufferItem *		paraBi,
				const LayoutContext *		lc,
				const ParagraphFrame *		ffPixels,
				ParticuleData *			pd );

typedef int (*START_SCREEN_PARAGRAPH)(
				BufferItem *			bi,
				const ParagraphFrame *		pf,
				const LayoutContext *		lc );

typedef void (*ADJUST_SCREEN_RECT)(
				const LayoutPosition *		lpHere,
				const struct LayoutJob *	ljRef );

/************************************************************************/
/*									*/
/*  A Layout Job.							*/
/*									*/
/*  A)	The rectangle that is to be redrawn on the screen. Coordinates	*/
/*	are in pixels, but relative to the document as a whole. ( Not	*/
/*	dependent on the position of the scrollbars. ) In non		*/
/*	interactive layout jobs this is a NULL pointer.			*/
/*  B)	Drawing data for font information, scaling from wips to pixels	*/
/*	etc.								*/
/*  C)	The document as a whole.					*/
/*  D)	The Node in the document tree that initiated the layout job.	*/
/*									*/
/*  E)	The current position on paper of the layout job.		*/
/*									*/
/*  F)	Indirection for screen calculations when laying out the		*/
/*	document.							*/
/*  G)	Adjust the screen rectangle to the document height.		*/
/*									*/
/************************************************************************/

typedef struct LayoutJob
    {
    DocumentRectangle *		ljChangedRectanglePixels;	/*  A	*/
    BufferItem *		ljChangedItem;			/*  D	*/
    LayoutContext		ljContext;

    int				ljBalancePage;
    int				ljBalanceY1;

    const BufferItem *		ljBodySectBi;

    START_SCREEN_PARAGRAPH	ljStartScreenParagraph;		/*  F	*/
    LAYOUT_SCREEN_LINE		ljLayoutScreenLine;		/*  F	*/
    ADJUST_SCREEN_RECT		ljAdjustScreenRectangle;	/*  G	*/
    } LayoutJob;

/************************************************************************/

# define DOClayoutUSE_COLUMNS( inExtIt ) \
		    ( (inExtIt) == DOCinBODY		|| \
		      (inExtIt) == DOCinFOOTNOTE	|| \
		      (inExtIt) == DOCinENDNOTE		|| \
		      (inExtIt) == DOCinFTNSEP		|| \
		      (inExtIt) == DOCinFTNSEPC		|| \
		      (inExtIt) == DOCinFTNCN		|| \
		      (inExtIt) == DOCinAFTNSEP		|| \
		      (inExtIt) == DOCinAFTNSEPC	|| \
		      (inExtIt) == DOCinAFTNCN		)

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitLayoutJob(		LayoutJob *	lj );
extern void docCleanLayoutJob(		LayoutJob *	lj );

extern int docLayoutLineBox(	BufferDocument *		bd,
				TextLine *			tl,
				BufferItem *			bi,
				int				part,
				const PostScriptFontList *	apfl,
				ParticuleData *			pd,
				const ParagraphFrame *		pf );

extern int docLayoutParagraphLineExtents(
				int *				pFontSize,
				BufferDocument *		bd,
				const PostScriptFontList *	psfl,
				BufferItem *			bi );

extern int docLayoutItemAndParents(	BufferItem *		bi,
					LayoutJob *		lj );

extern int docAdjustParaLayout(		BufferItem *		bi,
					int			afterReplace,
					int			stroffFrom,
					int			stroffShift,
					int			stroffUpto,
					LayoutJob *		lj );

extern void docLayoutColumnTop(	LayoutPosition *		lpTop,
				BlockFrame *			bf,
				BufferItem *			bodySectBi,
				const LayoutJob *		lj );

extern int docLayoutExternalItem( DocumentTree *	ei,
				DocumentRectangle *	drChanged,
				int			page,
				int			column,
				int			y0Twips,
				const BufferItem *	bodySectBi,
				const LayoutContext *	lc,
				INIT_LAYOUT_EXTERNAL	initLayoutExternal );

extern int docLayoutStripChildren(
				int *				pStopCode,
				ParagraphLayoutJob *		plj,
				BlockFrame *			bf,
				const LayoutJob *		lj,
				BufferItem *			cellBi );

extern int docLayoutParagraphs(	BufferItem *			cellBi,
				BlockFrame *			bf,
				const LayoutJob *		lj,
				ParagraphLayoutJob *		plj );

extern void docLayoutToNextColumn(	LayoutPosition *		lpTop,
					BlockFrame *			bf,
					BufferItem *			bi,
					const LayoutJob *		lj );

extern int docLayoutRowItem(	int *			pStopCode,
				LayoutPosition *	lpBelow,
				const LayoutPosition *	lpTop,
				BufferItem *		rowBi,
				BlockFrame *		bf,
				int			stayInThisColumn,
				const LayoutJob *	lj );

extern void docCommitStripLayout(
				int *				pAdvanced,
				int				advanceAnyway,
				ParagraphLayoutJob *		plj,
				int				page,
				int				column,
				const BufferItem *		cellBi );

extern void docFindStripLayoutOrigin(
				ParagraphLayoutJob *		plj,
				int				page,
				int				column,
				const BufferItem *		cellBi );

extern void docLayoutBlockFrame( BlockFrame *			bf,
				BufferItem *			bi,
				const LayoutJob *		lj,
				int				page,
				int				column );

extern int docLayoutFootnotesForColumn(	LayoutPosition *	lpBelowNotes,
					const LayoutPosition *	lpBelowText,
					const BlockFrame *	refBf,
					int			belowText,
					const LayoutJob *	refLj );

extern int docLayoutCollectParaFootnoteHeight(
			NotesReservation *		nr,
			int				referringPage,
			int				referringColumn,
			BufferDocument *		bd,
			const BufferItem *		bodySectBi,
			const BufferItem *		paraBi,
			int				partFrom,
			int				partUpto );

extern int docCollectFootnotesFromColumn(
			BlockFrame *			bf,
			const DocumentPosition *	dpHere,
			int				partHere,
			BufferDocument *		bd,
			int				referringPage,
			int				referringColumn );

extern int docNoteSeparatorRectangle(
				DocumentRectangle *		drExtern,
				DocumentTree **			pEiNoteSep,
				int *				pY0Twips,
				const BufferItem *		bodySectBi,
				const DocumentNote *		dnFirstNote,
				int				extItKind,
				const LayoutContext *		lc );

extern int docGetExternalItemBox(
				DocumentRectangle *		dr,
				const BufferItem *		bodySectBi,
				const DocumentTree *		ei,
				int				justUsed,
				int				page,
				int				column,
				const LayoutContext *		lc );

extern int docExternalItemPrelayout(	DocumentTree *		ei,
					const BufferItem *	bodySectBi,
					LayoutJob *		lj );

extern int docLayoutItemImplementation(	LayoutPosition *	lpBelow,
					const LayoutPosition *	lpTop,
					BufferItem *		bi,
					BlockFrame *		bf,
					LayoutJob *		lj );

extern int docSectHeaderFooterPrelayout(	BufferItem *	sectBi,
						LayoutJob *	lj );

extern int docLayoutEndnotesForSection(	LayoutPosition *	lpBelow,
					const LayoutPosition *	lpTop,
					int			sect,
					BlockFrame *		bf,
					LayoutJob *		lj );

extern int docLayoutEndnotesForDocument(	LayoutPosition *	lpBelow,
						const LayoutPosition *	lpTop,
						BlockFrame *		bf,
						LayoutJob *		lj );

extern int docLayoutParaLines(	int *				pStopCode,
				const ParagraphFrame *		pf,
				LayoutPosition *		lpHere,
				int *				pLine,
				BlockFrame *			bf,
				const LayoutJob *		lj,
				BufferItem *			paraBi,
				int				part );

extern void docLayoutScaleObjectToFitParagraphFrame(
				int *				pChanged,
				InsertedObject *		io,
				int				pageHigh,
				const ParagraphFrame *		pf );

extern int docLayoutSectChildren(	LayoutPosition *	lpBelow,
					const LayoutPosition *	lpTop,
					BufferItem *		sectBi,
					int			from,
					BlockFrame *		bf,
					LayoutJob *		lj );

extern int docLayoutSectItem(	LayoutPosition *		lpBelow,
				const LayoutPosition *		lpTop,
				BufferItem *			sectBi,
				BlockFrame *			bf,
				LayoutJob *			lj );

extern void docLayoutPlaceSectTop(	BufferItem *		sectBi,
					LayoutPosition *	lpHere,
					BlockFrame *		bf,
					LayoutJob *		lj );

extern void docResetExternalItemLayout(	BufferDocument *	bd );

extern void docDrawingShapeInvalidateTextLayout(	DrawingShape *	ds );

extern void docShapePageY(	LayoutPosition *	lpShapeTop,
				LayoutPosition *	lpBelowShape,
				const DrawingShape *	ds,
				const BufferItem *	paraBi,
				const LayoutPosition *	lpLineTop,
				const BlockFrame *	bf );

extern void docShapePageRectangle(
				LayoutPosition *	lpShapeTop,
				LayoutPosition *	lpBelowShape,
				int *			pX0,
				int *			pX1,
				const DrawingShape *	ds,
				const BufferItem *	paraBi,
				const LayoutPosition *	lpLineTop,
				const ParagraphFrame *	pfRef,
				const BlockFrame *	bfRef,
				int			xChar );

extern int docShapeCheckTextLayout(
			DrawingShape *			ds,
			const DocumentRectangle *	drTwips,
			DocumentRectangle *		drChanged,
			const BufferItem *		bodySectBi,
			int				page,
			int				column,
			const LayoutContext *		lc,
			INIT_LAYOUT_EXTERNAL		initLayoutExternal );

extern int docLayoutInvalidateRange(	DocumentSelection *	dsLayout,
					const DocumentTree *	ei,
					EditRange *		er );

extern void docRedoParaStripLayout(
				const LayoutJob *		lj,
				BlockFrame *			bf,
				const LayoutPosition *		lpFrom,
				BufferItem *			cellBi,
				int				paraFrom,
				int				paraUpto );

extern int docCheckPageOfSelectedExtItem(
				int *			pChanged,
				BufferItem **		pBodySectBi,
				DocumentRectangle *	drChanged,
				DocumentTree *		selRootEi,
				const LayoutContext *	lc,
				INIT_LAYOUT_EXTERNAL	initLayoutExternal );

extern int docSectNotesPrelayout(
				int				sect,
				const BufferItem *		bodySectBi,
				LayoutJob *			lj );

extern void docLayoutSetItemBottom(	int *			pChanged,
					BufferItem *		bi,
					const LayoutPosition *	lp,
					const LayoutContext *	lc,
					DocumentRectangle *	drChanged );

extern int docLayoutGetInitialFrame(	BlockFrame *		bf,
					const LayoutJob *	lj,
					const LayoutPosition *	lpHere,
					BufferItem *		bi );

extern void docLayoutStartItemLayout(	BufferItem *		bi,
					const LayoutJob *	lj,
					const LayoutPosition *	lpHere );

extern void docLayoutFinishItemLayout(	BufferItem *		bi,
					const LayoutJob *	lj,
					const LayoutPosition *	lpHere );

extern int docLayoutFinishSectItem(
				LayoutPosition *		lpBelow,
				const LayoutPosition *		lpTop,
				BufferItem *			sectBi,
				BlockFrame *			bf,
				LayoutJob *			lj );

extern void docLayoutCalculateParaTopInset(
				const BufferDocument *		bd,
				BufferItem *			paraBi );

extern void docLayoutCalculateParaBottomInset(
				const BufferDocument *		bd,
				BufferItem *			paraBi );

extern const AfmFontInfo * docLayoutGetAfi(
			TextAttribute *			ta,
			unsigned char *			pLineFlags,
			BufferDocument *		bd,
			const PostScriptFontList *	psfl,
			int				textAttrNumber );

extern int docLayoutFontAscDesc( BufferDocument *		bd,
				const BufferItem *		paraBi,
				DocumentRectangle *		drAscDesc,
				int *				pBorder,
				const PostScriptFontList *	psfl,
				const TextParticule *		tp );

extern int docLayoutStringExtents(	int *			pWidth,
					int *			pDecWidth,
					DocumentRectangle *	dr,
					const TextAttribute *	ta,
					int			sizeTwips,
					const BufferDocument *	bd,
					const AfmFontInfo *	afi,
					const char *		printString,
					int			len );

extern int docLayoutInlineObject( const BufferDocument *	bd,
				const TextParticule *		tp,
				InsertedObject *		io,
				DocumentRectangle *		drWord,
				int *				pWordBorder,
				int *				pX1,
				int				x0 );

extern int docLayoutDelimitSpan(	int *			pLen,
					int *			pX1Twips,
					int			x0Twips,
					TextAttribute *		ta,
					const BufferDocument *	bd,
					const BufferItem *	paraBi,
					int			part,
					int			upto,
					int			separate );

extern void docLayoutCalculateAfterRowTopInset(	BufferItem *		belowBi,
						const BufferDocument *	bd );

extern int docLayoutStartParagraph(
			int *				pToNextColumn,
			const LayoutJob *		lj,
			BufferItem *			paraBi,
			const BlockFrame *		bf,
			ParagraphLayoutPosition *	plp );

extern void docLayoutFinishFrame(
			const FrameProperties *		fp,
			BlockFrame *			bfTextFrame,
			const BlockFrame *		bfFlow,
			const LayoutJob *		lj,
			const ParagraphLayoutPosition *	plpFlow,
			BufferItem *			cellBi,
			int				paraFrom,
			int				paraUpto );

extern int docLayoutParagraphInStrip(
			int *				pStopCode,
			ParagraphLayoutPosition *	plp,
			BlockFrame *			bf,
			const LayoutJob *		lj,
			int				cellTopInset,
			BufferItem *			paraBi );

extern int docLayoutRowInStrip(
			int *				pStopCode,
			ParagraphLayoutPosition *	plp,
			BlockFrame *			bf,
			const LayoutJob *		lj,
			int				cellTopInset,
			BufferItem *			paraBi );

extern int docAdjustParentLayout(	const LayoutPosition *	lpTop,
					BufferItem *		bi,
					BlockFrame *		bf,
					LayoutJob *		lj );

extern int docLayoutCellItem(	LayoutPosition *	lpBelow,
				const LayoutPosition *	lpTop,
				BufferItem *		cellBi,
				int			from,
				BlockFrame *		bf,
				LayoutJob *		lj );

extern void docRowLayoutRowspanAdmin(
				BufferItem *			cellBi,
				const BufferItem *		rowBi,
				const BufferItem *		nextRowBi,
				int				nextRow,
				const CellProperties *		cp,
				int				l,
				int				r,
				ParagraphLayoutJob *		plj );

extern void docCellStripFrame(	BufferItem *			cellBi,
				const BlockFrame *		bf,
				ParagraphLayoutJob *		plj );

extern void docGetPixelRect(	DocumentRectangle *		drPixels,
				const LayoutContext *		lc,
				const DocumentRectangle *	drTwips,
				int				page );

extern void docGetPixelRectForPos(
				DocumentRectangle *		drPixels,
				const LayoutContext *		lc,
				int				x0Twips,
				int				x1Twips,
				const LayoutPosition *		lpTop,
				const LayoutPosition *		lpBottom );

extern void docGetPageRectPixels(
				DocumentRectangle *		drPixels,
				const LayoutContext *		lc,
				int				page0,
				int				page1 );

extern void docPixelRectangleForPositions(
				DocumentRectangle *		drPixels,
				const PositionGeometry *	pgB,
				const PositionGeometry *	pgE,
				const LayoutContext *		lc );

extern int docLayoutScapsScreenFont(	const LayoutContext *	lc,
					const TextAttribute *	ta );

#   endif	/*  DOC_LAYOUT_H  */
