/************************************************************************/
/*									*/
/*  Drawing functionality: Utility functions.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>

#   include	"docDraw.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Initialise a DrawingContext						*/
/*									*/
/************************************************************************/

void docInitDrawingContext(	DrawingContext *	dc )
    {
    dc->dcCurrentTextAttributeSet= 0;
    utilInitTextAttribute( &(dc->dcCurrentTextAttribute) );

    dc->dcCurrentColorSet= 0;
    bmInitRGB8Color( &(dc->dcCurrentColor) );

    dc->dcBodySectBi= (const BufferItem *)0;
    layoutInitContext( &(dc->dcLayoutContext) );

    dc->dcClipRect= (DocumentRectangle *)0;
    dc->dcDocumentSelection= (DocumentSelection *)0;
    dc->dcSelectionGeometry= (SelectionGeometry *)0;
    dc->dcFirstPage= -1;
    dc->dcLastPage= -1;
    dc->dcDrawExternalItems= 0;
    dc->dcPostponeHeadersFooters= 0;
    dc->dcDocHasPageHeaders= 0;
    dc->dcDocHasPageFooters= 0;

    dc->dcDrawTableGrid= 0;

    dc->dcSetColorRgb= (SET_COLOR_RGB)0;
    dc->dcSetFont= (SET_FONT)0;
    dc->dcDrawShape= (DRAW_SHAPE)0;

    dc->dcDrawTextLine= (DRAW_TEXT_LINE)0;
    dc->dcDrawOrnaments= (DRAW_ORNAMENTS)0;

    dc->dcFinishPage= (FINISH_PAGE)0;
    dc->dcStartPage= (START_PAGE)0;
    dc->dcInitLayoutExternal= (INIT_LAYOUT_EXTERNAL)0;

    return;
    }

/************************************************************************/
/*									*/
/*  Cause subsequent drawing to be done in a certain color.		*/
/*									*/
/*  NOTE that background drawing with color= 0 is against the RTF idea	*/
/*	of the default background color: transparent.			*/
/*									*/
/************************************************************************/

void docDrawSetColorRgb(	DrawingContext *	dc,
				void *			through,
				const RGB8Color *	rgb8 )
    {
    if  ( ! dc->dcCurrentColorSet				||
	  dc->dcCurrentColor.rgb8Red != rgb8->rgb8Red		||
	  dc->dcCurrentColor.rgb8Green != rgb8->rgb8Green	||
	  dc->dcCurrentColor.rgb8Blue != rgb8->rgb8Blue		)
	{
	if  ( ! dc->dcSetColorRgb			||
	      (*dc->dcSetColorRgb)( dc, through, rgb8 )	)
	    { LDEB(1); return;	}

	dc->dcCurrentColor= *rgb8;
	dc->dcCurrentColorSet= 1;
	}

    return;
    }

void docDrawSetColorNumber(	DrawingContext *	dc,
				void *			through,
				int			colorNumber )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    const BufferDocument *	bd= lc->lcDocument;
    const DocumentProperties *	dp= &(bd->bdProperties);
    RGB8Color			rgb8;

    rgb8.rgb8Red= 0;
    rgb8.rgb8Green= 0;
    rgb8.rgb8Blue= 0;
    rgb8.rgb8Alpha= 255;

    if  ( colorNumber != 0 )
	{
	if  ( colorNumber < 1			||
	      colorNumber >= dp->dpColorCount	)
	    { LLDEB(colorNumber,dp->dpColorCount);	}
	else{ rgb8= dp->dpColors[colorNumber];		}
	}

    docDrawSetColorRgb( dc, through, &rgb8 );

    return;
    }

void docDrawSetFont(		DrawingContext *	dc,
				void *			through,
				int			textAttr,
				const TextAttribute *	newTa )
    {
    TextAttribute *	curTa= &(dc->dcCurrentTextAttribute);

    if  ( ! dc->dcCurrentTextAttributeSet				||
	  curTa->taFontNumber != newTa->taFontNumber			||
	  curTa->taFontSizeHalfPoints != newTa->taFontSizeHalfPoints	||
	  curTa->taFontIsBold != newTa->taFontIsBold			||
	  curTa->taFontIsSlanted != newTa->taFontIsSlanted		||
	  curTa->taSmallCaps != newTa->taSmallCaps			||
	  curTa->taSuperSub != newTa->taSuperSub			)
	{
	if  ( ! dc->dcSetFont					||
	      (*dc->dcSetFont)( dc, through, textAttr, newTa )	)
	    { LDEB(1); return;	}

	dc->dcCurrentTextAttributeSet= 1;
	*curTa= *newTa;
	}

    return;
    }

