#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<limits.h>

#   include	<appMatchFont.h>

#   include	"docDraw.h"
#   include	"docLayout.h"
#   include	"docTextLine.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Generic Document drawing machinery.					*/
/*									*/
/************************************************************************/

static int docDrawShadingStretch(	int *			pNext,
					int *			pXTwips,
					DocumentRectangle *	drText,
					int			baseline,
					int			skip,
					DrawingContext *	dc,
					const BufferItem *	paraBi,
					int			part,
					int			partUpto )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    const BufferDocument *	bd= lc->lcDocument;
    const TextParticule *	tp= paraBi->biParaParticules+ part;
    TextAttribute		ta;
    int				x0Twips= *pXTwips;
    int				xTwips= *pXTwips;

    utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList),
						tp->tpTextAttrNr );

    while( ta.taShadingNumber == skip )
	{
	xTwips += tp->tpTwipsWide;
	part++; tp++;

	if  ( part >= partUpto )
	    { break;	}

	utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList),
							    tp->tpTextAttrNr );
	}

    *pNext= ta.taShadingNumber;
    *pXTwips= xTwips;
    if  ( drText )
	{
	drText->drX0= x0Twips;
	drText->drX1= xTwips;
	}

    return part;
    }

static int docDrawBorderStretch(	int *			pNext,
					int *			pXTwips,
					DocumentRectangle *	drText,
					int			baseline,
					int			skip,
					DrawingContext *	dc,
					const BufferItem *	paraBi,
					int			part,
					int			partUpto )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    const BufferDocument *	bd= lc->lcDocument;
    const TextParticule *	tp= paraBi->biParaParticules+ part;
    TextAttribute		ta;
    int				x0Twips= *pXTwips;
    int				xTwips= *pXTwips;

    utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList),
						tp->tpTextAttrNr );

    while( ta.taBorderNumber == skip )
	{
	xTwips += tp->tpTwipsWide;
	part++; tp++;

	if  ( part >= partUpto )
	    { break;	}

	utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList),
						tp->tpTextAttrNr );
	}

    *pNext= ta.taBorderNumber;
    *pXTwips= xTwips;
    if  ( drText )
	{
	drText->drX0= x0Twips;
	drText->drX1= xTwips;
	}

    return part;
    }

/************************************************************************/

static int docDrawTextBorders(
			const BufferItem *		paraBi,
			const TextLine *		tl,
			int				baseline,
			const DocumentRectangle *	drLine,
			int				page,
			int				xTwips,
			void *				through,
			DrawingContext *		dc )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    const BufferDocument *	bd= lc->lcDocument;

    BlockOrnaments		ornaments;

    int				part;
    int				partUpto;

    docInitBlockOrnaments( &ornaments );

    PROPmaskADD( &(ornaments.boPropMask), ORNdrawTOP_BORDER );
    PROPmaskADD( &(ornaments.boPropMask), ORNdrawLEFT_BORDER );
    PROPmaskADD( &(ornaments.boPropMask), ORNdrawRIGHT_BORDER );
    PROPmaskADD( &(ornaments.boPropMask), ORNdrawBOTTOM_BORDER );

    part= tl->tlFirstParticule;
    partUpto= tl->tlFirstParticule+ tl->tlParticuleCount;
    while( part < partUpto )
	{
	int			borderNumber;
	int			ignored;
	int			next;

	DocumentRectangle	drText;

	part= docDrawBorderStretch( &borderNumber, &xTwips,
					(DocumentRectangle *)0, baseline,
					0, dc, paraBi, part, partUpto );

	if  ( part >= partUpto )
	    { break;	}

	drText= *drLine;

	next= docDrawBorderStretch( &ignored, &xTwips, &drText, baseline,
				borderNumber, dc, paraBi, part, partUpto );

	if  ( next > part && xTwips > drText.drX0 )
	    {
	    docGetBorderPropertiesByNumber( &(ornaments.boTopBorder),
			    &(bd->bdBorderPropertyList), borderNumber );

	    if  ( DOCisBORDER( &(ornaments.boTopBorder) ) )
		{
		int			thick;
		int			space;
		DocumentRectangle	drInside;

		ornaments.boLeftBorder= ornaments.boTopBorder;
		ornaments.boRightBorder= ornaments.boTopBorder;
		ornaments.boBottomBorder= ornaments.boTopBorder;

		geoIntersectRectangle( &drText, &drText, drLine );

		thick= docBorderThick( &space, &(ornaments.boTopBorder) );
		drInside= drText;

		drInside.drX0 += thick;
		drInside.drX1 -= thick;
		drInside.drY0 += thick;
		drInside.drY1 -= thick;

		if  ( (*dc->dcDrawOrnaments)( &ornaments, page,
					    &drText, &drInside, through, dc ) )
		    { LDEB(1); return -1;	}
		}
	    }

	part= next;
	}

    return 0;
    }

/************************************************************************/

static int docDrawTextShading(
			const BufferItem *		paraBi,
			const TextLine *		tl,
			int				baseline,
			const DocumentRectangle *	drLine,
			int				page,
			int				xTwips,
			void *				through,
			DrawingContext *		dc )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    const BufferDocument *	bd= lc->lcDocument;

    BlockOrnaments		ornaments;

    int				part;
    int				partUpto;

    docInitBlockOrnaments( &ornaments );
    PROPmaskADD( &(ornaments.boPropMask), ORNdrawSHADE );

    part= tl->tlFirstParticule;
    partUpto= tl->tlFirstParticule+ tl->tlParticuleCount;
    while( part < partUpto )
	{
	int			shadingNumber;
	int			ignored;
	int			next;
	DocumentRectangle	drText;

	part= docDrawShadingStretch( &shadingNumber, &xTwips,
					    (DocumentRectangle *)0, baseline,
					    0, dc, paraBi, part, partUpto );

	if  ( part >= partUpto )
	    { break;	}

	drText= *drLine;

	next= docDrawShadingStretch( &ignored, &xTwips, &drText, baseline,
				shadingNumber, dc, paraBi, part, partUpto );

	if  ( next > part && xTwips > drText.drX0 )
	    {
	    docGetItemShadingByNumber( &(ornaments.boShading),
				    &(bd->bdItemShadingList), shadingNumber );

	    geoIntersectRectangle( &drText, &drText, drLine );

	    if  ( (*dc->dcDrawOrnaments)( &ornaments,
					page, &drText, &drText, through, dc ) )
		{ LDEB(1); return -1;	}
	    }

	part= next;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Draw borders and shading below the text of a line.			*/
/*									*/
/*  Experimentation with MS-Word reveals:				*/
/*  1)  That MS-Word draws the border over the text.			*/
/*  2)  The the border is subtracted from the rectangle.		*/
/*  3)  That the same rectangle is used for borders and shading. This	*/
/*	same rectangle is shown in reverse when text is selected.	*/
/*									*/
/************************************************************************/

static int docDrawLineBackground(
			const BufferItem *		paraBi,
			const TextLine *		tl,
			const ParagraphFrame *		pf,
			void *				through,
			DrawingContext *		dc,
			const BlockOrigin *		bo )
    {
    int				page;

    DocumentRectangle		drLine;
    int				lineHeight= tl->tlLineStride;
    int				xTwips;
    int				baseline;

    page= tl->tlTopPosition.lpPage;
    if  ( bo->boOverrideFrame )
	{ page= bo->boFrameOverride.lpPage;	}

    drLine= pf->pfParaContentRect;
    drLine.drY0= tl->tlTopPosition.lpPageYTwips+ bo->boYShift;
    drLine.drY1= drLine.drY0+ lineHeight;

    baseline= drLine.drY0+ TL_BASELINE( tl );

    xTwips= pf->pfParaContentRect.drX0+ tl->tlLineIndent;

    if  ( tl->tlFlags & TLflagSHADING )
	{
	if  ( docDrawTextShading( paraBi, tl, baseline,
				    &drLine, page, xTwips, through, dc ) )
	    { LDEB(1); return -1;	}
	}

    if  ( tl->tlFlags & TLflagBORDER )
	{
	if  ( docDrawTextBorders( paraBi, tl, baseline,
				    &drLine, page, xTwips, through, dc ) )
	    { LDEB(1); return -1;	}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Draw a series of text lines in a paragraph.				*/
/*									*/
/*  1)  For all lines that apply: Those in paraBi in the current	*/
/*	page/column combination.					*/
/*  2)  If the line is on a subsequent page.. stop.			*/
/*  3)  Is line is on a page/column before the pages/column to draw?	*/
/*  4)  Is the line in the rectangle to redraw?				*/
/*	As this is inside a column, a line that is outside the clipping	*/
/*	rectangle vertically is out of range inside this column.	*/
/*  5)  Printing a page range.. and not in range?			*/
/*  6)  Drawing a selection? E.G. To highlight it?			*/
/*									*/
/************************************************************************/

int docDrawTextLines(	void *				through,
			const ParagraphDrawingStrip *	pds,
			BufferItem *			paraBi,
			const ParagraphFrame *		pf,
			DrawingContext *		dc,
			const BlockOrigin *		bo )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    int				done= 0;
    int				pastSelectionEnd= 0;

    int				line= pds->pdsLineFrom;
    const TextLine *		tl= paraBi->biParaLines+ line;

    if  ( pds->pdsShadeTop.lpPage != pds->pdsShadeBelow.lpPage )
	{ LLDEB(pds->pdsShadeTop.lpPage,pds->pdsShadeBelow.lpPage);	}
    if  ( pds->pdsShadeTop.lpColumn != pds->pdsShadeBelow.lpColumn )
	{ LLDEB(pds->pdsShadeTop.lpColumn,pds->pdsShadeBelow.lpColumn);	}

    /*  1  */
    while( line < paraBi->biParaLineCount )
	{
	int			accepted;
	int			beforeSelectionBegin= 0;

	LayoutPosition		lpTop;
	LayoutPosition		lpBottom;
	DocumentRectangle	drLinePixels;

	docShiftPosition( &lpTop, bo, &(tl->tlTopPosition) );
	lpBottom= lpTop;
	lpBottom.lpPageYTwips += tl->tlLineStride;

	docGetPixelRectForPos( &drLinePixels, lc,
			pf->pfCellContentRect.drX0+ bo->boXShift,
			pf->pfCellContentRect.drX1+ bo->boXShift,
			&lpTop, &lpBottom );

	/*  2  */
	if  ( lpTop.lpPage > pds->pdsShadeTop.lpPage )
	    { break;	}

	/*  3  */
	if  ( lpTop.lpPage < pds->pdsShadeTop.lpPage )
	    { beforeSelectionBegin= 1;	}
	else{
	    if  ( lpTop.lpColumn > pds->pdsShadeTop.lpColumn )
		{ break;	}
	    if  ( lpTop.lpColumn < pds->pdsShadeTop.lpColumn )
		{ beforeSelectionBegin= 1;	}
	    }

	/*  4  */
	if  ( dc->dcClipRect )
	    {
	    if  ( drLinePixels.drY0 > dc->dcClipRect->drY1 )
		{ pastSelectionEnd= 1;	}
	    if  ( drLinePixels.drY1 < dc->dcClipRect->drY0 )
		{ beforeSelectionBegin= 1;	}
	    }

	/*  5  */
	if  ( dc->dcFirstPage >= 0				&&
	      pds->pdsShadeTop.lpPage < dc->dcFirstPage	)
	    { beforeSelectionBegin= 1;	}

	/*  6  */
	if  ( dc->dcDocumentSelection					&&
	      ! beforeSelectionBegin					&&
	      ! pastSelectionEnd					&&
	      ( paraBi == dc->dcDocumentSelection->dsHead.dpBi	||
	        paraBi == dc->dcDocumentSelection->dsTail.dpBi	)	)
	    {
	    const DocumentSelection *	ds= dc->dcDocumentSelection;

	    DocumentSelection		dsLine;

	    int				partLineBegin;
	    int				partLineEnd;

	    docLineSelection( &dsLine, &partLineBegin, &partLineEnd,
								paraBi, line );

	    if  ( paraBi == ds->dsTail.dpBi				&&
		  docComparePositions( &(dsLine.dsHead),
						&(ds->dsTail) ) > 0	)
		{ pastSelectionEnd= 1;	}

	    if  ( paraBi == ds->dsHead.dpBi				&&
		  docComparePositions( &(dsLine.dsTail),
					    &(ds->dsHead) ) < 0	)
		{ beforeSelectionBegin= 1;	}
	    }

	/****************************************************************/
	/*  Do not clip here: The find code might want to look for	*/
	/*  lines in the immediate proximity of a mouse click.		*/
	/****************************************************************/
	if  ( beforeSelectionBegin	||
	      pastSelectionEnd		||
	      ! dc->dcDrawTextLine	)
	    { accepted= tl->tlParticuleCount;		}
	else{
	    if  ( dc->dcDrawOrnaments				&&
		  ( ( tl->tlFlags & TLflagSHADING )	||
		    ( tl->tlFlags & TLflagBORDER )	)	)
		{
		docDrawLineBackground( paraBi, tl, pf, through, dc, bo );
		}

	    accepted= (*dc->dcDrawTextLine)( paraBi, line, pf, &drLinePixels,
							    through, dc, bo );
	    }

	if  ( accepted < 1 )
	    { LDEB(accepted); return -1; }

	done += accepted; line++; tl++;
	}

    return 0;
    }

