/************************************************************************/
/*									*/
/*  Ted, generic shape drawing functionality.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<math.h>

#   include	"docDraw.h"
#   include	"docLayout.h"

#   include	<appDebugon.h>

int docShapeGetFill(	int *			pFill,
			const DrawingShape *	ds,
			DrawingContext *	dc,
			void *			through )
    {
    RGB8Color	co;
    int		fill= 1;

    if  ( ! ds->ds_fFilled )
	{ *pFill= 0; return 0; }
    if  ( ds->dsFillOpacity == 0 )
	{ *pFill= 0; return 0; }

    switch( ds->dsFillType )
	{
	case DSfillSOLID:
	    co= ds->dsFillColor;
	    fill= 1;
	    break;

	case DSfillSHADE_START_TO_END:
	case DSfillSHADE_BOUNDS_TO_END:
	case DSfillSHADE_OUTLINE_TO_END:
	case DSfillSHADE_ANGLE:
	    /*LDEB(ds->dsFillType);*/
	    co= ds->dsFillColor;
	    fill= 1;
	    break;

	default:
	    LDEB(ds->dsFillType);
	    return -1;
	}

    if  ( fill )
	{ docDrawSetColorRgb( dc, through, &co );	}

    *pFill= fill;
    return 0;
    }

int docShapeGetLine(	int *			pLine,
			const DrawingShape *	ds,
			DrawingContext *	dc,
			void *			through )
    {
    RGB8Color	co;
    int		line= 1;

    if  ( ! ds->ds_fLine )
	{ *pLine= 0; return 0; }

    switch( ds->dsLineType )
	{
	case DSlineSOLID:
	    co= ds->dsLineColor;
	    line= 1;
	    break;

	default:
	    LDEB(ds->dsLineType);
	    return -1;
	}

    if  ( line )
	{ docDrawSetColorRgb( dc, through, &co );	}

    *pLine= line;
    return 0;
    }


/************************************************************************/
/*									*/
/*  Traverse a tree of shapes and draw the leaves.			*/
/*									*/
/*  1)  Clip leaf shapes: It is unknown whether chidren can protrude	*/
/*	from their parents. As a matter of fact, it is even unclear	*/
/*	whether a free form can leave its rectangle.			*/
/*									*/
/************************************************************************/

static int docDrawDrawingShape(	const DocumentRectangle *	drTwips,
				const BufferItem *		bodySectBi,
				int				page,
				int				column,
				DrawingShape *			ds,
				DrawingContext *		dc,
				void *				through )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    int				rval= 0;
    int				child;

    DocumentRectangle		drHere= *drTwips;
    LayoutPosition		lpBelow;

    docInitLayoutPosition( &lpBelow );

    if  ( DSflipHORIZONTAL( ds ) )
	{ int sw= drHere.drX0; drHere.drX0= drHere.drX1; drHere.drX1= sw; }

    if  ( DSflipVERTICAL( ds ) )
	{ int sw= drHere.drY0; drHere.drY0= drHere.drY1; drHere.drY1= sw; }

    if  ( ds->dsShapeType == SHPtyGROUP )
	{
	double			xscale;
	double			yscale;

	xscale= ( 1.0* ( drHere.drX1- drHere.drX0 ) )/
			    ( ds->dsGroupRect.drX1- ds->dsGroupRect.drX0 );
	yscale= ( 1.0* ( drHere.drY1- drHere.drY0 ) )/
			    ( ds->dsGroupRect.drY1- ds->dsGroupRect.drY0 );

	for ( child= 0; child < ds->dsChildCount; child++ )
	    {
	    DrawingShape *	dsChild= ds->dsChildren[child];
	    DocumentRectangle	drChild;

	    drChild.drX0= drHere.drX0+ xscale* 
			( dsChild->dsRelRect.drX0- ds->dsGroupRect.drX0 );
	    drChild.drY0= drHere.drY0+ yscale*
			( dsChild->dsRelRect.drY0- ds->dsGroupRect.drY0 );
	    drChild.drX1= drHere.drX0+ xscale* 
			( dsChild->dsRelRect.drX1- ds->dsGroupRect.drX0 );
	    drChild.drY1= drHere.drY0+ yscale*
			( dsChild->dsRelRect.drY1- ds->dsGroupRect.drY0 );

	    if  ( docDrawDrawingShape( &drChild, bodySectBi, page, column,
						    dsChild, dc, through ) )
		{ LDEB(child); rval= -1;	}
	    }
	}
    else{
	if  ( dc->dcClipRect )
	    {
	    DocumentRectangle	drPixels;

	    docGetPixelRect( &drPixels, lc, drTwips, page );

	    if  ( ! geoIntersectRectangle( (DocumentRectangle *)0,
						dc->dcClipRect, &drPixels ) )
		{ return 0;	}
	    }

	if  ( ! dc->dcDrawShape						||
	      (*dc->dcDrawShape)( drTwips, page, ds, dc, through )	)
	    { LDEB(1); rval= -1;	}

	dc->dcCurrentTextAttributeSet= 0;
	dc->dcCurrentColorSet= 0;

	if  ( ds->dsDocumentTree.eiRoot )
	    {
	    const BufferItem *	bodySectBiSav= dc->dcBodySectBi;

	    if  ( ( page != ds->dsDocumentTree.eiPageFormattedFor	||
		    column != ds->dsDocumentTree.eiColumnFormattedFor	) &&
		  docShapeCheckTextLayout( ds, &drHere,
			    (DocumentRectangle *)0,
			    bodySectBi, page, column, lc,
			    dc->dcInitLayoutExternal ) )
		{ LDEB(page); return -1;	}

	    dc->dcBodySectBi= bodySectBi;
	    if  ( docDrawItem( &lpBelow, ds->dsDocumentTree.eiRoot,
							    through, dc ) )
		{ LDEB(1);	}

	    dc->dcBodySectBi= bodySectBiSav;
	    }
	}

    return rval;
    }

/************************************************************************/
/*									*/
/*  Draw the root shape of an object. I.E: The shape that is directly	*/
/*  inserted in the document. Its children are reached through		*/
/*  recursion.								*/
/*									*/
/************************************************************************/

int docDrawShape(	DrawingContext *		dc,
			void *				through,
			const BufferItem *		bodySectBi,
			const InsertedObject *		io )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    DrawingShape *		ds= io->ioDrawingShape;
    const ShapeProperties *	sp= &(ds->dsShapeProperties);

    int				page= io->ioY0Position.lpPage;
    int				column= io->ioY0Position.lpColumn;

    DocumentRectangle		drTwips;

    if  ( ! ds )
	{ XDEB(ds); return 0;	}

    drTwips.drX0= io->ioX0Twips;
    drTwips.drX1= drTwips.drX0+ sp->spRect.drX1- sp->spRect.drX0;
    drTwips.drY0= io->ioY0Position.lpPageYTwips;
    drTwips.drY1= drTwips.drY0+ sp->spRect.drY1- sp->spRect.drY0;

    if  ( dc->dcClipRect )
	{
	DocumentRectangle	drPixels;

	docGetPixelRect( &drPixels, lc, &drTwips, page );

	if  ( ! geoIntersectRectangle( (DocumentRectangle *)0,
					    &drPixels, dc->dcClipRect ) )
	    { return 0;	}
	}

    docDrawDrawingShape( &drTwips, bodySectBi, page, column,
							ds, dc, through );
    return 0;
    }

