#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<limits.h>

#   include	"docDraw.h"
#   include	"docPageGrid.h"

#   include	<appDebugon.h>

/************************************************************************/

static int docDrawRowPageStrip(	BufferItem *			rowBi,
				const LayoutPosition *		lpThisFrame,
				BlockFrame *			bf,
				void *				through,
				DrawingContext *		dc,
				const BlockOrigin *		bo );

/************************************************************************/
/*									*/
/*  Draw part of the grid originating from a table row.			*/
/*									*/
/*  4)  For all cells.....						*/
/*  5)  Skip cells that are included in the colspan or rowspan of	*/
/*	another cell. The left/top cell of a span has to draw the	*/
/*	borders and the background.					*/
/*									*/
/************************************************************************/

static int docDrawCellOrnamentsForRow(
			const BufferItem *			rowBi,
			const BlockFrame *			bf,
			void *					through,
			DrawingContext *			dc,
			int					xShift,
			int					atRowTop,
			int					atRowBottom,
			const LayoutPosition *			lpTop,
			const LayoutPosition *			lpBelow )
    {
    const LayoutContext *		lc= &(dc->dcLayoutContext);
    const BufferDocument *		bd= lc->lcDocument;
    const CellProperties *		cp;
    int					col;

    if  ( ! dc->dcDrawOrnaments )
	{ return 0;	}

    /*  4  */
    cp= rowBi->biRowCells;
    for ( col= 0; col < rowBi->biChildCount; cp++, col++ )
	{
	BufferItem *			cellBi= rowBi->biChildren[col];

	BlockOrnaments			cellOrnaments;
	DocumentRectangle		drCell;
	DocumentRectangle		drOutside;
	DocumentRectangle		drInside;

	LayoutPosition			lpBelowCell;

	docInitBlockOrnaments( &cellOrnaments );

	/*  5  */
	if  ( CELL_MERGED( cp ) )
	    { continue;	}

	lpBelowCell= *lpBelow;

	if  ( cp->cpTopInMergedColumn	&&
	      atRowBottom		)
	    { lpBelowCell= cellBi->biBelowPosition;	}

	{
	ParagraphFrame	pf;

	docCellFrameTwips( &pf, bf, cellBi );

	drCell.drX0= pf.pfCellRect.drX0+ xShift;
	drCell.drX1= pf.pfCellRect.drX1+ xShift;
	drCell.drY0= lpTop->lpPageYTwips;
	drCell.drY1= lpBelowCell.lpPageYTwips;
	}

	docGetCellOrnaments( &cellOrnaments, &drOutside, &drInside, &drCell,
			bd, rowBi, col,
			atRowTop, atRowBottom, dc->dcDrawTableGrid );

	if  ( (*dc->dcDrawOrnaments)( &cellOrnaments, lpTop->lpPage,
					&drOutside, &drInside, through, dc ) )
	    { LDEB(1); return -1;	}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Find the position upto where this cell has advanced on the page.	*/
/*									*/
/*  1)  For all children of the cell..					*/
/*  2)  Find the lowest position on the current page.			*/
/*  3)  Was anything added to this page?				*/
/*  4)  If this paragraph does not fit as a whole. Subsequent		*/
/*	paragraphs will not fit either.					*/
/*  5)  Not all paragraphs completely placed on this page.. Some lines	*/
/*	will be printed on the next one.				*/
/*									*/
/************************************************************************/

static int docDrawBelowCellStrip(
			BufferItem *				cellBi,
			const LayoutPosition *			lpThisFrame,
			LayoutPosition *			lpBelow,
			BlockFrame *				bf,
			const BlockOrigin *			bo )
    {
    const TextLine *	tl;

    LayoutPosition	lpLastLine;

    DocumentPosition	dpLast;
    int			lineLast;
    int			partLast;

    if  ( docGetLastInColumnForItem( &dpLast, &lineLast, &partLast,
			cellBi, lpThisFrame->lpPage, lpThisFrame->lpColumn ) )
	{ return 1;	}

    tl= dpLast.dpBi->biParaLines+ lineLast;
    lpLastLine= tl->tlTopPosition;
    lpLastLine.lpPageYTwips += tl->tlLineStride;

    docShiftPosition( &lpLastLine, bo, &lpLastLine );

    docLayoutPushBottomDown( lpBelow, &lpLastLine );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Find the lowest position of the row in the current block frame.	*/
/*									*/
/*  1)  If the row ends in the frame, the case is simple: return the	*/
/*	row bottom. (This case covers shifted table headers: Headers	*/
/*	stay in one frame.)						*/
/*  2)  Otherwise look inside the cells. This code does not handle	*/
/*	shifted table headers correctly.				*/
/*									*/
/************************************************************************/

static int docDrawBelowRowStrip(
			BufferItem *				rowBi,
			const LayoutPosition *			lpThisFrame,
			LayoutPosition *			lpBelow,
			BlockFrame *				bf,
			const BlockOrigin *			bo )
    {
    int				col;
    const CellProperties *	cp= rowBi->biRowCells;

    LayoutPosition		lpBottom;

    /*  1  */
    docShiftPosition( &lpBottom, bo, &(rowBi->biRowBelowAllPosition) );
    if  ( DOC_SAME_FRAME( lpThisFrame, &lpBottom ) )
	{
	*lpBelow= lpBottom;
	return 0;
	}

    /*  2  */
    lpBottom= *lpThisFrame;
    for ( col= 0; col < rowBi->biChildCount; cp++, col++ )
	{
	BufferItem *	cellBi= rowBi->biChildren[col];

	LayoutPosition	lpBelowCell= lpBottom;

	if  ( CELL_MERGED( cp ) )
	    { continue;	}

	if  ( docDrawBelowCellStrip( cellBi,
					lpThisFrame, &lpBelowCell, bf, bo ) )
	    { continue;	}

	docLayoutPushBottomDown( &lpBottom, &lpBelowCell );
	}

    *lpBelow= lpBottom;
    return 0;
    }

/************************************************************************/

static int docDrawAdvanceRowInCell(
				void *				through,
				BufferItem *			rowBi,
				LayoutPosition *		lpThisFrame,
				LayoutPosition *		lpBelow,
				BlockFrame *			bf,
				DrawingContext *		dc,
				const BlockOrigin *		bo )
    {
    if  ( docDrawRowPageStrip( rowBi, lpThisFrame, bf, through, dc, bo ) )
	{ LDEB(1); return -1;	}

    /*  Only used in same frame */
    *lpBelow= rowBi->biBelowPosition;

    return 0;
    }

/************************************************************************/

static int docDrawAdvanceParaInCell(
				void *				through,
				BufferItem *			paraBi,
				const LayoutPosition *		lpThisFrame,
				LayoutPosition *		lpBelow,
				BlockFrame *			bf,
				DrawingContext *		dc,
				const BlockOrigin *		bo )
    {
    ParagraphDrawingStrip	pds;
    const int			countAfter= 0;

    ParagraphFrame		pf;
    int				line= 0;

    LayoutPosition		lpShadeTop= *lpThisFrame;

    docParagraphFrameTwips( &pf, bf, paraBi );

    while( line < paraBi->biParaLineCount )
	{
	TextLine *	tl= paraBi->biParaLines+ line;
	LayoutPosition	lpLine;

	docShiftPosition( &lpLine, bo, &(tl->tlTopPosition) );

	if  ( ! DOC_COLUMN_AFTER( lpThisFrame, &lpLine ) )
	    { break;	}

	line++;
	}

    /**/
    if  ( docDrawParagraphStrip( through, &pds, paraBi, countAfter,
				&lpShadeTop, line, &pf, dc, lpThisFrame, bo ) )
	{ LDEB(line); return -1;	}

    /*  Only used in same frame */
    *lpBelow= pds.pdsShadeBelow;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Print as much of a table-cell/column in a row as fits on the	*/
/*  current page.							*/
/*									*/
/*  1)  Skip entries that end before the current page.			*/
/*  2)  Draw entries that do not start after the current page.		*/
/*									*/
/************************************************************************/

static int docDrawCellPageStrip( void *				through,
				const BufferItem *		cellBi,
				const LayoutPosition *		lpThisFrame,
				BlockFrame *			bf,
				DrawingContext *		dc,
				const BlockOrigin *		bo )
				
    {
    int			child= 0;

    LayoutPosition	lpShadeTop= *lpThisFrame;
    LayoutPosition	lpShadeBelow= *lpThisFrame;

    /*  1  */
    while( child < cellBi->biChildCount )
	{
	BufferItem *		childBi= cellBi->biChildren[child];
	const LayoutPosition *	belowChildPos;
	LayoutPosition		lpChildBottom;

	if  ( docIsRowItem( childBi ) )
	    { belowChildPos= &(childBi->biRowBelowAllPosition);	}
	else{ belowChildPos= &(childBi->biBelowPosition);	}

	docShiftPosition( &lpChildBottom, bo, belowChildPos );
	if  ( ! DOC_COLUMN_AFTER( lpThisFrame, &lpChildBottom ) )
	    { break;	}

	child++;
	}

    /*  2  */
    while( child < cellBi->biChildCount )
	{
	BufferItem *	childBi= cellBi->biChildren[child];
	LayoutPosition	lpChildTop;

	docShiftPosition( &lpChildTop, bo, &(childBi->biTopPosition) );

	if  ( DOC_COLUMN_AFTER( &lpChildTop, lpThisFrame ) )
	    { break;	}

	switch( childBi->biLevel )
	    {
	    case DOClevPARA:
		if  ( docDrawAdvanceParaInCell( through, childBi,
				    &lpShadeTop, &lpShadeBelow, bf, dc, bo ) )
		    { LDEB(1); return -1;	}
		break;

	    case DOClevROW:
		if  ( docDrawAdvanceRowInCell( through, childBi,
				    &lpShadeTop, &lpShadeBelow, bf, dc, bo ) )
		    { LDEB(1); return -1;	}
		break;

	    default:
		LDEB(childBi->biLevel);
		break;
	    }

	/*  Only used in same frame */
	lpShadeTop= lpShadeBelow;
	child++;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Print as much of a table row as fits on the current page.		*/
/*									*/
/*  1)  Find the bottom of this row on the page: We need this to draw	*/
/*	the cell ornaments before we draw the row contents.		*/
/*									*/
/************************************************************************/

static int docDrawRowPageStrip(	BufferItem *			rowBi,
				const LayoutPosition *		lpThisFrame,
				BlockFrame *			bf,
				void *				through,
				DrawingContext *		dc,
				const BlockOrigin *		bo )
    {
    int				col;

    LayoutPosition		lpTop;
    LayoutPosition		lpBottom;
    const CellProperties *	cp;

    int				atRowTop= 0;
    int				atRowBottom= 0;

    if  ( DOC_SAME_FRAME( lpThisFrame, &(rowBi->biTopPosition) ) )
	{ atRowTop= 1;	}
    if  ( DOC_SAME_FRAME( lpThisFrame, &(rowBi->biRowBelowAllPosition) ) )
	{ atRowBottom= 1;	}

    lpTop= *lpThisFrame;
    lpBottom= *lpThisFrame;

    if  ( ! rowBi->biRowIsTableHeader )
	{
	if  ( atRowTop )
	    {
	    docShiftPosition( &lpTop, bo, &(rowBi->biTopPosition) );

	    if  ( rowBi->biRowPrecededByHeader )
		{
		int		high;

		if  ( docDrawTableHeader( &high, rowBi, bf, through,
				    dc, &(rowBi->biRowAboveHeaderPosition) ) )
		    { LDEB(rowBi->biRowPrecededByHeader); return -1;	}
		}
	    }
	else{
	    if  ( rowBi->biRowTableHeaderRow >= 0 )
		{
		int		high;

		if  ( docDrawTableHeader( &high, rowBi, bf, through,
							    dc, lpThisFrame ) )
		    { LDEB(rowBi->biRowIsTableHeader); return -1;	}
		}
	    }
	}

    if  ( docDrawBelowRowStrip( rowBi, lpThisFrame, &lpBottom, bf, bo ) )
	{ LDEB(1); return -1;	}

    if  ( docDrawCellOrnamentsForRow( rowBi, bf,
			through, dc, bo->boXShift,
			atRowTop, atRowBottom, &lpTop, &lpBottom ) )
	{ LDEB(1); return -1;	}

    cp= rowBi->biRowCells;
    for ( col= 0; col < rowBi->biChildCount; cp++, col++ )
	{
	BufferItem *	cellBi= rowBi->biChildren[col];
	LayoutPosition	lpBelowCell;

	if  ( CELL_MERGED( cp ) )
	    { continue;	}

	if  ( dc->dcDocumentSelection )
	    {
	    const DocumentSelection *	ds= dc->dcDocumentSelection;

	    if  ( docCompareItemPositions( cellBi, ds->dsHead.dpBi ) < 0 )
		{ continue;	}

	    if  ( docCompareItemPositions( cellBi, ds->dsTail.dpBi ) > 0 )
		{ continue;	}

	    if  ( ( ds->dsCol0 >= 0 && col < ds->dsCol0	)	||
	          ( ds->dsCol1 >= 0 && col > ds->dsCol1	)	)
		{ continue;	}
	    }

	lpBelowCell= lpBottom;

	if  ( docDrawCellPageStrip( through, cellBi, &lpTop, bf, dc, bo ) )
	    { LDEB(1); return -1;	}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Draw a table header.						*/
/*									*/
/*  1)  Find the header that belongs to this row.			*/
/*  2)  Determine where the header would be drawn to find the		*/
/*	horizontal offset for header drawing.				*/
/*									*/
/************************************************************************/

int docDrawTableHeader(	int *				pHigh,
			const BufferItem *		rowBi,
			const BlockFrame *		bfRef,
			void *				through,
			DrawingContext *		dc,
			const LayoutPosition *		lpHeader )
    {
    const LayoutContext *		lc= &(dc->dcLayoutContext);
    BufferItem *			headerBi;
    BlockFrame				bfHeader;

    BlockOrigin				bo;

    docInitBlockOrigin( &bo );

    /*  1  */
    if  ( rowBi->biRowTableHeaderRow < 0 )
	{ LDEB(rowBi->biRowTableHeaderRow); return -1;	}

    headerBi= rowBi->biParent->biChildren[rowBi->biRowTableHeaderRow];

    /*  2  */
    docLayoutInitBlockFrame( &bfHeader );
    docBlockFrameTwips( &bfHeader, headerBi,
			    dc->dcBodySectBi, lc->lcDocument,
			    headerBi->biTopPosition.lpPage,
			    headerBi->biTopPosition.lpColumn );

    bo.boOverrideFrame= 1;
    bo.boXShift= bfRef->bfContentRect.drX0- bfHeader.bfContentRect.drX0;
    bo.boYShift= lpHeader->lpPageYTwips- headerBi->biTopPosition.lpPageYTwips;
    bo.boFrameOverride= *lpHeader;

    if  ( docDrawRowItem( headerBi, through, dc, &bo ) )
	{ LDEB(1); return -1;	}

    *pHigh= headerBi->biBelowPosition.lpPageYTwips- 
					headerBi->biTopPosition.lpPageYTwips;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Draw a table row by successively drawing the portions that fit on	*/
/*  the current page and moving to the next page.			*/
/*									*/
/*  NOTE that any drawing routine can be recursive.			*/
/*									*/
/************************************************************************/

int docDrawRowItem(	BufferItem *			rowBi,
			void *				through,
			DrawingContext *		dc,
			const BlockOrigin *		bo )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    int				rval= 0;
    LayoutPosition		lpThisFrame;
    BlockFrame			bf;

    docLayoutInitBlockFrame( &bf );
    docBlockFrameTwips( &bf, rowBi, dc->dcBodySectBi, lc->lcDocument,
					    rowBi->biTopPosition.lpPage,
					    rowBi->biTopPosition.lpColumn );

    docShiftPosition( &lpThisFrame, bo, &(rowBi->biTopPosition) );

    if  ( docDrawRowPageStrip( rowBi, &lpThisFrame, &bf, through, dc, bo ) )
	{ LDEB(1); rval= -1; goto ready;	}

    while( DOC_COLUMN_AFTER( &(rowBi->biRowBelowAllPosition), &lpThisFrame ) )
	{
	int			ret;

	/*  1  */
	ret= docDrawToNextColumn( rowBi, rowBi, through,
						    &lpThisFrame, &bf, dc );
	if  ( ret < 0 )
	    { SLDEB(docLevelStr(rowBi->biLevel),ret); rval= -1; goto ready; }
	if  ( ret > 0 )
	    { break;	}

	if  ( docDrawRowPageStrip( rowBi, &lpThisFrame, &bf, through, dc, bo ) )
	    { LDEB(1); rval= -1; goto ready;	}
	}

  ready:

    return rval;
    }

