#   ifndef	DOC_DRAW_H
#   define	DOC_DRAW_H

#   include	<docBuf.h>
#   include	"docStripFrame.h"
#   include	"docBlockOrnaments.h"
#   include	"docLayoutExternalItem.h"
#   include	"docBlockFrame.h"
#   include	<utilIndexMapping.h>
#   include	"docLayoutPosition.h"
#   include	"layoutContext.h"

/************************************************************************/

typedef struct ParagraphDrawingStrip
    {
    int			pdsLineFrom;
    int			pdsLineUpto;

    int			pdsAtParaTop;
    int			pdsAtParaBottom;

    LayoutPosition	pdsShadeTop;
    LayoutPosition	pdsShadeBelow;
    } ParagraphDrawingStrip;

/************************************************************************/
/*									*/
/*  The different resources needed for drawing.				*/
/*									*/
/************************************************************************/

struct DrawingContext;

typedef int (*DRAW_TEXT_LINE)(	BufferItem *			paraBi,
				int				line,
				const struct ParagraphFrame *	pf,
				const DocumentRectangle *	drLinePixels,
				void *				through,
				struct DrawingContext *		dc,
				const BlockOrigin *		bo );

typedef int (*DRAW_ORNAMENTS)(	const BlockOrnaments *		ornaments,
				int				page,
				const DocumentRectangle *	drOutside,
				const DocumentRectangle *	drInside,
				void *				through,
				struct DrawingContext *		dc );

typedef int (*FINISH_PAGE)(	void *				through,
				struct DrawingContext *		dc,
				BufferItem *			bodySectBi,
				int				page,
				int				asLast );

typedef int (*START_PAGE)(	void *				through,
				const DocumentGeometry *	dg,
				struct DrawingContext *		dc,
				int				page );

typedef int (*SET_COLOR_RGB)(	struct DrawingContext *		dc,
				void *				through,
				const RGB8Color *		rgb8 );

typedef int (*SET_FONT)(	struct DrawingContext *		dc,
				void *				through,
				int				textAttr,
				const TextAttribute *		ta );

typedef int (*DRAW_SHAPE)(	const DocumentRectangle *	drTwips,
				int				page,
				DrawingShape *			ds,
				struct DrawingContext *		dc,
				void *				through );

typedef struct DrawingContext
    {
    int				dcCurrentTextAttributeSet;
    TextAttribute		dcCurrentTextAttribute;
    int				dcCurrentColorSet;
    RGB8Color			dcCurrentColor;

    const BufferItem *		dcBodySectBi;
    LayoutContext		dcLayoutContext;
    const DocumentRectangle *	dcClipRect;
    const DocumentSelection *	dcDocumentSelection;
    const SelectionGeometry *	dcSelectionGeometry;
    int				dcFirstPage;
    int				dcLastPage;
    int				dcDrawExternalItems;
    int				dcPostponeHeadersFooters;
    int				dcDocHasPageHeaders;
    int				dcDocHasPageFooters;

    int				dcDrawTableGrid;

    SET_COLOR_RGB		dcSetColorRgb;
    SET_FONT			dcSetFont;
    DRAW_SHAPE			dcDrawShape;

    DRAW_TEXT_LINE		dcDrawTextLine;		/*  foreground	*/
    DRAW_ORNAMENTS		dcDrawOrnaments;	/*  background	*/

    FINISH_PAGE			dcFinishPage;
    START_PAGE			dcStartPage;
    INIT_LAYOUT_EXTERNAL	dcInitLayoutExternal;
    } DrawingContext;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitDrawingContext(	DrawingContext *	dc );

extern int docDrawItem(		LayoutPosition *		lpBelow,
				BufferItem *			bi,
				void *				through,
				DrawingContext *		dc );

extern int docDrawPageHeader(	BufferItem *			sectBi,
				void *				through,
				DrawingContext *		dc,
				int				page );

extern int docDrawPageFooter(	BufferItem *			sectBi,
				void *				through,
				DrawingContext *		dc,
				int				page );

extern int docDrawShapesForTree(	DocumentTree *		ei,
					const BufferItem *	bodySectBi,
					void *			through,
					DrawingContext *	dc,
					int			belowText,
					int			page );

extern int docDrawFootnotesForColumn(
				int				page,
				int				column,
				void *				through,
				DrawingContext *		dc );

extern int docDrawEndnotesForSection(	LayoutPosition *	lpBelow,
					int			sect,
					void *			through,
					DrawingContext *	dc );

extern int docDrawEndnotesForDocument(	LayoutPosition *	lpBelow,
					void *			through,
					DrawingContext *	dc );

extern int docDrawToColumnOfItem(	BufferItem *		prevBodyBi,
					BufferItem *		thisBodyBi,
					BufferItem *		thisBi,
					void *			through,
					LayoutPosition *	lpHere,
					DrawingContext *	dc,
					const BlockOrigin *	bo );

extern void docDrawSetColorRgb(		DrawingContext *	dc,
					void *			through,
					const RGB8Color *	rgb8 );

extern void docDrawSetColorNumber(	DrawingContext *	dc,
					void *			through,
					int			colorNumber );

extern void docDrawSetFont(	DrawingContext *	dc,
				void *			through,
				int			textAttr,
				const TextAttribute *	ta );

extern int docShapeGetFill(	int *			pFill,
				const DrawingShape *	ds,
				DrawingContext *	dc,
				void *			through );

extern int docShapeGetLine(	int *			pFill,
				const DrawingShape *	ds,
				DrawingContext *	dc,
				void *			through );

extern int docDrawShape(	DrawingContext *		dc,
				void *				through,
				const BufferItem *		bodySectBi,
				const InsertedObject *		io );

extern int docDrawRowItem(	BufferItem *			rowBi,
				void *				through,
				DrawingContext *		dc,
				const BlockOrigin *		bo );

extern int docDrawTableHeader(	int *				pHigh,
				const BufferItem *		rowBi,
				const BlockFrame *		bfRef,
				void *				through,
				DrawingContext *		dc,
				const LayoutPosition *		lpHeader );

extern int docDrawParagraphStrip( void *			through,
				ParagraphDrawingStrip *		pds,
				BufferItem *			paraBi,
				int				countAfter,
				const LayoutPosition *		lpShadeTop,
				int				lineFrom,
				const ParagraphFrame *		pf,
				DrawingContext *		dc,
				const LayoutPosition *		lpThisFrame,
				const BlockOrigin *		bo );

extern int docDelimitParagraphDrawingStrip(
				ParagraphDrawingStrip *		pds,
				const BufferItem *		paraBi,
				int				countAfter,
				const LayoutPosition *		lpShadeTop,
				int				lineFrom,
				const LayoutPosition *		lpThisFrame,
				const BlockOrigin *		bo );

extern int docDrawParaOrnaments( void *				through,
				const ParagraphDrawingStrip *	pds,
				const BufferItem *		paraBi,
				const ParagraphFrame *		pf,
				DrawingContext *		dc,
				const BlockOrigin *		bo );

extern int docDrawTextLines(	void *				through,
				const ParagraphDrawingStrip *	pds,
				BufferItem *			paraBi,
				const ParagraphFrame *		pf,
				DrawingContext *		dc,
				const BlockOrigin *		bo );

extern int docDrawToNextColumn(	BufferItem *			thisBodyBi,
				BufferItem *			nextBodyBi,
				void *				through,
				LayoutPosition *		lpHere,
				BlockFrame *			bf,
				DrawingContext *		dc );

extern int docDrawParaItem(	LayoutPosition *		lpBelow,
				BufferItem *			paraBi,
				void *				through,
				DrawingContext *		dc,
				const BlockOrigin *		bo );

#   endif
