#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<limits.h>

#   include	"docDraw.h"
#   include	"docPageGrid.h"
#   include	"docLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Generic Document drawing machinery.					*/
/*									*/
/************************************************************************/

void docInitBlockOrnaments(	BlockOrnaments *	bo )
    {
    utilPropMaskClear( &(bo->boPropMask) );

    docInitBorderProperties( &(bo->boTopBorder) );
    docInitBorderProperties( &(bo->boLeftBorder) );
    docInitBorderProperties( &(bo->boRightBorder) );
    docInitBorderProperties( &(bo->boBottomBorder) );

    docInitItemShading( &(bo->boShading) );
    }

/************************************************************************/
/*									*/
/*  Draw the shapes for this page					*/
/*									*/
/************************************************************************/

int docDrawShapesForTree(		DocumentTree *		ei,
					const BufferItem *	bodySectBi,
					void *			through,
					DrawingContext *	dc,
					int			belowText,
					int			page )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    BufferItem *		shapeRootBi= ei->eiRoot;
    const int			column= 0;

    DocumentPosition		dpPageTop;
    int				partPageTop;
    int				linePageTop;

    BufferItem *		paraBi;
    const TextLine *		tl;
    const TextParticule *	tp;
    int				part;
    int				line;

    if  ( ! dc->dcDrawShape )
	{ /*XDEB(dc->dcDrawShape);*/ return 0; }

    if  ( docGetFirstInColumnForItem( &dpPageTop, &linePageTop, &partPageTop,
						shapeRootBi, page, column ) )
	{ return 0; }

    paraBi= dpPageTop.dpBi;
    line= linePageTop;
    part= partPageTop;
    tl= paraBi->biParaLines+ line;
    tp= paraBi->biParaParticules+ part;

    for (;;)
	{
	if  ( paraBi->biTopPosition.lpPage > page )
	    { break;	}

	if  ( paraBi->biInExternalItem == DOCinBODY )
	    { bodySectBi= (const BufferItem *)0;	}

	while( line < paraBi->biParaLineCount )
	    {
	    if  ( tl->tlTopPosition.lpPage > page )
		{ break; }

	    while( part < tl->tlFirstParticule+ tl->tlParticuleCount )
		{
		if  ( tp->tpKind == DOCkindOBJECT )
		    {
		    const InsertedObject *	io;

		    io= docGetObject( lc->lcDocument, tp->tpObjectNumber );
		    if  ( ! io )
			{ LPDEB(tp->tpObjectNumber,io);	}

		    if  ( io && io->ioKind == DOCokDRAWING_SHAPE )
			{
			DrawingShape *		ds= io->ioDrawingShape;
			const ShapeProperties *	sp= &(ds->dsShapeProperties);

			if  ( paraBi->biInExternalItem == DOCinBODY	&&
			      ! bodySectBi				)
			    { bodySectBi= docGetBodySectBi( paraBi, lc->lcDocument ); }

			if  ( ! bodySectBi )
			    { XDEB(bodySectBi);	}
			else{
			    if  ( sp->spShapeBelowText == belowText	&&
				  docDrawShape( dc, through, bodySectBi, io ) )
				{ LDEB(1);	}
			    }
			}
		    }

		part++; tp++;
		}

	    line++; tl++;
	    }

	if  ( line < paraBi->biParaLineCount )
	    { break;	}

	paraBi= docNextParagraph( paraBi );
	if  ( ! paraBi )
	    { break;	}

	line= 0; tl= paraBi->biParaLines;
	part= 0; tp= paraBi->biParaParticules;
	}

    return 0;
    }

/************************************************************************/

static int docDrawLineLeftOfColumn(	BufferItem *		nextBodyBi,
					void *			through,
					LayoutPosition *	lpHere,
					BlockFrame *		bf,
					DrawingContext *	dc )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    const SectionProperties *	sp= &(nextBodyBi->biSectProperties);

    DocumentRectangle		drLLine;
    DocumentRectangle		drRLine;
    int				x0;
    int				x1;

    BlockOrnaments		ornaments;

    DocumentNote *		dn0;
    const DocumentField *	df0;

    int				alongNotes= 0;
    BufferItem *		biColBottomRoot;

    DocumentPosition		dpBottom;
    int				lineBottom;
    int				partBottom;
    const TextLine *		tlBottom;

    if  ( ! docIsSectItem( nextBodyBi ) )
	{ LDEB(nextBodyBi->biLevel); return -1;	}

    df0= docGetFirstNoteOnPage( &dn0, lc->lcDocument,
					    lpHere->lpPage, DOCinFOOTNOTE );
    if  ( df0 )
	{
	if  ( dn0->dnDocumentTree.eiRoot->biSectSelectionScope.ssOwnerSectNr >=
						nextBodyBi->biNumberInParent )
	    { alongNotes= 1;	}
	}

    docInitBlockOrnaments( &ornaments );
    PROPmaskADD( &(ornaments.boPropMask), ORNdrawLEFT_BORDER );

    ornaments.boLeftBorder.bpStyle= DOCbsS;
    ornaments.boLeftBorder.bpPenWideTwips= 15;

    drLLine= bf->bfFlowRect;

    if  ( nextBodyBi->biTopPosition.lpPage == lpHere->lpPage )
	{ drLLine.drY0= nextBodyBi->biTopPosition.lpPageYTwips; }

    biColBottomRoot= lc->lcDocument->bdBody.eiRoot;
    if  ( alongNotes )
	{
	DocumentNote *		dnz;
	const DocumentField *	dfz;

	dfz= docGetLastNoteInColumn( &dnz, lc->lcDocument,
			    lpHere->lpPage, lpHere->lpColumn, DOCinFOOTNOTE );
	if  ( dfz )
	    { biColBottomRoot= dnz->dnDocumentTree.eiRoot;	}
	}

    if  ( nextBodyBi->biTopPosition.lpPage <= lpHere->lpPage )
	{
	if  ( docGetLastInColumnForItem( &dpBottom, &lineBottom, &partBottom,
			biColBottomRoot, lpHere->lpPage, lpHere->lpColumn ) )
	    { LLDEB(lpHere->lpPage,lpHere->lpColumn);	}

	tlBottom= dpBottom.dpBi->biParaLines+ lineBottom;
	drLLine.drY1= tlBottom->tlTopPosition.lpPageYTwips+
						    tlBottom->tlLineStride;

	if  ( nextBodyBi->biBelowPosition.lpPage == lpHere->lpPage )
	    { drLLine.drY1= nextBodyBi->biBelowPosition.lpPageYTwips; }

	docSectGetColumnX( &(drLLine.drX0), &x0, &x1, sp,
				&(bf->bfPageGeometry), lpHere->lpColumn );
	drRLine= drLLine;
	drRLine.drX0= drLLine.drX0- ornaments.boLeftBorder.bpPenWideTwips;

	if  ( (*dc->dcDrawOrnaments)( &ornaments, lpHere->lpPage,
					    &drRLine, &drLLine, through, dc ) )
	    { LDEB(1); return -1;	}
	}

    docCleanBorderProperties( &bpLine );
    return 0;
    }

/************************************************************************/
/*									*/
/*  Skip to the next page.						*/
/*									*/
/*  A)  Draw the shapes for this page.					*/
/*  1)  Just to make the compiler happy, if nothing is to be printed	*/
/*	anymore, the current position is not going to be used.		*/
/*									*/
/************************************************************************/

int docDrawToNextColumn(		BufferItem *		thisBodyBi,
					BufferItem *		nextBodyBi,
					void *			through,
					LayoutPosition *	lpHere,
					BlockFrame *		bf,
					DrawingContext *	dc )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    BufferDocument *		bd= lc->lcDocument;

    const int			asLast= 0;

    int				startNewPage= 0;
    int				nextPage;
    int				nextColumn;
    int				isPageBreak= 0;

    thisBodyBi= docGetSectItem( thisBodyBi );
    nextBodyBi= docGetSectItem( nextBodyBi );

    nextPage= lpHere->lpPage;
    nextColumn= lpHere->lpColumn;

    nextColumn++;

    if  ( nextBodyBi )
	{
	if  ( nextColumn >= nextBodyBi->biSectColumnCount )
	    { nextPage++; nextColumn= 0; }
	}
    else{
	if  ( nextColumn >= thisBodyBi->biSectColumnCount )
	    { nextPage++; nextColumn= 0; }
	}

    if  ( nextPage != lpHere->lpPage )
	{ isPageBreak= 1; }

    if  ( dc->dcLastPage >= 0		&&
	  nextPage > dc->dcLastPage	)
	{ return 1; }

    if  ( dc->dcFirstPage < 0				||
	  lpHere->lpPage >= dc->dcFirstPage		)
	{
	const int	belowText= 0;

	startNewPage= 1;

	if  ( thisBodyBi->biInExternalItem != DOCinBODY )
	    { SDEB(docExternalKindStr(thisBodyBi->biInExternalItem));	}

	if  ( thisBodyBi					&&
              thisBodyBi->biInExternalItem == DOCinBODY		&&
	      dc->dcDrawExternalItems				)
	    {
	    if  ( docDrawFootnotesForColumn( lpHere->lpPage, lpHere->lpColumn,
								through, dc ) )
		{ LDEB(lpHere->lpPage); return -1;	}

	    if  ( ! dc->dcPostponeHeadersFooters			&&
		  isPageBreak						&&
		  docDrawPageFooter( thisBodyBi, through, dc,
						    lpHere->lpPage )	)
		{ LDEB(lpHere->lpPage); return -1;	}
	    }

	/*  A  */
	if  ( docDrawShapesForTree( &(bd->bdBody), thisBodyBi,
				    through, dc, belowText, lpHere->lpPage ) )
	    { LDEB(1);	}

	if  ( isPageBreak						&&
	      dc->dcFinishPage						&&
	      (*dc->dcFinishPage)( through, dc, thisBodyBi,
					    lpHere->lpPage, asLast )	)
	    { LDEB(1); return -1;	}
	}

    if  ( dc->dcLastPage < 0		||
	  nextPage <= dc->dcLastPage	)
	{
	lpHere->lpColumn= nextColumn;
	lpHere->lpPage= nextPage;

	if  ( nextBodyBi )
	    {
	    const SectionProperties *	sp= &(nextBodyBi->biSectProperties);
	    const DocumentGeometry *	dg= &(sp->spDocumentGeometry);
	    const int			belowText= 1;

	    docLayoutSectColumnTop( lpHere, bf, nextBodyBi, bd );

	    if  ( isPageBreak && startNewPage )
		{
		if  ( dc->dcStartPage					&&
		      (*dc->dcStartPage)( through, dg, dc,
						    lpHere->lpPage )	)
		    { LDEB(1); return -1;	}

		if  ( docDrawShapesForTree( &(bd->bdBody), nextBodyBi,
				    through, dc, belowText, lpHere->lpPage ) )
		    { LDEB(1);	}

		if  ( dc->dcDrawExternalItems				&&
		      ! dc->dcPostponeHeadersFooters			&&
		      docDrawPageHeader( nextBodyBi, through, dc,
						    lpHere->lpPage )	)
		    { LDEB(lpHere->lpPage); return -1;	}
		}

	    if  ( lpHere->lpColumn > 0					&&
		  sp->spLineBetweenColumns				&&
		  dc->dcDrawOrnaments					&&
		  docDrawLineLeftOfColumn( nextBodyBi, through,
						    lpHere, bf, dc )	)
		{ LDEB(sp->spLineBetweenColumns);	}
	    }
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Skip to the column where a BufferItem begins.			*/
/*									*/
/*  1)  No activity before the first page to be printed.		*/
/*									*/
/************************************************************************/

int docDrawToColumnOfItem(		BufferItem *		prevBodyBi,
					BufferItem *		thisBodyBi,
					BufferItem *		thisBi,
					void *			through,
					LayoutPosition *	lpHere,
					DrawingContext *	dc,
					const BlockOrigin *	bo )
    {
    BlockFrame		bf;
    LayoutPosition	lpTop;

    docLayoutInitBlockFrame( &bf );

if  ( thisBi->biInExternalItem == DOCinSHPTXT )
    { return 0;	}

    docShiftPosition( &lpTop, bo, &(thisBi->biTopPosition) );

    /*  1  */
    if  ( lpTop.lpPage < dc->dcFirstPage )
	{ return 0; }

    while( lpHere->lpPage < lpTop.lpPage )
	{
	if  ( docDrawToNextColumn( prevBodyBi, thisBodyBi, through,
						    lpHere, &bf, dc )	)
	    { SDEB(docLevelStr(thisBi->biLevel)); return -1;	}
	}

    while( lpHere->lpPage == lpTop.lpPage	&&
           lpHere->lpColumn < lpTop.lpColumn	)
	{
	if  ( docDrawToNextColumn( prevBodyBi, thisBodyBi, through,
						    lpHere, &bf, dc )	)
	    { SDEB(docLevelStr(thisBi->biLevel)); return -1;	}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Return a rectangle that contains an item and all its children.	*/
/*									*/
/*  4)  No xShift: bf is shifted because of the column.			*/
/*									*/
/************************************************************************/

static void docItemRectangle(	DocumentRectangle *	drPixels,
				BufferItem *		bi,
				DrawingContext *	dc,
				const BlockOrigin *	bo )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    BufferDocument *		bd= lc->lcDocument;
    BlockFrame			bf;
    ParagraphFrame		pf;

    LayoutPosition		lpTop;
    LayoutPosition		lpBelow;

    BlockOrnaments		ornaments;
    DocumentRectangle		drTwips;

    docInitBlockOrnaments( &ornaments );

    docShiftPosition( &lpTop, bo, &(bi->biTopPosition) );
    docShiftPosition( &lpBelow, bo, &(bi->biBelowPosition) );

    /********************************************************************/
    /*  If the item covers more than one page/column, completely	*/
    /*  include all pages that have it.					*/
    /********************************************************************/
    if  ( bi->biLevel == DOClevBODY		||
	  lpTop.lpPage != lpBelow.lpPage	||
	  lpTop.lpColumn != lpBelow.lpColumn	)
	{
	docGetPageRectPixels( drPixels, lc, lpTop.lpPage, lpBelow.lpPage );
	return;
	}

    docLayoutInitBlockFrame( &bf );
    docBlockFrameTwips( &bf, bi, dc->dcBodySectBi, lc->lcDocument,
					    lpTop.lpPage, lpTop.lpColumn );

    drTwips.drX0= bf.bfContentRect.drX0;
    drTwips.drX1= bf.bfContentRect.drX1;
    drTwips.drY0= lpTop.lpPageYTwips;
    drTwips.drY1= lpBelow.lpPageYTwips;

    switch( bi->biLevel )
	{
	case DOClevSECT:
	    break;

	case DOClevROW:
	    if  ( docIsRowItem( bi ) )
		{
		int			col;

		col= 0;
		docItemRectangle( drPixels, bi->biChildren[col], dc, bo );

		for ( col= 1; col < bi->biChildCount; col++ )
		    {
		    DocumentRectangle	drCell;

		    docItemRectangle( &drCell, bi->biChildren[col], dc, bo );
		    geoUnionRectangle( drPixels, drPixels, &drCell );
		    }
		}

	    break;

	case DOClevCELL:
	    if  ( docIsRowItem( bi->biParent ) )
		{
		const BufferItem *	rowBi= bi->biParent;

					/*  Other cases covered above	*/
		const int		atRowTop= 1;
		const int		atRowBottom= 1;
		DocumentRectangle	drCell;
		DocumentRectangle	drInside;

		docCellFrameTwips( &pf, &bf, bi );

		/*  4  */
		drCell= drTwips;
		drCell.drX0= pf.pfCellRect.drX0;
		drCell.drX1= pf.pfCellRect.drX1;

		docGetCellOrnaments( &ornaments, &drTwips, &drInside, &drCell,
					bd, rowBi, bi->biNumberInParent,
					atRowTop, atRowBottom,
					dc->dcDrawTableGrid );
		}
	    break;

	case DOClevPARA:
	    docParagraphFrameTwips( &pf, &bf, bi );

	    /*  4  */
	    drTwips.drX0= pf.pfCellContentRect.drX0;
	    drTwips.drX1= pf.pfCellContentRect.drX1;
	    break;

	default:
	    LDEB(bi->biLevel);
	    break;
	}

    lpTop.lpPageYTwips= drTwips.drY0;
    lpBelow.lpPageYTwips= drTwips.drY1;

    docGetPixelRectForPos( drPixels, lc,
			    drTwips.drX0, drTwips.drX1,
			    &lpTop, &lpBelow );
if  ( drPixels->drX0 > 0 )
drPixels->drX0--; /* rounding? */

    return;
    }

static void docTableHeaderRectangle(
				DocumentRectangle *	drPixels,
				const BlockFrame *	bf,
				BufferItem *		bi,
				DrawingContext *	dc )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);

    LayoutPosition	lpHeader= bi->biRowAboveHeaderPosition;

    docGetPixelRectForPos( drPixels, lc,
			    bf->bfContentRect.drX0, bf->bfContentRect.drX1,
			    &lpHeader, &(bi->biTopPosition) );

    return;
    }

/************************************************************************/
/*									*/
/*  Draw the children of a group item.					*/
/*									*/
/*  3)  Do not proceed beyond last page. To illustrate that table	*/
/*	headers fit on one page, the situation where we are forced into	*/
/*	a particular page block is excepted.				*/
/*  4)  If the child is on an accessible page, move to the column of	*/
/*	child.								*/
/*									*/
/************************************************************************/

static int docDrawGroupItem(	LayoutPosition *		lpBelow,
				const BufferItem *		bi,
				void *				through,
				DrawingContext *		dc,
				const BlockOrigin *		bo )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    int				i;
    LayoutPosition		lpHere;

    BufferItem *		prevBi= (BufferItem *)0;

    if  ( bi->biChildCount > 0 )
	{ prevBi= bi->biChildren[0];	}

    lpHere= bi->biTopPosition;
    for ( i= 0; i < bi->biChildCount; i++ )
	{
	BufferItem *		childBi= bi->biChildren[i];

	if  ( dc->dcClipRect )
	    {
	    DocumentRectangle	drChild;

	    docItemRectangle( &drChild, childBi, dc, bo );

	    if  ( ! geoIntersectRectangle( &drChild, &drChild,
							dc->dcClipRect ) )
		{
		if  ( childBi->biLevel == DOClevROW	&&
		      childBi->biRowPrecededByHeader	)
		    {
		    BlockFrame		bf;

		    docLayoutInitBlockFrame( &bf );
		    docBlockFrameTwips( &bf, childBi,
					    dc->dcBodySectBi, lc->lcDocument,
					    childBi->biTopPosition.lpPage,
					    childBi->biTopPosition.lpColumn );

		    docTableHeaderRectangle( &drChild, &bf, childBi, dc );

		    if  ( geoIntersectRectangle( &drChild, &drChild,
							dc->dcClipRect ) )
			{
			int		high;

			if  ( docDrawTableHeader( &high,
				    childBi, &bf, through,
				    dc, &(childBi->biRowAboveHeaderPosition) ) )
			    { LDEB(childBi->biRowPrecededByHeader); return -1; }
			}
		    }

		continue;
		}
	    }

	if  ( dc->dcDocumentSelection					&&
	      docSelectionSameRoot( dc->dcDocumentSelection, childBi )	&&
	      docCompareItemPositions( childBi,
			    dc->dcDocumentSelection->dsTail.dpBi ) > 0	)
	    { break;	}

	/*  3  */
	if  ( dc->dcLastPage >= 0				&&
	      ! bo->boOverrideFrame				&&
	      childBi->biTopPosition.lpPage > dc->dcLastPage	)
	    { break;	}

	/*  4  */
	if  ( dc->dcFirstPage < 0					||
	      childBi->biBelowPosition.lpPage >= dc->dcFirstPage	)
	    {
	    if  ( docDrawToColumnOfItem( prevBi, childBi, childBi,
					    through, &lpHere, dc, bo ) )
		{ SDEB(docLevelStr(childBi->biLevel)); return -1;	}

	    if  ( childBi->biInExternalItem == DOCinBODY	&&
		  childBi->biLevel == DOClevSECT		)
		{ dc->dcBodySectBi= childBi;	}

	    if  ( docDrawItem( lpBelow, childBi, through, dc ) )
		{ LDEB(i); return -1;	}

	    lpHere= childBi->biBelowPosition;
	    }

	prevBi= childBi;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Draw the document root item.					*/
/*									*/
/************************************************************************/

static int docDrawDocItem(	LayoutPosition *		lpBelow,
				const BufferItem *		docBi,
				void *				through,
				DrawingContext *		dc )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    BufferDocument *		bd= lc->lcDocument;
    const DocumentProperties *	dp= &(bd->bdProperties);

    BlockOrigin			bo;

    docInitBlockOrigin( &bo );

    if  ( docDrawGroupItem( lpBelow, docBi, through, dc, &bo ) )
	{ LDEB(1); return -1;	}

    if  ( docBi->biInExternalItem == DOCinBODY			&&
	  dp->dpEndnoteProperties.npPosition == FTN_POS_DOC_END	)
	{
	if  ( docDrawEndnotesForDocument( lpBelow, through, dc ) )
	    { LDEB(1); return -1;	}
	}

    if  ( dc->dcDrawExternalItems )
	{
	docDrawFootnotesForColumn( lpBelow->lpPage, lpBelow->lpColumn,
								through, dc );
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Draw a section and its dependants.					*/
/*									*/
/************************************************************************/

static int docDrawSectItem(	LayoutPosition *		lpBelow,
				const BufferItem *		sectBi,
				void *				through,
				DrawingContext *		dc )
    {
    const LayoutContext *	lc= &(dc->dcLayoutContext);
    BufferDocument *		bd= lc->lcDocument;
    const DocumentProperties *	dp= &(bd->bdProperties);

    BlockOrigin			bo;

    docInitBlockOrigin( &bo );

    if  ( docDrawGroupItem( lpBelow, sectBi, through, dc, &bo ) )
	{ LDEB(1); return -1;	}

    if  ( sectBi->biInExternalItem == DOCinBODY				&&
	  dp->dpEndnoteProperties.npPosition == FTN_POS_SECT_END	)
	{
	if  ( docDrawEndnotesForSection( lpBelow, sectBi->biNumberInParent,
							    through, dc ) )
	    { LDEB(1); return -1;	}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Draw an arbitrary item.						*/
/*									*/
/*  1)  Exception for table rows with 'rowspan' cells.			*/
/*  2)  Intersects clipping rectangle?					*/
/*  3)  Inside selection to draw?					*/
/*  4)  Inside page range to draw.					*/
/*									*/
/************************************************************************/

int docDrawItem(	LayoutPosition *		lpBelow,
			BufferItem *			bi,
			void *				through,
			DrawingContext *		dc )
    {
    const DocumentSelection *	ds= dc->dcDocumentSelection;

    LayoutPosition		lpBelowItem;

    BlockOrigin			bo;

    docInitBlockOrigin( &bo );

    /*  1  */
    lpBelowItem= bi->biBelowPosition;
    if  ( docIsRowItem( bi ) )
	{ lpBelowItem= bi->biRowBelowAllPosition;	}

    /*  2  */
    if  ( dc->dcClipRect )
	{
	DocumentRectangle	drItem;

	docItemRectangle( &drItem, bi, dc, &bo );

	if  ( ! geoIntersectRectangle( &drItem, &drItem, dc->dcClipRect )  )
	    { return 0;	}
	}

    /*  3  */
    if  ( ds && docSelectionSameRoot( ds, bi ) )
	{
	if  ( docCompareItemPositions( bi, ds->dsHead.dpBi ) < 0 )
	    { return 0;	}

	if  ( docCompareItemPositions( bi, ds->dsTail.dpBi ) > 0 )
	    { return 0; }
	}

    /*  4  */
    if  ( dc->dcFirstPage >= 0				&&
	  lpBelowItem.lpPage < dc->dcFirstPage		)
	{ return 0;	}

    if  ( dc->dcLastPage >= 0				&&
	  bi->biTopPosition.lpPage > dc->dcLastPage	)
	{ return 0;	}

    docLayoutPushBottomDown( lpBelow, &(bi->biTopPosition) );

    switch( bi->biLevel )
	{
	case DOClevBODY:
	    if  ( docDrawDocItem( lpBelow, bi, through, dc ) )
		{ LDEB(1); return -1;	}
	    break;

	case DOClevSECT:
	    if  ( docDrawSectItem( lpBelow, bi, through, dc ) )
		{ LDEB(1); return -1;	}
	    break;

	case DOClevCELL:
	rowAsGroup:
	    if  ( docDrawGroupItem( lpBelow, bi, through, dc, &bo ) )
		{ LDEB(1); return -1;	}
	    break;

	case DOClevROW:
	    if  ( ! docIsRowItem( bi ) )
		{ goto rowAsGroup;	}

	    if  ( docDrawRowItem( bi, through, dc, &bo ) )
		{ LDEB(1); return -1;	}
	    break;

	case DOClevPARA:
	    if  ( docDrawParaItem( lpBelow, bi, through, dc, &bo ) )
		{ LDEB(1); return -1;	}
	    break;

	default:
	    LDEB(bi->biLevel); return -1;
	}

    return 0;
    }
