#!/usr/local/bin/perl
# $Id: static.pl,v 1.9 2001/01/03 08:20:31 tom Exp $
################################################################

# Copyright(C) 1999 TANAKA Tomonari, TomSoft

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

################################################################

require 5.000;                # perl5 ɬ

use lib qw(lib);

use strict;
use Getopt::Std;

use TDS;
use TDS::Di;
use TDS::Mode;
use TDS::Renderer;
use TDS::Summary;
use TDS::Replacer::Url;
use TDS::Static;
use TDS::Search;

TDS::Mode::SetMode('static');

$| = 1;

################################################################
my %opt;
getopts("trfsuqdgch", \%opt) || die;

# إ
if ($opt{h}){
    print STDERR "perl static.pl [-atrfsuqdh]
 -r   only recent.html
 -t   only this month (and recent)
 -s   only summary 
 -u   only url
 -d   only dictionary
 -g   only sigsearch
 -c   only hina.di(DICA)

 -f   force (ignore last_modified)
 -q   quiet
 -h   help
";
    exit;
}
 
my $static = new TDS::Static;

$static->force($opt{'f'});
$static->quiet($opt{'q'});
$static->only_this_month($opt{'t'});

{
    my %tmp = ('r'=>'recent', 'm'=>'month', 'u'=>'url',
	       's'=>'summary', 'd'=>'dictionary',
	       'g'=>'sigsearch', 'c'=>'hina_di');
    my $flg;
    for (keys %tmp){
	if ($opt{$_}){
	    $static->AddAction($tmp{$_});
	    $flg = 1;
	}
    }
    unless ($flg){
	for (keys %tmp){
	    $static->AddAction($tmp{$_});
	}
    }
}

$TDS::System::EnableCache = 0 if $opt{'f'};

$static->Do;
