#!/usr/local/bin/perl
################################################################
#hns2tdf.pl
# hnf  tdf ؤδʰץС
#
# ΥޥɤߤƤ櫓ʤΤǡ
# ٤ȤϼưǥåƤ
#
# % perl hnf2tdf.pl [hnf dir] [tdf dir]
#
# äƤ뤳ȡ
#  + OK Ȥϥå
#  + NEW  CAT ν֤줫
#  + LNEW,LSUB  NEW*, SUB* 
#                 thanks to T-HERMES
#  + LSTRIKE  STRIKE* 
#  + FONT COLOR arg  COLOR arg 
#  + FONT SIZE arg  arg ˰פ BIG, SMALL ֤
#  + ȥȼ !, !#  #, ## 
#  + ALIAS 
#
# äͽ
#
# $Id: hnf2tdf.pl,v 1.1.1.1 2000/01/25 17:00:39 tom Exp $
################################################################

use strict;
use File::Path;

# 
my $hnf_dir = $ARGV[0] || "$ENV{HOME}/hnf";    # hnf Υǥ쥯ȥ
my $tdf_dir = $ARGV[1] || "$ENV{HOME}/diary";  # tdf Υǥ쥯ȥ

my $dispersion = 1;                            # ʬʤ 1ʤ 0

# 
print "hnf: $hnf_dir -> tdf: $tdf_dir\n";

opendir(DIR, $hnf_dir) || die "can't open dir : $hnf_dir";
if ($dispersion){                # ʬ
    while ($_ = readdir(DIR)){
	next unless (/^\d{4}/ && -d "$hnf_dir/$_");
	my $year = $_;
	
	opendir(MONTH_DIR, "$hnf_dir/$year") || die;
	while ($_ = readdir(MONTH_DIR)){
	    my $file = $_;
	    next unless (/^d\d{4}(\d{2})(\d{2})\.hnf$/ && -f "$hnf_dir/$year/$file");
	    my ($month, $day) = ($1, $2);
	    
	    # tdf ǥ쥯ȥ(ʤ)
	    mkpath("$tdf_dir/$year/$month", 1, 0755);
	    
	    # С
	    print "$year/$month/$day\n";
	    hnf2tdf("$hnf_dir/$year/$file", "$tdf_dir/$year/$month/$day.tdf");
	}
    }
} else {                         # 
    while ($_ = readdir(DIR)){
	my $file = $_;
	next unless (/^d(\d{4})(\d{2})(\d{2})\.hnf$/ && -f "$hnf_dir/$file");
	my ($year, $month, $day) = ($1, $2, $3);
	
	# tdf ǥ쥯ȥ(ʤ)
	mkpath("$tdf_dir/$year/$month", 1, 0755);
	# С
	print "$year/$month/$day\n";
	hnf2tdf("$hnf_dir/$file", "$tdf_dir/$year/$month/$day.tdf");
    }
}
exit(0);
################################################################
sub hnf2tdf($$)
{
    my ($hnf_file, $tdf_file) = @_;

    # hnf եɤ߹
    open(R, $hnf_file) || die;
    
    # tdf ե񤭤
    open(W, ">$tdf_file") || die;
    
    my $ok = 0;
    my $cat;
    my $font_patarn;
    my $font_size;
    my $font_attr;
    my $font_ins_command;
    while (<R>){
	if (/^OK/){
	    $ok = 1;
	} elsif (!$ok){
	    next;
	} else {
	    if (/^L(NEW|SUB|STRIKE)(.*)$/){
		$_ = "$1*$2\n";
	    } elsif (($font_patarn) = (/^FONT\s+(.*)$/)) { # thanks to T-HERMES
		if ($font_patarn =~ /^COLOR(.*)$/i) {
		    $_ = "COLOR$1\n";
		} elsif (($font_size, $font_attr) = ($font_patarn =~ /^SIZE\s+(\S+)(.*)$/i)) {
		    if ($font_size =~ /^\d+$/) {
			if ($font_size != 0) {
			    $font_size -= 3;	# default font size is <font size="3">
			    $font_size = "+" . $font_size  if ($font_size > 1);
			}
		    }
		    $font_ins_command = "SMALL"  if ($font_size =~ /^-/);
		    $font_ins_command = "BIG"    if ($font_size =~ /^\+/);
		    $font_size =~ s/^[-+](\d+)/$1/;
		    if ($font_size == 0) {
			$_ = "$font_attr\n";
		    } else {
			$_ = "$font_ins_command$font_attr\n"  if ($font_size--);
			$_ = "$font_ins_command+\n" . $_ . "/$font_ins_command\n"  while ($font_size--);
		    }
		    $font_ins_command = undef;
		}
	    } elsif (/^ALIAS(.*)$/) {
		$_ = "$1\n";
	    } elsif (/^!(#?)(.*)$/) {
		$_ = "#$1$2\n";
	    }
	    if (/^CAT/){
		$cat = $_;
	    } elsif (/^L?NEW/){
		print W $_;
		if ($cat){
		    print W $cat;
		    $cat = undef;
		}
	    } else {
		print W;
	    }
	}
    }
    close R;
    close W;
}
    
    
