/* Created RJudd August 30, 2002 */
/* SPAWARSYSCEN  */
/**********************************************************************
// For TASP VSIPL Documentation and Code neither the United States    /
// Government, the United States Navy, nor any of their employees,    /
// makes any warranty, express or implied, including the warranties   /
// of merchantability and fitness for a particular purpose, or        /
// assumes any legal liability or responsibility for the accuracy,    /
// completeness, or usefulness of any information, apparatus,         /
// product, or process disclosed, or represents that its use would    /
// not infringe privately owned rights                                /
**********************************************************************/
/* $Id: vsip_cchold_d.c,v 2.0 2003/02/22 15:18:39 judd Exp $ */

#include<vsip.h>
#include<vsip_cmviewattributes_d.h>
#include<vsip_cvviewattributes_d.h>
#include<vsip_ccholdattributes_d.h>

#define VI_CMCOLSUBVIEW_F(a_col, A, i,j,n) { \
          (a_col)->block  = (A)->block; \
          (a_col)->offset = (A)->offset + (i) * (A)->col_stride + (j) * (A)->row_stride; \
          (a_col)->length = (n); \
          (a_col)->stride = (A)->col_stride; }

#define VI_CMROWSUBVIEW_F(a_row, A, i,j,n) { \
          (a_row)->block  = (A)->block; \
          (a_row)->offset = (A)->offset + (i) * (A)->col_stride + (j) * (A)->row_stride; \
          (a_row)->length = (n); \
          (a_row)->stride = (A)->row_stride; }

static
int
VI_ccholesky_low_d(const vsip_cmview_d *A){
   int retval = 0;
   vsip_index j,k;
   vsip_length n = A->col_length;
   vsip_cvview_d aa_col,bb_col;
   vsip_cvview_d *a_col = &aa_col, *b_col =&bb_col;
   for(k=0; k<n; k++){
      /* for the diagonal a_kk must have zero imainary */
      vsip_scalar_d *a_kk = A->block->R->array + A->block->cstride * (A->offset + k * (A->row_stride + A->col_stride));
      if(*a_kk <= 0) retval++;
      *a_kk = (vsip_scalar_d)sqrt((double)*a_kk);
      VI_CMCOLSUBVIEW_F(a_col,A,k+1,k,n-k-1);
      {
         vsip_length m = a_col->length;
         vsip_scalar_d scale = *a_kk;
         vsip_scalar_d *aptr_re = a_col->block->R->array + a_col->offset * a_col->block->cstride;
         vsip_scalar_d *aptr_im = a_col->block->I->array + a_col->offset * a_col->block->cstride;
         vsip_stride a_str = a_col->stride * a_col->block->cstride;
         while(m-- > 0){
            *aptr_re /= scale; *aptr_im /= scale;
            aptr_re += a_str; aptr_im += a_str;
         }
      }
      for(j=k+1; j<n; j++){
         VI_CMCOLSUBVIEW_F(a_col,A,j,j,n-j);
         VI_CMCOLSUBVIEW_F(b_col,A,j,k,n-j);
         {
            vsip_length m = b_col->length;
            vsip_scalar_d *a_re_ptr = a_col->block->R->array  + a_col->block->cstride * a_col->offset;
            vsip_scalar_d *a_im_ptr = a_col->block->I->array  + a_col->block->cstride * a_col->offset;
            vsip_scalar_d *b_re_ptr = b_col->block->R->array  + b_col->block->cstride * b_col->offset;
            vsip_scalar_d *b_im_ptr = b_col->block->I->array  + b_col->block->cstride * b_col->offset;
            vsip_scalar_d re_scale = - *(A->block->R->array + A->block->cstride * (A->offset + k * A->row_stride + j * A->col_stride));
            vsip_scalar_d im_scale =   *(A->block->I->array + A->block->cstride * (A->offset + k * A->row_stride + j * A->col_stride));
            vsip_stride a_str = a_col->block->cstride * a_col->stride;
            vsip_stride b_str = b_col->block->cstride * b_col->stride;
            while(m-- >0){
               *a_re_ptr += *b_re_ptr * re_scale - *b_im_ptr * im_scale;
               *a_im_ptr += *b_re_ptr * im_scale + *b_im_ptr * re_scale;
                a_re_ptr += a_str; b_re_ptr += b_str;
                a_im_ptr += a_str; b_im_ptr += b_str;
            }
         }  
      }
   }
   return retval;
}

static
int
VI_ccholesky_upp_d(
        const vsip_cmview_d *A){
   int retval = 0;
   vsip_index j,k;
   vsip_length n = A->row_length;
   vsip_cvview_d aa_row,bb_row;
   vsip_cvview_d *a_row = &aa_row, *b_row = &bb_row;
   for(k=0; k<n; k++){
      /* for the diagonal a_kk must have zero imaginary */
      vsip_scalar_d *a_kk = A->block->R->array + A->block->cstride * (A->offset + k * (A->row_stride + A->col_stride));
      if(*a_kk <= 0) retval++;
      *a_kk = (vsip_scalar_d)sqrt((double)*a_kk);
      VI_CMROWSUBVIEW_F(a_row,A,k,k+1,n-k-1);
      {
         vsip_length m = a_row->length;
         vsip_scalar_d scale = *a_kk;
         vsip_scalar_d *aptr_re = a_row->block->R->array + a_row->offset * a_row->block->cstride;
         vsip_scalar_d *aptr_im = a_row->block->I->array + a_row->offset * a_row->block->cstride;
         vsip_stride a_str = a_row->stride * a_row->block->cstride;
         while(m-- > 0){
            *aptr_re /= scale; *aptr_im /= scale;
            aptr_re += a_str; aptr_im += a_str;
         }
      }
      for(j=k+1; j<n; j++){
         VI_CMROWSUBVIEW_F(a_row,A,j,j,n-j);
         VI_CMROWSUBVIEW_F(b_row,A,k,j,n-j);
         {
            vsip_length m = b_row->length;
            vsip_scalar_d *a_re_ptr = a_row->block->R->array  + a_row->block->cstride * a_row->offset;
            vsip_scalar_d *a_im_ptr = a_row->block->I->array  + a_row->block->cstride * a_row->offset;
            vsip_scalar_d *b_re_ptr = b_row->block->R->array  + b_row->block->cstride * b_row->offset;
            vsip_scalar_d *b_im_ptr = b_row->block->I->array  + b_row->block->cstride * b_row->offset;
            vsip_scalar_d re_scale = - *(A->block->R->array + A->block->cstride * (A->offset + j * A->row_stride + k * A->col_stride));
            vsip_scalar_d im_scale =   *(A->block->I->array + A->block->cstride * (A->offset + j * A->row_stride + k * A->col_stride));
            vsip_stride a_str = a_row->block->cstride * a_row->stride;
            vsip_stride b_str = b_row->block->cstride * b_row->stride;
            while(m-- >0){
               *a_re_ptr += *b_re_ptr * re_scale - *b_im_ptr * im_scale;
               *a_im_ptr += *b_re_ptr * im_scale + *b_im_ptr * re_scale;
                a_re_ptr += a_str; b_re_ptr += b_str;
                a_im_ptr += a_str; b_im_ptr += b_str;
            }
         }
      }
   }
   return retval;
}

int
vsip_cchold_d(
          vsip_cchol_d* chol,
          const vsip_cmview_d *A)
{
   int retval = 0;
   chol->matrix = A;
   if(chol->uplo == VSIP_TR_LOW){
      retval = VI_ccholesky_low_d(A);
   } else { /* must be vsip_tr_upp */
      retval = VI_ccholesky_upp_d(A);
   } 
   return retval;
}
