/* Copyright (c) 1998 Joe Rumsey (mrogre@mediaone.net) */
#include "copyright.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <math.h>
#include <pwd.h>
#include <sys/types.h>
#include "Wlib.h"
#include "data.h"
#include "defs.h"
#include "proto.h"
#include "images.h"

#define BORDER 1

void print_usage()
{
    printf("\
Tanked client v%d.%02d\n\
Copyright (c) 1995 Joe Rumsey\n\
\n\
Usage:\n\
tanked [options] [server]\n\
Options:\n\
-h <server> (Default esoteric.agron.iastate.edu)\n\
-p <port>   (Default 12592)\n\
-n <name>   (Default guest)\n\
-r <file>   Defaults file (default ~/.tankedrc)\n\
%s\n\
", CLIENTVERSION/100, CLIENTVERSION%100,
#ifdef UDP_PROXY
		   "  -P <proxy_server> <proxy_port>"
#else
		   ""
#endif
		   );
}

char *getLogin()
{
    struct passwd *pwd;

    if(!(pwd = getpwuid(getuid()))) {
		return "Bozo";
    } else {
		return pwd->pw_name;
    }
}

int
main(int argc, char **argv)
{
    int ac, i, j, cport=0;
    char *cname = 0, *cserver=0, *deffile = 0;
    int start;
    char *dpyname=0;

    for(ac = 1; ac < argc; ac++) {
		if(*argv[ac] == '-') {
			if(strcmp(argv[ac], "-display") == 0 && (ac+1 < argc)) {
				dpyname = argv[++ac];
			} else if(strcmp(argv[ac], "-h")==0 && (ac+1 < argc)) {
				cserver = argv[++ac];
			} else if(strcmp(argv[ac], "-p")==0 && (ac+1 < argc)) {
				cport = atoi(argv[++ac]);
			} else if(strcmp(argv[ac], "-n")==0 && (ac+1 < argc)) {
				cname = argv[++ac];
			} else if(strcmp(argv[ac], "-r")== 0 && (ac+1 < argc)) {
				deffile = argv[++ac];
#ifdef UDP_PROXY
			} else if(strcmp(argv[ac], "-P")==0 && (ac+2 < argc)) {
				proxyServer = argv[++ac];
				proxyPort = atoi(argv[++ac]);
				useUdpProxy = 1;
#endif
			} else {
				print_usage();
				exit(0);
			}
		} else {
			server = argv[ac];
		}
    }

    for(i=0;i<MAXPLAYERS;i++) {
		players[i].p_status = PEMPTY;
		players[i].p_num = i;
		players[i].p_char = (i < 10) ? i+'0' : i-10+'a';
		for(j=0;j<MINESPERPLAYER;j++)
			mines[i*MINESPERPLAYER+j].mi_status = MIEMPTY;
    }

    read_defaults(deffile);

    callServer(cport ? cport : port, cserver ? cserver : server);
    sendLogin(cname ? cname : name, getLogin());

    W_Initialize(dpyname);
    baseWin = W_MakeWindow("Tanked", 0, 0, WINWIDTH+MAXMAPSIZE*2, WINHEIGHT + 33 * W_Textheight + BORDER*4, 
						   0,"bomb here",0, W_White);
    cwin = W_MakeWindow("combat", 0, 0, WINWIDTH, WINHEIGHT, baseWin, 0, 0, W_White);
    dashwin = W_MakeWindow("dash", 0, WINHEIGHT, 80*W_Textwidth+BORDER, 3*(W_Textheight+2), 
						   baseWin, 0, 1, W_White);
    messwin[MW_JOINED] = W_MakeScrollingWindow("message", 0, WINHEIGHT+BORDER*2+W_Textheight+3*(W_Textheight+2), 
											   80, 28, baseWin, "xterm", BORDER);
    messwin[MW_INDIV] = W_MakeScrollingWindow("indiv", 0, WINHEIGHT+BORDER*2+W_Textheight+3*(W_Textheight+2),
											  80, 5, baseWin, "xterm", BORDER);
    messwin[MW_TEAM] = W_MakeScrollingWindow("team", 0, WINHEIGHT+BORDER*2+6*W_Textheight+3*(W_Textheight+2),
											 80,10, baseWin, "xterm", BORDER);
    messwin[MW_ALL] = W_MakeScrollingWindow("all", 0, WINHEIGHT+BORDER*2+16*W_Textheight+3*(W_Textheight+2),
											80,13, baseWin, "xterm", BORDER);
    typewin = W_MakeTextWindow("send", 0, WINHEIGHT+3*(W_Textheight+2)+BORDER, 80, 1, baseWin, "xterm", BORDER);
    playerwin = W_MakeTextWindow("player", 80*W_Textwidth + BORDER*2, WINHEIGHT, 60, 33, baseWin, 0, BORDER);
    mapwin = W_MakeWindow("map", WINWIDTH, 0,
						  80, 80,
						  baseWin, 0, BORDER, W_Grey);
    win3d = W_MakeWindow("threed", 0, 0, 320, 200, 0, 0, 0, W_White);
    W_Buffer(mapwin, 0);
    W_MapWindow(mapwin);

	/*
    W_Buffer(win3d, 1);
    W_MapWindow(win3d);
	*/

    for(i=0;i<MW_MAX;i++)
		W_Buffer(messwin[i], 0);
    W_Buffer(typewin, 0);
    W_Buffer(playerwin, 0);
    W_Buffer(dashwin, 0);

    W_MapWindow(baseWin);
    W_MapWindow(cwin);
    if(!splitWindows)
		W_MapWindow(messwin[MW_JOINED]);
    else {
		W_MapWindow(messwin[MW_ALL]);
		W_MapWindow(messwin[MW_TEAM]);
		W_MapWindow(messwin[MW_INDIV]);
    }

    W_MapWindow(typewin);
    W_MapWindow(playerwin);
    W_MapWindow(dashwin);

    for(i=0;i<MW_MAX;i++)
		W_DefineTextCursor(messwin[i]);
    W_DefineTextCursor(typewin);

    W_SetRGB16(W_Green2, 0, 32000, 0);
    W_SetRGB16(W_Blue, 0x7777, 0x7777, 0xffff);

    init_terrain();

    myTankImg = getImage(I_TANK);
    teamTankImg[0] = getImage(I_BLUETANK);
    teamTankImg[1] = getImage(I_REDTANK);
    expImg = getImage(I_EXPLOSION);
    mineImg = getImage(I_MINE);
    mineExpImg = getImage(I_MEXP);

    shellImg = getImage(I_SHELL);
    flagImg[0] = getImage(I_FLAG1);
    flagImg[1] = getImage(I_FLAG2);

    W_Flush();

    W_ClearWindow(baseWin);

    srand(time(0));

    inittrigtables();
    start = time(0);

    if(read_map()) {
		while(!quit) {
			doServer();

			if(me->p_status != POUTFIT) {
				do_input();
				do_redraw();
				if(redrawMotd && W_IsMapped(motdwin))
					display_motd();
				do_dash(0);
			} else {
				do_outfit();
				if(redrawMotd)
					display_motd();
			}
		
			if(redrawmap) {
				redraw_map();
				redrawmap = 0;
			}

			check_playerwin_updates();
			counter++;
		}
    } else {
		printf("Error reading map!\n");
    }

    if(time(0)-start > 0) {
		printf("Total frames: %d\n", counter);
		printf("Frames/sec: %f\n", (double)counter/(double)(time(0)-start));
		printf("Total bytes: %d, Bytes/sec: %ld, Bytes/frame: %d\n",
			   totalread, totalread/(time(0)-start), totalread/counter);
    }
    W_UnmapWindow(baseWin);
    exit(0);
}


