(* SwiftSurf
 * Sebastien Ailleret *)

(* type for describing a profile *)
type profile = {
    mutable auth_pass : string;
    mutable forbidden_urls : (string list * string) list;
    mutable allowed_urls : string list * string;
    mutable methods : string list;
    mutable canCONNECT : bool;
    mutable allCONNECT : bool;
    mutable req_1 : bool;
    mutable req_2 : bool;
    mutable req_in : bool;
    mutable req_out : bool;
    mutable ans_1 : bool;
    mutable ans_2 : bool;
    mutable ans_in : bool;
    mutable ans_out : bool
  }

(* state of a connexion *)
type state =
  | STARTING
  | DNS
  | DNSDONE of Unix.inet_addr
  | CONNECTING
  | ALIVE
  | FINISHING

(* what are we parsing now *)
type parse =
  | CMD_LINE
  | WAIT_DNS
  | HEADERS
  | HEADERSCONNECT
  | CONTENT
  | END

(* one connexion *)
type connexion = {
    client : Unix.file_descr;
    from : string;
    mutable timeout : float;
    mutable server : Unix.file_descr;
    mutable state : state;
    mutable auth : string;
    mutable prof : profile;
    mutable host : string * int;
    mutable need_proxy : (Unix.sockaddr * string option) option;
    mutable url : string;
    mutable proto_str : string;
    mutable meth : string;
    mutable read_req : Activebuffer.t;
    mutable write_req : Activebuffer.t;
    mutable size_req : int; (* avoid too much memory consumption *)
      (* give the number of byte we still accept to read *)
      (* this number must always remain < buf_size *)
    mutable state_req : parse;
    mutable len_post : int;
    mutable read_ans : Activebuffer.t;
    mutable write_ans : Activebuffer.t;
    mutable size_ans : int;
    mutable state_ans : parse
  }
(* value of the timeout *)
val timeout : float ref

(* maximum number of connections : -1 means no limit *)
val max_conns : int ref

(* what kind of output is required *)
val stats : int ref
val debug : int ref

(* precise config : should not change *)
val buf_size : int
val dns_cache_size : int

(* make an answer *)
val make_ans : string -> string-> string -> string

(* standard answers *)
val host_unreach : string
val invalid_req : string
val unknown_host : string
val secure_forbid : string
val need_auth : string
val not_avail : string

(* where is the config file *)
val conf_file_dir : string ref
