/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include "sgtk-stock.h"

/*** constant definitions ****************************************************/

static const GtkStockItem items[] = {
  { SGTK_STOCK_PREVIOUS, N_("_Previous"), 0, 0, NULL },
  { SGTK_STOCK_NEXT, N_("_Next"), 0, 0, NULL }
};

/*** implementation **********************************************************/

void
sgtk_stock_init (void)
{
  const sGtkStockIcon icons[] = {
    SGTK_STOCK_ICON_FROM_STOCK(SGTK_STOCK_PREVIOUS, GTK_STOCK_GO_BACK),
    SGTK_STOCK_ICON_FROM_STOCK(SGTK_STOCK_NEXT, GTK_STOCK_GO_FORWARD),
    SGTK_STOCK_ICON_END
  };

  sgtk_stock_register_icons(icons);
  gtk_stock_add_static(items, G_N_ELEMENTS(items));
}

void
sgtk_stock_register_icons (const sGtkStockIcon icons[])
{
  GtkIconFactory *factory;
  int i;

  g_return_if_fail(icons != NULL);

  factory = gtk_icon_factory_new();
  gtk_icon_factory_add_default(factory);

  for (i = 0; icons[i].stock_id; i++)
    {
      GtkIconSet *icon_set;

      switch (icons[i].source_type)
	{
	case SGTK_STOCK_SOURCE_STOCK:
	  icon_set = gtk_icon_factory_lookup_default(icons[i].source_stock_id);
	  gtk_icon_set_ref(icon_set);
	  break;

	case SGTK_STOCK_SOURCE_FILE:
	  {
	    GdkPixbuf *pixbuf;
	    GError *err = NULL;
	    
	    pixbuf = gdk_pixbuf_new_from_file(icons[i].source_file_name, &err);
	    if (pixbuf)
	      {
		icon_set = gtk_icon_set_new_from_pixbuf(pixbuf);
		g_object_unref(pixbuf);
	      }
	    else
	      {
		g_warning(_("error loading image: %s"), err->message);
		g_error_free(err);
		icon_set = gtk_icon_set_new();
	      }
	  }
	  break;
	  
	case SGTK_STOCK_SOURCE_THEME:
	  {
	    GtkIconSource *icon_source;

	    icon_set = gtk_icon_set_new();
	    icon_source = gtk_icon_source_new();
	    gtk_icon_source_set_icon_name(icon_source, icons[i].source_icon_name);
	    gtk_icon_set_add_source(icon_set, icon_source);
	    gtk_icon_source_free(icon_source);
	  }
	  break;

	default:
	  g_return_if_reached();
	}
      
      gtk_icon_factory_add(factory, icons[i].stock_id, icon_set);
      gtk_icon_set_unref(icon_set);
    }

  g_object_unref(factory);
}
