source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that parameter passing by reference works with virtual declarations

# expected output:

## z(0) = 0
## z(1) = 1
## z(2) = 2
## z(3) = 3
## z(4) = 4
## z(5) = 5
## Z(0) = 0
## Z(1) = 1
## Z(2) = 2
## Z(3) = 3
## Z(4) = 4
## Z(5) = 5

class a {}
proc a::a {this} {}
proc a::~a {this} {}
virtual proc a::f {this a} {}
virtual proc a::g {this a}
virtual proc a::h {this a} {
    upvar $a d
    set d(0) 0
}
virtual proc a::i {this a} {}
virtual proc a::j {this a}
virtual proc a::k {this a} {}
class b {}
proc b::b {this} a {} {}
proc b::~b {this} {}
proc b::f {this a} {
    upvar $a d
    set d(1) 1
}
proc b::g {this a} {
    upvar $a d
    set d(2) 2
}
virtual proc b::i {this a} {}
virtual proc b::j {this a}
virtual proc b::k {this a} {
    upvar $a d
    set d(3) 3
}
class c {}
proc c::c {this} b {} {}
proc c::~c {this} {}
proc c::i {this a} {
    upvar $a d
    set d(4) 4
}
proc c::j {this a} {
    upvar $a d
    set d(5) 5
}
set o [new c]
a::f $o z
a::g $o z
a::h $o z
a::i $o z
a::j $o z
a::k $o z
printArrays z

class A {
    proc A {this} {}
    proc ~A {this} {}
    virtual proc f {this a} {}
    virtual proc g {this a}
    virtual proc h {this a} {
        upvar $a d
        set d(0) 0
    }
    virtual proc i {this a} {}
    virtual proc j {this a}
    virtual proc k {this a} {}
}
class B {
    proc B {this} A {} {}
    proc ~B {this} {}
    proc f {this a} {
        upvar $a d
        set d(1) 1
    }
    proc g {this a} {
        upvar $a d
        set d(2) 2
    }
    virtual proc i {this a} {}
    virtual proc j {this a}
    virtual proc k {this a} {
        upvar $a d
        set d(3) 3
    }
}
class C {
    proc C {this} B {} {}
    proc ~C {this} {}
    proc i {this a} {
        upvar $a d
        set d(4) 4
    }
    proc j {this a} {
        upvar $a d
        set d(5) 5
    }
}
set o [new C]
A::f $o Z
A::g $o Z
A::h $o Z
A::i $o Z
A::j $o Z
A::k $o Z
printArrays Z
