foreach name [array names env STOOOP*] {unset env($name)}                                ;# reset any existing environment variables
set env(STOOOPCHECKDATA) 1
source stooop.tcl
namespace import stooop::*

### verify member data checking when "array set" is used

## can't set "b::(1,m)": class access violation in procedure ::a::p
## can't set "b::(n)": class access violation in procedure ::a::q
## can't set "B::(2,m)": class access violation in procedure ::A::p
## can't set "B::(n)": class access violation in procedure ::A::q
## can't set "c::e::(3,m)": class access violation in procedure ::c::d::p
## can't set "c::e::(n)": class access violation in procedure ::c::d::q
## can't set "C::E::(4,m)": class access violation in procedure ::C::D::p
## can't set "C::E::(n)": class access violation in procedure ::C::D::q
## can't set "C::E::(4,m)": class access violation in procedure ::C::D::p
## can't set "C::E::(n)": class access violation in procedure ::C::D::q

class a {}
proc a::a {this} {}
proc a::~a {this} {}
proc a::p {this} {
    array set b:: "$this,m 0"
}
proc a::q {this} {
    array set b:: {n 0}
}
set o [new a]
class b {}
array set b:: "$o,m 0 n 0"
catch {a::p $o} message; puts $message
catch {a::q $o} message; puts $message
delete $o

class A {
    proc A {this} {}
    proc ~A {this} {}
    proc p {this} {
        array set B:: "$this,m 0"
    }
    proc q {this} {
        array set B:: {n 0}
    }
}
set o [new A]
class B {
    array set B:: "$o,m 0 n 0"
}
class A {
    catch {p $o} message; puts $message
    catch {q $o} message; puts $message
}
delete $o

class c {}
class c::d {}
proc c::d::d {this} {}
proc c::d::~d {this} {}
proc c::d::p {this} {
    array set c::e:: "$this,m 0"
}
proc c::d::q {this} {
    array set c::e:: {n 0}
}
class c::e {}
set o [new c::d]
array set c::e:: "$o,m 0 n 0"
catch {c::d::p $o} message; puts $message
catch {c::d::q $o} message; puts $message
delete $o

class C {
    class D {
        proc D {this} {}
        proc ~D {this} {}
        proc p {this} {
            array set C::E:: "$this,m 0"
        }
        proc q {this} {
            array set C::E:: {n 0}
        }
    }
    set ::o [new D]
    class E {
        array set C::E:: "$o,m 0 n 0"
    }
    class D {
        catch {p $o} message; puts $message
        catch {q $o} message; puts $message
    }
}
catch {C::D::p $o} message; puts $message
catch {C::D::q $o} message; puts $message
delete $o
