foreach name [array names env STOOOP*] {unset env($name)}                                ;# reset any existing environment variables
set env(STOOOPCHECKPROCEDURES) 1
source stooop.tcl
namespace import stooop::*

### verify pure interface class object creation in procedure checking debug mode

## a::a 1
## class ::a with pure virtual procedures should not be instanciated
## A::A 2
## class ::A with pure virtual procedures should not be instanciated
## c::c 3
## class ::b::c with pure virtual procedures should not be instanciated
## C::C 4
## class ::B::C with pure virtual procedures should not be instanciated
## class ::B::C with pure virtual procedures should not be instanciated

class a {}
proc a::a {this} {
    puts "a::a $this"
}
proc a::~a {this} {}
virtual proc a::p {this} {}
set o [new a]
delete $o
virtual proc a::q {this}
catch {new a} message
puts $message

class A {
    proc A {this} {
        puts "A::A $this"
    }
    proc ~A {this} {}
    virtual proc p {this} {}
}
set o [new A]
delete $o
class A {
    virtual proc q {this}
}
catch {new A} message
puts $message

class b {}
class b::c {}
proc b::c::c {this} {
    puts "c::c $this"
}
proc b::c::~c {this} {}
virtual proc b::c::p {this} {}
set o [new b::c]
delete $o
virtual proc b::c::q {this}
catch {new b::c} message
puts $message

class B {
    class C {
        proc C {this} {
            puts "C::C $this"
        }
        proc ~C {this} {}
        virtual proc p {this} {}
    }
    set o [new C]
    delete $o
    class C {
        virtual proc q {this}
    }
    catch {new C} message
    puts $message
}
catch {new B::C} message
puts $message
