foreach name [array names env STOOOP*] {unset env($name)}                                ;# reset any existing environment variables
set env(STOOOPCHECKPROCEDURES) 1
source stooop.tcl
namespace import stooop::*

### verify virtual member procedure checking in procedure checking debug mode

## b::p 1
## b::q 1
## a::r 1
## b::p 1
## b::q 1
## 1 is not a valid object identifier
## 1 is not a valid object identifier
## 1 is not a valid object identifier
## 1 is not a valid object identifier
## 1 is not a valid object identifier

## B::p 2
## B::q 2
## A::r 2
## B::p 2
## B::q 2
## 2 is not a valid object identifier
## 2 is not a valid object identifier
## 2 is not a valid object identifier
## 2 is not a valid object identifier
## 2 is not a valid object identifier

## e::p 3
## e::q 3
## d::r 3
## e::p 3
## e::q 3
## 3 is not a valid object identifier
## 3 is not a valid object identifier
## 3 is not a valid object identifier
## 3 is not a valid object identifier
## 3 is not a valid object identifier

## E::p 4
## E::q 4
## D::r 4
## E::p 4
## E::q 4
## 4 is not a valid object identifier
## 4 is not a valid object identifier
## 4 is not a valid object identifier
## 4 is not a valid object identifier
## 4 is not a valid object identifier
## E::p 5
## E::q 5
## D::r 5
## E::p 5
## E::q 5
## 5 is not a valid object identifier
## 5 is not a valid object identifier
## 5 is not a valid object identifier
## 5 is not a valid object identifier
## 5 is not a valid object identifier

class a {}
proc a::a {this} {}
proc a::~a {this} {}
virtual proc a::p {this} {
    puts "a::p $this"
}
virtual proc a::q {this}
virtual proc a::r {this} {
    puts "a::r $this"
}
class b {}
proc b::b {this} a {} {}
proc b::~b {this} {}
proc b::p {this} {
    puts "b::p $this"
}
proc b::q {this} {
    puts "b::q $this"
}
set o [new b]
a::p $o
a::q $o
a::r $o
b::p $o
b::q $o
delete $o
catch {a::p $o} message; puts $message
catch {a::q $o} message; puts $message
catch {a::r $o} message; puts $message
catch {b::p $o} message; puts $message
catch {b::q $o} message; puts $message

class A {
    proc A {this} {}
    proc ~A {this} {}
    virtual proc p {this} {
        puts "A::p $this"
    }
    virtual proc q {this}
    virtual proc r {this} {
        puts "A::r $this"
    }
}
class B {
    proc B {this} A {} {}
    proc ~B {this} {}
    proc p {this} {
        puts "B::p $this"
    }
    proc q {this} {
        puts "B::q $this"
    }
}
set o [new B]
A::p $o
A::q $o
A::r $o
B::p $o
B::q $o
delete $o
catch {A::p $o} message; puts $message
catch {A::q $o} message; puts $message
catch {A::r $o} message; puts $message
catch {B::p $o} message; puts $message
catch {B::q $o} message; puts $message

class c {}
class c::d {}
proc c::d::d {this} {}
proc c::d::~d {this} {}
virtual proc c::d::p {this} {
    puts "d::p $this"
}
virtual proc c::d::q {this}
virtual proc c::d::r {this} {
    puts "d::r $this"
}
class c::e {}
proc c::e::e {this} c::d {} {}
proc c::e::~e {this} {}
proc c::e::p {this} {
    puts "e::p $this"
}
proc c::e::q {this} {
    puts "e::q $this"
}
set o [new c::e]
c::d::p $o
c::d::q $o
c::d::r $o
c::e::p $o
c::e::q $o
delete $o
catch {c::d::p $o} message; puts $message
catch {c::d::q $o} message; puts $message
catch {c::d::r $o} message; puts $message
catch {c::e::p $o} message; puts $message
catch {c::e::q $o} message; puts $message

class C {
    class D {
        proc D {this} {}
        proc ~D {this} {}
        virtual proc p {this} {
            puts "D::p $this"
        }
        virtual proc q {this}
        virtual proc r {this} {
            puts "D::r $this"
        }
    }
    class E {
        proc E {this} C::D {} {}
        proc ~E {this} {}
        proc p {this} {
            puts "E::p $this"
        }
        proc q {this} {
            puts "E::q $this"
        }
    }
    set o [new E]
    D::p $o
    D::q $o
    D::r $o
    E::p $o
    E::q $o
    delete $o
    catch {D::p $o} message; puts $message
    catch {D::q $o} message; puts $message
    catch {D::r $o} message; puts $message
    catch {E::p $o} message; puts $message
    catch {E::q $o} message; puts $message
}
set o [new C::E]
C::D::p $o
C::D::q $o
C::D::r $o
C::E::p $o
C::E::q $o
delete $o
catch {C::D::p $o} message; puts $message
catch {C::D::q $o} message; puts $message
catch {C::D::r $o} message; puts $message
catch {C::E::p $o} message; puts $message
catch {C::E::q $o} message; puts $message
