foreach name [array names env STOOOP*] {unset env($name)}                                ;# reset any existing environment variables
set env(STOOOPCHECKPROCEDURES) 1
source stooop.tcl
namespace import stooop::*

### verify regular member procedure checking within class hierarchy in procedure checking debug mode

# expected output:

## class b of ::b::p procedure not an ancestor of object 1 class a
## class c of ::c::p procedure not an ancestor of object 1 class a
## class c of ::c::p procedure not an ancestor of object 2 class b
## class b of ::b::p procedure not an ancestor of object 4 class a
## class c of ::c::p procedure not an ancestor of object 4 class a
## class c of ::c::p procedure not an ancestor of object 5 class b
## class d::f of ::d::f::p procedure not an ancestor of object 7 class d::e
## class d::g of ::d::g::p procedure not an ancestor of object 7 class d::e
## class d::g of ::d::g::p procedure not an ancestor of object 8 class d::f
## class C::E of ::C::E::p procedure not an ancestor of object 10 class C::D
## class C::F of ::C::F::p procedure not an ancestor of object 10 class C::D
## class C::F of ::C::F::p procedure not an ancestor of object 11 class C::E
## class C::E of ::C::E::p procedure not an ancestor of object 13 class C::D
## class C::F of ::C::F::p procedure not an ancestor of object 13 class C::D
## class C::F of ::C::F::p procedure not an ancestor of object 14 class C::E

class a {}
proc a::a {this} {}
proc a::~a {this} {}
proc a::p {this} {}
class b {}
proc b::b {this} a {} {}
proc b::~b {this} {}
proc b::p {this} {}
class c {}
proc c::c {this} b {} {}
proc c::~c {this} {}
proc c::p {this} {}
set o [new a]
a::p $o
catch {b::p $o} message
puts $message
catch {c::p $o} message
puts $message
delete $o
set o [new b]
a::p $o
b::p $o
catch {c::p $o} message
puts $message
delete $o
set o [new c]
a::p $o
b::p $o
c::p $o
delete $o

class a {
    proc a {this} {}
    proc ~a {this} {}
    proc p {this} {}
}
class b {
    proc b {this} a {} {}
    proc ~b {this} {}
    proc p {this} {}
}
class c {
    proc c {this} b {} {}
    proc ~c {this} {}
    proc p {this} {}
}
set o [new a]
a::p $o
catch {b::p $o} message
puts $message
catch {c::p $o} message
puts $message
delete $o
set o [new b]
a::p $o
b::p $o
catch {c::p $o} message
puts $message
delete $o
set o [new c]
a::p $o
b::p $o
c::p $o
delete $o

class d {}
class d::e {}
proc d::e::e {this} {}
proc d::e::~e {this} {}
proc d::e::p {this} {}
class d::f {}
proc d::f::f {this} d::e {} {}
proc d::f::~f {this} {}
proc d::f::p {this} {}
class d::g {}
proc d::g::g {this} d::f {} {}
proc d::g::~g {this} {}
proc d::g::p {this} {}
set o [new d::e]
d::e::p $o
catch {d::f::p $o} message
puts $message
catch {d::g::p $o} message
puts $message
delete $o
set o [new d::f]
d::e::p $o
d::f::p $o
catch {d::g::p $o} message
puts $message
delete $o
set o [new d::g]
d::e::p $o
d::f::p $o
d::g::p $o
delete $o

class C {
    class D {
        proc D {this} {}
        proc ~D {this} {}
        proc p {this} {}
    }
    class E {
        proc E {this} C::D {} {}
        proc ~E {this} {}
        proc p {this} {}
    }
    class F {
        proc F {this} C::E {} {}
        proc ~F {this} {}
        proc p {this} {}
    }
    set o [new D]
    D::p $o
    catch {E::p $o} message
    puts $message
    catch {F::p $o} message
    puts $message
    delete $o
    set o [new E]
    D::p $o
    E::p $o
    catch {F::p $o} message
    puts $message
    delete $o
    set o [new F]
    D::p $o
    E::p $o
    F::p $o
    delete $o
}
set o [new C::D]
C::D::p $o
catch {C::E::p $o} message
puts $message
catch {C::F::p $o} message
puts $message
delete $o
set o [new C::E]
C::D::p $o
C::E::p $o
catch {C::F::p $o} message
puts $message
delete $o
set o [new C::F]
C::D::p $o
C::E::p $o
C::F::p $o
delete $o
