source stooop.tcl
namespace import stooop::*

### check that virtual procedure invocations from base class constructor behave as in C++

# expected output:

## a::f 1 x
## a::g 1 x {y z}
## 1
## 1

## A::f 2 x
## A::g 2 x {y z}
## 1
## 1
## A::f 3 x
## A::g 3 x {y z}
## 1
## 1

class z {}
class z::a {}
proc z::a::a {this} {
    z::a::f $this x
    z::a::g $this x {y z}
    # pure virtual invocations behavior is undefined
    puts [catch {z::a::h $this x}]
    puts [catch {z::a::i $this x {y z}}]
}
proc z::a::~a {this} {}
virtual proc z::a::f {this p} {
    puts "a::f $this $p"
}
virtual proc z::a::g {this p args} {
    puts "a::g $this $p $args"
}
virtual proc z::a::h {this p}
virtual proc z::a::i {this p args}
class z::b {}
proc z::b::b {this} z::a {} {}
proc z::b::~b {this} {}
virtual proc z::b::f {this p} {
    puts "b::f $this $p"
}
virtual proc z::b::g {this p args} {
    puts "b::g $this $p $args"
}
virtual proc z::b::h {this p} {
    puts "b::h $this $p"
}
proc z::b::i {this p args} {
    puts "b::i $this $p $args"
}
new z::b

class Z {
    class A {
        proc A {this} {
            f $this x
            g $this x {y z}
            # pure virtual invocations behavior is undefined
            puts [catch {A::h $this x}]
            puts [catch {A::i $this x {y z}}]
        }
        proc ~A {this} {}
        virtual proc f {this p} {
            puts "A::f $this $p"
        }
        virtual proc g {this p args} {
            puts "A::g $this $p $args"
        }
        virtual proc h {this p}
        virtual proc i {this p args}
    }
    class B {
        proc B {this} Z::A {} {}
        proc ~B {this} {}
        virtual proc f {this p} {
            puts "B::f $this $p"
        }
        virtual proc g {this p args} {
            puts "B::g $this $p $args"
        }
        virtual proc h {this p} {
            puts "B::h $this $p"
        }
        proc i {this p args} {
            puts "B::i $this $p $args"
        }
    }
    new B
}
new Z::B
