source parray.tcl
source stooop.tcl
namespace import stooop::*

### check normal and user defined cloning operation with multiple inheritance and member objects

# expected output:

## z::a::(1,_derived) = ::z::d
## z::a::(1,m) = z
## z::a::(3,_derived) = ::z::d
## z::a::(3,m) = z
## z::b::(1,_derived) = ::z::d
## z::b::(1,n) = z
## z::b::(3,_derived) = ::z::d
## z::b::(3,n) = z
## z::c::(1,O) = 2
## z::c::(1,_derived) = ::z::e
## z::c::(1,o) = 1 2
## z::c::(3,O) = 4
## z::c::(3,_derived) = ::z::e
## z::c::(3,o) = 1 2
## z::d::(1,_derived) = ::z::e
## z::d::(1,p) = z
## z::d::(3,_derived) = ::z::e
## z::d::(3,p) = z
## z::e::(1,q) = z
## z::e::(3,q) = z
## z::f::(2,x) = 0
## z::f::(4,x) = 0

## A::(5,_derived) = ::Z::D
## A::(5,m) = z
## A::(7,_derived) = ::Z::D
## A::(7,m) = z
## B::(5,_derived) = ::Z::D
## B::(5,n) = z
## B::(7,_derived) = ::Z::D
## B::(7,n) = z
## C::(5,O) = 6
## C::(5,_derived) = ::Z::E
## C::(5,o) = 1 2
## C::(7,O) = 8
## C::(7,_derived) = ::Z::E
## C::(7,o) = 1 2
## D::(5,_derived) = ::Z::E
## D::(5,p) = z
## D::(7,_derived) = ::Z::E
## D::(7,p) = z
## E::(5,q) = z
## E::(7,q) = z
## F::(6,x) = 0
## F::(8,x) = 0

## Z::A::(11,_derived) = ::Z::D
## Z::A::(11,m) = z
## Z::A::(5,_derived) = ::Z::D
## Z::A::(5,m) = z
## Z::A::(7,_derived) = ::Z::D
## Z::A::(7,m) = z
## Z::A::(9,_derived) = ::Z::D
## Z::A::(9,m) = z
## Z::B::(11,_derived) = ::Z::D
## Z::B::(11,n) = z
## Z::B::(5,_derived) = ::Z::D
## Z::B::(5,n) = z
## Z::B::(7,_derived) = ::Z::D
## Z::B::(7,n) = z
## Z::B::(9,_derived) = ::Z::D
## Z::B::(9,n) = z
## Z::C::(11,O) = 12
## Z::C::(11,_derived) = ::Z::E
## Z::C::(11,o) = 1 2
## Z::C::(5,O) = 6
## Z::C::(5,_derived) = ::Z::E
## Z::C::(5,o) = 1 2
## Z::C::(7,O) = 8
## Z::C::(7,_derived) = ::Z::E
## Z::C::(7,o) = 1 2
## Z::C::(9,O) = 10
## Z::C::(9,_derived) = ::Z::E
## Z::C::(9,o) = 1 2
## Z::D::(11,_derived) = ::Z::E
## Z::D::(11,p) = z
## Z::D::(5,_derived) = ::Z::E
## Z::D::(5,p) = z
## Z::D::(7,_derived) = ::Z::E
## Z::D::(7,p) = z
## Z::D::(9,_derived) = ::Z::E
## Z::D::(9,p) = z
## Z::E::(11,q) = z
## Z::E::(5,q) = z
## Z::E::(7,q) = z
## Z::E::(9,q) = z
## Z::F::(10,x) = 0
## Z::F::(12,x) = 0
## Z::F::(6,x) = 0
## Z::F::(8,x) = 0

class z {}
class z::a {}
proc z::a::a {this p} {
    set ($this,m) $p
}
class z::b {}
proc z::b::b {this p} {
    set ($this,n) $p
}
class z::c {}
proc z::c::c {this p q r} z::a {$p} z::b {$q} {
    set ($this,o) $r
    set ($this,O) [new z::f]
}
proc z::c::c {this copy} z::a {$z::a::($copy,m)} z::b 1 {
    set ($this,o) $($copy,o)
    set ($this,O) [new z::f]
}
class z::d {}
proc z::d::d {this p q r} z::a {$p} z::b {$q} {
    set ($this,p) $p
}
class z::e {}
proc z::e::e {this p q r} z::c {$p $q $r} z::d {$q $q $r} {
    set ($this,q) $q
}
class z::f {}
proc z::f::f {this} {
    set ($this,x) 0
}
new [new z::e {x y} z {1 2}]
printArrays z::a:: z::b:: z::c:: z::d:: z::e:: z::f::

class Z {
    class A {
        proc A {this p} {
            set ($this,m) $p
        }
    }
    class B {
        proc B {this p} {
            set ($this,n) $p
        }
    }
    class C {
        proc C {this p q r} Z::A {$p} Z::B {$q} {
            set ($this,o) $r
            set ($this,O) [new Z::F]
        }
        proc C {this copy} Z::A {$Z::A::($copy,m)} Z::B 1 {
            set ($this,o) $($copy,o)
            set ($this,O) [new Z::F]
        }
    }
    class D {
        proc D {this p q r} Z::A {$p} Z::B {$q} {
            set ($this,p) $p
        }
    }
    class E {
        proc E {this p q r} Z::C {$p $q $r} Z::D {$q $q $r} {
            set ($this,q) $q
        }
    }
    class F {
        proc F {this} {
            set ($this,x) 0
        }
    }
    new [new E {x y} z {1 2}]
    printArrays A:: B:: C:: D:: E:: F::
}
new [new Z::E {x y} z {1 2}]
printArrays Z::A:: Z::B:: Z::C:: Z::D:: Z::E:: Z::F::
