source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that optional arguments in constructors and multiple inheritance work together

# expected output:

## a::a 1
## b::b 1
## c::c 1
## z::a::(1,_derived) = ::z::c
## z::a::(1,m) = x y
## z::b::(1,_derived) = ::z::c
## z::b::(1,n) = z
## z::c::(1,o) = x y
## z::c::(1,p) = z
## c::~c 1
## b::~b 1
## a::~a 1
## a::a 2
## b::b 2
## c::c 2
## z::a::(2,_derived) = ::z::c
## z::a::(2,m) = 2
## z::b::(2,_derived) = ::z::c
## z::b::(2,n) = 3
## z::c::(2,o) = 2
## z::c::(2,p) = 3

## A::A 3
## B::B 3
## C::C 3
## A::(3,_derived) = ::Z::C
## A::(3,m) = x y
## B::(3,_derived) = ::Z::C
## B::(3,n) = z
## C::(3,o) = x y
## C::(3,p) = z
## C::~C 3
## B::~B 3
## A::~A 3
## A::A 4
## B::B 4
## C::C 4
## A::(4,_derived) = ::Z::C
## A::(4,m) = 2
## B::(4,_derived) = ::Z::C
## B::(4,n) = 3
## C::(4,o) = 2
## C::(4,p) = 3
## C::~C 4
## B::~B 4
## A::~A 4

## A::A 5
## B::B 5
## C::C 5
## Z::A::(5,_derived) = ::Z::C
## Z::A::(5,m) = x y
## Z::B::(5,_derived) = ::Z::C
## Z::B::(5,n) = z
## Z::C::(5,o) = x y
## Z::C::(5,p) = z
## C::~C 5
## B::~B 5
## A::~A 5
## A::A 6
## B::B 6
## C::C 6
## Z::A::(6,_derived) = ::Z::C
## Z::A::(6,m) = 2
## Z::B::(6,_derived) = ::Z::C
## Z::B::(6,n) = 3
## Z::C::(6,o) = 2
## Z::C::(6,p) = 3

class z {}
class z::a {}
proc z::a::a {this {p 0}} {
    puts "a::a $this"
    set ($this,m) $p
}
proc z::a::~a {this} {
    puts "a::~a $this"
}
class z::b {}
proc z::b::b {this {p 1}} {
    puts "b::b $this"
    set ($this,n) $p
}
proc z::b::~b {this} {
    puts "b::~b $this"
}
class z::c {}
proc z::c::c {this {p 2} {q 3}} z::a {$p} z::b {$q} {
    puts "c::c $this"
    set ($this,o) $p
    set ($this,p) $q
}
proc z::c::~c {this} {
    puts "c::~c $this"
}
set o [new z::c {x y} z]
printArrays z::a:: z::b:: z::c::
delete $o
set o [new z::c]
printArrays z::a:: z::b:: z::c::

class Z {
    class A {
        proc A {this {p 0}} {
            puts "A::A $this"
            set ($this,m) $p
        }
        proc ~A {this} {
            puts "A::~A $this"
        }
    }
    class B {
        proc B {this {p 1}} {
            puts "B::B $this"
            set ($this,n) $p
        }
        proc ~B {this} {
            puts "B::~B $this"
        }
    }
    class C {
        proc C {this {p 2} {q 3}} Z::A {$p} Z::B {$q} {
            puts "C::C $this"
            set ($this,o) $p
            set ($this,p) $q
        }
        proc ~C {this} {
            puts "C::~C $this"
        }
    }
    set o [new C {x y} z]
    printArrays A:: B:: C::
    delete $o
    set o [new C]
    printArrays A:: B:: C::
    delete $o
}
set o [new Z::C {x y} z]
printArrays Z::A:: Z::B:: Z::C::
delete $o
set o [new Z::C]
printArrays Z::A:: Z::B:: Z::C::
