source parray.tcl
source stooop.tcl
namespace import stooop::*

### check multiple inheritance destruction order and data deallocation with a common indirect base class

# expected output:

## a::a 1
## b::b 1
## c::c 1
## a::a 1
## b::b 1
## d::d 1
## e::e 1
## z::a::(1,_derived) = ::z::d
## z::a::(1,m) = z
## z::b::(1,_derived) = ::z::d
## z::b::(1,n) = z
## z::c::(1,_derived) = ::z::e
## z::c::(1,o) = 1 2
## z::d::(1,_derived) = ::z::e
## z::d::(1,p) = z
## z::e::(1,q) = z
## e::~e 1
## d::~d 1
## b::~b 1
## a::~a 1
## c::~c 1
## b::~b 1
## a::~a 1

## A::A 2
## B::B 2
## C::C 2
## A::A 2
## B::B 2
## D::D 2
## E::E 2
## A::(2,_derived) = ::Z::D
## A::(2,m) = z
## B::(2,_derived) = ::Z::D
## B::(2,n) = z
## C::(2,_derived) = ::Z::E
## C::(2,o) = 1 2
## D::(2,_derived) = ::Z::E
## D::(2,p) = z
## E::(2,q) = z
## E::~E 2
## D::~D 2
## B::~B 2
## A::~A 2
## C::~C 2
## B::~B 2
## A::~A 2

## A::A 3
## B::B 3
## C::C 3
## A::A 3
## B::B 3
## D::D 3
## E::E 3
## Z::A::(3,_derived) = ::Z::D
## Z::A::(3,m) = z
## Z::B::(3,_derived) = ::Z::D
## Z::B::(3,n) = z
## Z::C::(3,_derived) = ::Z::E
## Z::C::(3,o) = 1 2
## Z::D::(3,_derived) = ::Z::E
## Z::D::(3,p) = z
## Z::E::(3,q) = z
## E::~E 3
## D::~D 3
## B::~B 3
## A::~A 3
## C::~C 3
## B::~B 3
## A::~A 3

class z {}
class z::a {}
proc z::a::a {this p} {
    puts "a::a $this"
    set ($this,m) $p
}
proc z::a::~a {this} {
    puts "a::~a $this"
}
class z::b {}
proc z::b::b {this p} {
    puts "b::b $this"
    set ($this,n) $p
}
proc z::b::~b {this} {
    puts "b::~b $this"
}
class z::c {}
proc z::c::c {this p q r} z::a {$p} z::b {$q} {
    puts "c::c $this"
    set ($this,o) $r
}
proc z::c::~c {this} {
    puts "c::~c $this"
}
class z::d {}
proc z::d::d {this p q r} z::a {$p} z::b {$q} {
    puts "d::d $this"
    set ($this,p) $p
}
proc z::d::~d {this} {
    puts "d::~d $this"
}
class z::e {}
proc z::e::e {this p q r} z::c {$p $q $r} z::d {$q $q $r} {
    puts "e::e $this"
    set ($this,q) $q
}
proc z::e::~e {this} {
    puts "e::~e $this"
}
set o [new z::e {x y} z {1 2}]
printArrays z::a:: z::b:: z::c:: z::d:: z::e::
delete $o
printArrays z::a:: z::b:: z::c:: z::d:: z::e::

class Z {
    class A {
        proc A {this p} {
            puts "A::A $this"
            set ($this,m) $p
        }
        proc ~A {this} {
            puts "A::~A $this"
        }
    }
    class B {
        proc B {this p} {
            puts "B::B $this"
            set ($this,n) $p
        }
        proc ~B {this} {
            puts "B::~B $this"
        }
    }
    class C {
        proc C {this p q r} Z::A {$p} Z::B {$q} {
            puts "C::C $this"
            set ($this,o) $r
        }
        proc ~C {this} {
            puts "C::~C $this"
        }
    }
    class D {
        proc D {this p q r} Z::A {$p} Z::B {$q} {
            puts "D::D $this"
            set ($this,p) $p
        }
        proc ~D {this} {
            puts "D::~D $this"
        }
    }
    class E {
        proc E {this p q r} Z::C {$p $q $r} Z::D {$q $q $r} {
            puts "E::E $this"
            set ($this,q) $q
        }
        proc ~E {this} {
            puts "E::~E $this"
        }
    }
    set o [new E {x y} z {1 2}]
    printArrays A:: B:: C:: D:: E::
    delete $o
    printArrays A:: B:: C:: D:: E::
}
set o [new Z::E {x y} z {1 2}]
printArrays Z::A:: Z::B:: Z::C:: Z::D:: Z::E::
delete $o
printArrays Z::A:: Z::B:: Z::C:: Z::D:: Z::E::
