source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that multiply inherited base classes constructors work with variable number of arguments

# expected output:

## a::a 1 {1 2} 3
## b::b 1 x y
## c::c 1 x y {1 2} 3
## d::d 1 x y {1 2} 3
## z::a::(1,_derived) = ::z::d
## z::a::(1,m) = 1 2
## z::b::(1,_derived) = ::z::d
## z::b::(1,n) = x y
## z::c::(1,_derived) = ::z::d
## z::c::(1,o) = x y
## z::c::(1,p) = 1 2
## z::d::(1,q) = x y
## z::d::(1,r) = 1 2

## A::A 2 {1 2} 3
## B::B 2 x y
## C::C 2 x y {1 2} 3
## D::D 2 x y {1 2} 3
## A::(2,_derived) = ::Z::D
## A::(2,m) = 1 2
## B::(2,_derived) = ::Z::D
## B::(2,n) = x y
## C::(2,_derived) = ::Z::D
## C::(2,o) = x y
## C::(2,p) = 1 2
## D::(2,q) = x y
## D::(2,r) = 1 2

## A::A 3 {1 2} 3
## B::B 3 x y
## C::C 3 x y {1 2} 3
## D::D 3 x y {1 2} 3
## Z::A::(2,_derived) = ::Z::D
## Z::A::(2,m) = 1 2
## Z::A::(3,_derived) = ::Z::D
## Z::A::(3,m) = 1 2
## Z::B::(2,_derived) = ::Z::D
## Z::B::(2,n) = x y
## Z::B::(3,_derived) = ::Z::D
## Z::B::(3,n) = x y
## Z::C::(2,_derived) = ::Z::D
## Z::C::(2,o) = x y
## Z::C::(2,p) = 1 2
## Z::C::(3,_derived) = ::Z::D
## Z::C::(3,o) = x y
## Z::C::(3,p) = 1 2
## Z::D::(2,q) = x y
## Z::D::(2,r) = 1 2
## Z::D::(3,q) = x y
## Z::D::(3,r) = 1 2

class z {}
class z::a {}
proc z::a::a {this args} {
    puts "a::a $this $args"
    set ($this,m) [lindex $args 0]
}
class z::b {}
proc z::b::b {this p} {
    puts "b::b $this $p"
    set ($this,n) $p
}
class z::c {}
proc z::c::c {this p args} {
    puts "c::c $this $p $args"
    set ($this,o) $p
    set ($this,p) [lindex $args 0]
}
class z::d {}
proc z::d::d {this p args} z::a {$args} z::b {$p} z::c {$p $args} {
    puts "d::d $this $p $args"
    set ($this,q) $p
    set ($this,r) [lindex $args 0]
}
new z::d {x y} {1 2} 3
printArrays z::a:: z::b:: z::c:: z::d::

class Z {
    class A {
        proc A {this args} {
            puts "A::A $this $args"
            set ($this,m) [lindex $args 0]
        }
    }
    class B {
        proc B {this p} {
            puts "B::B $this $p"
            set ($this,n) $p
        }
    }
    class C {
        proc C {this p args} {
            puts "C::C $this $p $args"
            set ($this,o) $p
            set ($this,p) [lindex $args 0]
        }
    }
    class D {
        proc D {this p args} Z::A {$args} Z::B {$p} Z::C {$p $args} {
            puts "D::D $this $p $args"
            set ($this,q) $p
            set ($this,r) [lindex $args 0]
        }
    }
    new D {x y} {1 2} 3
    printArrays A:: B:: C:: D::
}
new Z::D {x y} {1 2} 3
printArrays Z::A:: Z::B:: Z::C:: Z::D::
