source parray.tcl
source stooop.tcl
namespace import stooop::*

### check that variable arguments in derived class work with base class constructor constant arguments

# expected output:

## a::a 1 {1 2} 3
## b::b 1 x y {1 2} 3
## a::(1,_derived) = ::b
## a::(1,m) = {1 2} 3

## A::A 2 {1 2} 3
## B::B 2 x y {1 2} 3
## A::(2,_derived) = ::B
## A::(2,m) = {1 2} 3

## d::d 3 {1 2} 3
## e::e 3 x y {1 2} 3
## c::d::(3,_derived) = ::c::e
## c::d::(3,m) = {1 2} 3

## D::D 4 {1 2} 3
## E::E 4 x y {1 2} 3
## D::(4,_derived) = ::C::E
## D::(4,m) = {1 2} 3

## D::D 5 {1 2} 3
## E::E 5 x y {1 2} 3
## C::D::(4,_derived) = ::C::E
## C::D::(4,m) = {1 2} 3
## C::D::(5,_derived) = ::C::E
## C::D::(5,m) = {1 2} 3

class a {}
proc a::a {this p} {
    puts "a::a $this $p"
    set ($this,m) $p
}
proc a::~a {this} {}
class b {}
proc b::b {this p args} a {$args} {
    puts "b::b $this $p $args"
}
proc b::~b {this} {}
new b {x y} {1 2} 3
printArrays a::

class A {
    proc A {this p} {
        puts "A::A $this $p"
        set ($this,m) $p
    }
    proc ~A {this} {}
}
class B {
    proc B {this p args} A {$args} {
        puts "B::B $this $p $args"
    }
    proc ~B {this} {}
}
new B {x y} {1 2} 3
printArrays A::

class c {}
class c::d {}
proc c::d::d {this p} {
    puts "d::d $this $p"
    set ($this,m) $p
}
proc c::d::~d {this} {}
class c::e {}
proc c::e::e {this p args} c::d {$args} {
    puts "e::e $this $p $args"
}
proc c::e::~e {this} {}
new c::e {x y} {1 2} 3
printArrays c::d::

class C {
    class D {
        proc D {this p} {
            puts "D::D $this $p"
            set ($this,m) $p
        }
        proc ~D {this} {}
    }
    class E {
        proc E {this p args} C::D {$args} {
            puts "E::E $this $p $args"
        }
        proc ~E {this} {}
    }
    new E {x y} {1 2} 3
    printArrays D::
}
new C::E {x y} {1 2} 3
printArrays C::D::
