source stooop.tcl
namespace import stooop::*

### check that embedded command in base class constructor arguments does not interfere with variable number of arguments processing
### special case

# expected output:

class a {}
proc a::a {this p args} {}
proc a::~a {this} {}
class b {}
proc b::b {this args} a {[list {}] $args} {}
proc b::b {this args} a {[list {}] $args } {}
proc b::b {this args} a {
    [list {}] $args
} {}

class A {
    proc A {this p args} {}
    proc ~A {this} {}
}
class B {
    proc B {this args} A {[list {}] $args} {}
    proc B {this args} A {[list {}] $args } {}
    proc B {this args} A {
        [list {}] $args
    } {}
}

class c {}
class c::d {}
proc c::d::d {this p args} {}
proc c::d::~d {this} {}
class c::e {}
proc c::e::e {this args} c::d {[list {}] $args} {}
proc c::e::e {this args} c::d {[list {}] $args } {}
proc c::e::e {this args} c::d {
    [list {}] $args
} {}

class C {
    class D {
        proc D {this p args} {}
        proc ~D {this} {}
    }
    class E {
        proc E {this args} C::D {[list {}] $args} {}
        proc E {this args} C::D {[list {}] $args } {}
        proc E {this args} C::D {
            [list {}] $args
        } {}
    }
}
