source stooop.tcl
namespace import stooop::*

### check copy constructor base class(es) initialization errors

# expected output:
## missing base class ::a constructor arguments from class ::b constructor
## missing base class ::A constructor arguments from class ::B constructor
## missing base class ::c::d constructor arguments from class ::c::e constructor
## missing base class ::C::D constructor arguments from class ::C::E constructor

catch {
    class a {}
    proc a::a {this p} {}
    class b {}
    proc b::b {this} a 0 {}
    proc b::b {this copy} {}
    new [new b]
} message
puts $message

catch {
    class A {
        proc A {this p} {}
    }
    class B {
        proc B {this} A 0 {}
        proc B {this copy} {}
    }
    new [new B]
} message
puts $message

catch {
    class c {}
    class c::d {}
    proc c::d::d {this p} {}
    class c::e {}
    proc c::e::e {this} c::d 0 {}
    proc c::e::e {this copy} {}
    new [new c::e]
} message
puts $message

catch {
    class C {
        class D {
            proc D {this p} {}
        }
        class E {
            proc E {this} C::D 0 {}
            proc E {this copy} {}
        }
        new [new E]
    }
} message
puts $message
