source parray.tcl
source stooop.tcl
namespace import stooop::*

### check basic cloning operation with array members

# expected output:

## a::(1,y) = 1
## a::(2,y) = 1
## a::1x(0) = 0
## a::2x(0) = 0
## A::(3,y) = 1
## A::(4,y) = 1
## A::3x(0) = 0
## A::4x(0) = 0

## b::c::(5,y) = 1
## b::c::(6,y) = 1
## b::c::5x(0) = 0
## b::c::6x(0) = 0
## C::(7,y) = 1
## C::(8,y) = 1
## C::7x(0) = 0
## C::8x(0) = 0
## B::C::(10,y) = 1
## B::C::(7,y) = 1
## B::C::(8,y) = 1
## B::C::(9,y) = 1
## B::C::9x(0) = 0
## B::C::10x(0) = 0

class a {}
proc a::a {this} {
    variable ${this}x
    set ${this}x(0) 0
    set ($this,y) 1
}
proc a::a {this copy} {
    variable ${this}x
    variable ${copy}x
    array set ${this}x [array get ${copy}x]
    set ($this,y) $($copy,y)
}
new [new a]
printArrays a:: a::1x a::2x

class A {
    proc A {this} {
        variable ${this}x
        set ${this}x(0) 0
        set ($this,y) 1
    }
    proc A {this copy} {
        variable ${this}x
        variable ${copy}x
        array set ${this}x [array get ${copy}x]
        set ($this,y) $($copy,y)
    }
}
new [new A]
printArrays A:: A::3x A::4x

class b {}
class b::c {}
proc b::c::c {this} {
    variable ${this}x
    set ${this}x(0) 0
    set ($this,y) 1
}
proc b::c::c {this copy} {
    variable ${this}x
    variable ${copy}x
    array set ${this}x [array get ${copy}x]
    set ($this,y) $($copy,y)
}
new [new b::c]
printArrays b::c:: b::c::5x b::c::6x

class B {
    class C {
        proc C {this} {
            variable ${this}x
            set ${this}x(0) 0
            set ($this,y) 1
        }
        proc C {this copy} {
            variable ${this}x
            variable ${copy}x
            array set ${this}x [array get ${copy}x]
            set ($this,y) $($copy,y)
        }
    }
    new [new C]
    printArrays C:: C::7x C::8x
}
new [new B::C]
printArrays B::C:: B::C::9x B::C::10x
